#include "tagarg.h"
#include "mainwindow.h"

class TagargPrivate
{
public:
    MainWindow *main;
};

Tagarg::Tagarg( const SAboutData & parent ) :
    SApplication( parent )
{
    p = new TagargPrivate;
    p->main = new MainWindow( this );
}

void Tagarg::runtimeArgsEvent( const QVariantList & args )
{
    QStringList files;
    for( int i=0 ; i<args.count() ; i++ )
    {
        QVariant var = args.at(i);
        if( var.type() != QVariant::String )
            return;

        QString str = var.toString();

        if(      str.left(5) == "-play" )
            p->main->playPause();

        else if( str.left(9) == "-previous" )
            p->main->previous();

        else if( str.left(5) == "-next" )
            p->main->next();

        else if( str.left(5) == "-stop" )
            p->main->stop();

        else if( str.left(11) == "-add-widget" )
        {
            if( i+1 >= args.count() )
                return;

            QVariant var2 = args.at(i+1);
            if( QString(var2.typeName()) != "QWidget*" )
                return;
            i++;

            if( i+1 < args.count() && args.at(i+1).type() == QVariant::Int )
            {
                p->main->addWidget( qvariant_cast<QWidget*>(var2) , args.at(i+1).toInt() , SWidgetManager::PIXEL );
                i++;
            }
            else
                p->main->addWidget( qvariant_cast<QWidget*>(var2) );
        }

        else if( str.left(14) == "-insert-widget" )
        {
            if( i+2 >= args.count() )
                return;

            QVariant var2 = args.at(i+1);
            QVariant var3 = args.at(i+2);
            if( var2.type() != QVariant::Int || QString(var3.typeName()) != "QWidget*" )
                return;
            i++;
            i++;

            if( i+1 < args.count() && args.at(i+1).type() == QVariant::Int )
            {
                p->main->insertWidget( var2.toInt() , qvariant_cast<QWidget*>(var3) , args.at(i+1).toInt() , SWidgetManager::PIXEL );
                i++;
            }
            else
                p->main->insertWidget( var2.toInt() , qvariant_cast<QWidget*>(var3) );
        }

        else if( str.left(14) == "-remove-widget" )
        {
            if( i+1 >= args.count() )
                return;

            QVariant var2 = args.at(i+1);
            if( QString(var2.typeName()) != "QWidget*" )
                return;
            i++;

            p->main->removeWidget( qvariant_cast<QWidget*>(var2) );
        }

        else
            files << str;
    }

    p->main->addToListAndPlay( files );
}

Tagarg::~Tagarg()
{
    delete p;
}
