#define MUSIC_PLAYER "Tagarg"

#include "loaderengine.h"

#include <Silicon>
#include <QDebug>

LoaderEngine::LoaderEngine(QObject *parent) :
    QObject(parent)
{
    lyrics = 0;
    Silicon::applicationLoadedSignal( this , SLOT(applicationLoaded(QString)) );

    applicationLoaded( MUSIC_PLAYER );
}

void LoaderEngine::applicationLoaded( const QString & name )
{
    if( name != MUSIC_PLAYER || lyrics )
        return;

    const QList<SAboutData> & abouts = Silicon::loadedApps();
    for( int i=0 ; i<abouts.count() ; i++ )
        if( abouts.at(i).name() == MUSIC_PLAYER )
        {
            lyrics = new Lyrics();
            connect( lyrics , SIGNAL(destroyed()) , SLOT(lyricsDestroyed()) );

            Silicon::sendArgument( i , QVariantList()<<"-add-widget" <<QVariant::fromValue(static_cast<QWidget*>(lyrics)) );
        }
}

void LoaderEngine::lyricsDestroyed()
{
    lyrics = 0;
}

LoaderEngine::~LoaderEngine()
{
    if( lyrics )
    {
        const QList<SAboutData> & abouts = Silicon::loadedApps();
        for( int i=0 ; i<abouts.count() ; i++ )
            if( abouts.at(i).name() == MUSIC_PLAYER )
                Silicon::sendArgument( i , QVariantList()<<"-remove-widget" <<QVariant::fromValue(static_cast<QWidget*>(lyrics)) );

        delete lyrics;
    }
}
