///////////////////////////////////////////////////////////////////////////////
// This file contains declaration of class that will be responsible
// for downloading lyrics.
///////////////////////////////////////////////////////////////////////////////

/*
 * This class is part of Lyrics Project.
 * Project: Lyrics
 * Author: Sinis
 * Created: 24.08.2010
 * Description: Lyrics is a simple application that downloads lyrics
 *  of a specified by the user song.
 *
 * Lyrics is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Lyrics is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Lyrics.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef LYRICDOWNLOADER_H
#define LYRICDOWNLOADER_H

#include <QObject>
#include <QNetworkAccessManager>

class LyricDownloader: public QObject
{
    Q_OBJECT

public:
    LyricDownloader(QObject *parent = 0);
    ~LyricDownloader();

    enum State
    {
        Idle,
        ResolvingArtistName,
        ResolvingTrackName,
        DownloadingLyrics
    };
    enum Error
    {
        ArtistNotFound,
        TrackNotFound,
        NetworkError
    };

    State GetState() const { return _state; }
    QString ErrorString() const;

public slots:
    void Download(const QString &artist, const QString &track);
    void Abort();

signals:
    void StateChanged(LyricDownloader::State state);
    void Failed(LyricDownloader::Error error);
    void Downloaded(QString lyrics);

private slots:
    void ChangeState(State state);
    void RequestFinished(QNetworkReply *reply);
    void FixString(QString &str);
    bool FindAndCopy(QString &what, const QString &in);

private:
    QNetworkAccessManager *_network;
    QNetworkReply *_current;
    State _state;
    QString _artist;
    QString _track;
    QString _lyrics;
};

#endif // LYRICDOWNLOADER_H ////////////////////////////////////////////////////////
