#ifndef LYRICS_H
#define LYRICS_H

#include "lyricdownloader.h"

#include <QTextBrowser>
#include <phonon/mediaobject.h>
#include <phonon/audiooutput.h>

class LyricsPrivate;
class Lyrics : public QTextBrowser
{
    Q_OBJECT
public:
    Lyrics(QWidget *parent = 0);
    ~Lyrics();

    Q_INVOKABLE void init( const Phonon::AudioOutput *audio , const Phonon::MediaObject *media , const Phonon::Path *path , const QStringList *playlist );
    Q_INVOKABLE void playing( const QString & file );

private slots:
    void statusChanged( LyricDownloader::State state );
    void error( LyricDownloader::Error error );

protected:
    void resizeEvent( QResizeEvent *event );

private:
    LyricsPrivate *p;
};

#endif // LYRICS_H
