#define MUSIC_PLAYER "Tagarg"

#include "loaderengine.h"

#include <Silicon>
#include <QDebug>

LoaderEngine::LoaderEngine(QObject *parent) :
    QObject(parent)
{
    now_playing = 0;
    Silicon::applicationLoadedSignal( this , SLOT(applicationLoaded(QString)) );

    applicationLoaded( MUSIC_PLAYER );
}

void LoaderEngine::applicationLoaded( const QString & name )
{
    if( name != MUSIC_PLAYER || now_playing )
        return;

    const QList<SAboutData> & abouts = Silicon::loadedApps();
    for( int i=0 ; i<abouts.count() ; i++ )
        if( abouts.at(i).name() == MUSIC_PLAYER )
        {
            now_playing = new NowPlaying();
            connect( now_playing , SIGNAL(destroyed()) , SLOT(lyricsDestroyed()) );

            Silicon::sendArgument( i , QVariantList()<<"-insert-widget" << 0 << QVariant::fromValue(static_cast<QWidget*>(now_playing)) << 193 );
        }
}

void LoaderEngine::lyricsDestroyed()
{
    now_playing = 0;
}

LoaderEngine::~LoaderEngine()
{
    if( now_playing )
    {
        const QList<SAboutData> & abouts = Silicon::loadedApps();
        for( int i=0 ; i<abouts.count() ; i++ )
            if( abouts.at(i).name() == MUSIC_PLAYER )
                Silicon::sendArgument( i , QVariantList()<<"-remove-widget" <<QVariant::fromValue(static_cast<QWidget*>(now_playing)) );

        delete now_playing;
    }
}
