#define MUSIC_PLAYER "Tagarg"

#include "loaderengine.h"

#include <Silicon>
#include <QDebug>

LoaderEngine::LoaderEngine(QObject *parent) :
    QObject(parent)
{
    tagarg_audio = 0;
    Silicon::applicationLoadedSignal( this , SLOT(applicationLoaded(QString)) );

    applicationLoaded( MUSIC_PLAYER );
}

void LoaderEngine::applicationLoaded( const QString & name )
{
    if( name != MUSIC_PLAYER || tagarg_audio )
        return;

    const QList<SAboutData> & abouts = Silicon::loadedApps();
    for( int i=0 ; i<abouts.count() ; i++ )
        if( abouts.at(i).name() == MUSIC_PLAYER )
        {
            tagarg_audio = new TagargAudioDisc();
            connect( tagarg_audio , SIGNAL(destroyed()) , SLOT(lyricsDestroyed()) );

            Silicon::sendArgument( i , QVariantList()<<"-add-widget" << QVariant::fromValue(static_cast<QWidget*>(tagarg_audio)) << 37 );
        }
}

void LoaderEngine::lyricsDestroyed()
{
    tagarg_audio = 0;
}

LoaderEngine::~LoaderEngine()
{
    if( tagarg_audio )
    {
        const QList<SAboutData> & abouts = Silicon::loadedApps();
        for( int i=0 ; i<abouts.count() ; i++ )
            if( abouts.at(i).name() == MUSIC_PLAYER )
                Silicon::sendArgument( i , QVariantList()<<"-remove-widget" <<QVariant::fromValue(static_cast<QWidget*>(tagarg_audio)) );

        delete tagarg_audio;
    }
}
