#include "tagargaudiodisc.h"

#include <QPainter>
#include <QPaintEvent>
#include <QPainterPath>
#include <QToolButton>
#include <QHBoxLayout>

#include <SColor>
#include <Silicon>

class NowPlayingPrivate
{
public:
    const QStringList *playlist;
    QString current;

    QToolButton *add_audiodisc_btn;
    QHBoxLayout *layout;
};

TagargAudioDisc::TagargAudioDisc(QWidget *parent) :
    QWidget(parent)
{
    p = new NowPlayingPrivate;

    p->add_audiodisc_btn = new QToolButton();
        p->add_audiodisc_btn->setText( tr("Burn Playlist") );
        p->add_audiodisc_btn->setIcon( QIcon(":/plugins/TagargAudioDisc/audiodisc.png") );
        p->add_audiodisc_btn->setToolButtonStyle( Qt::ToolButtonTextBesideIcon );
        p->add_audiodisc_btn->setAutoRaise( true );
        p->add_audiodisc_btn->setIconSize( QSize(25,25) );

    p->layout = new QHBoxLayout( this );
        p->layout->addStretch();
        p->layout->addWidget( p->add_audiodisc_btn );
        p->layout->setContentsMargins( 4 , 4 , 4 , 4 );

    connect( p->add_audiodisc_btn , SIGNAL(clicked()) , SLOT(addToAudioDisc()) );
}

void TagargAudioDisc::init( const Phonon::AudioOutput *audio , const Phonon::MediaObject *media , const Phonon::Path *path , const QStringList *playlist )
{
    Q_UNUSED( audio )
    Q_UNUSED( path  )

    p->playlist = playlist;
    playing( media->currentSource().fileName() );
}

void TagargAudioDisc::playing( const QString & file )
{
    p->current = file;
}

void TagargAudioDisc::paintEvent( QPaintEvent * )
{
    QRect rct;
        rct.setX( 2 );
        rct.setY( 2 );
        rct.setWidth( rect().width()-4 );
        rct.setHeight( rect().height()-4 );

    SColor back_color( palette().highlight().color() );
        back_color.setAlpha( 37 );

    SColor border_color( palette().highlight().color() );
        border_color.setAlpha( 137 );

    QPainterPath path;
        path.addRoundRect( rct , 5 );

    QPainter painter( this );
        painter.setPen( border_color );
        painter.setRenderHint( QPainter::Antialiasing );
        painter.fillPath( path , back_color );
        painter.drawPath( path );
}

void TagargAudioDisc::resizeEvent( QResizeEvent * )
{
}

void TagargAudioDisc::addToAudioDisc()
{
    QVariantList args;
    for( int i=0 ; i<p->playlist->count() ; i++ )
        args << p->playlist->at(i);

    Silicon::loadApp( "AudioDisc" , args );
}

TagargAudioDisc::~TagargAudioDisc()
{
    delete p;
}
