/*
 *      Compatibility stuff among operating systems and compilers.
 *
 *      Copyright (c) 2005-2007 Naoaki Okazaki
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 *
 */

/* $Id: os.h 328 2007-02-10 17:50:11Z nyaochi $ */

#ifndef	__OS_H__
#define	__OS_H__

#ifdef	_MSC_VER
#define	HAVE_STRING_H 1
#endif/*_MSC_VER*/

#if		_MSC_VER >= 1400
#define	_CRT_SECURE_NO_DEPRECATE	1	/* Use 'unsafe' CRT routines. */
#endif/*_MSC_VER*/

#include <stdio.h>
#include <pmplib/os_types.h>


#if		defined(WIN32)
#define	fileno		_fileno
#define	strnicmp	_strnicmp
#define	snprintf	_snprintf
#define snwprintf	_snwprintf
#define	strdup		_strdup
#define	getcwd		_getcwd
#define	alloca		_alloca
#define	strnicmp	_strnicmp

#define	PATHCHAR	'\\'
#define	PATHSTR		"\\"

#else

/**
 * The native path separator for the current system, as a character.
 */
#define	PATHCHAR	'/'

/**
 * The native path separator for the current system, as a string.
 */
#define	PATHSTR		"/"

#endif

#if		defined(WIN32)
#include <windows.h>

#elif	defined(bsdi) || defined(FREEBSD) || defined(OPENBSD)
#include <sys/param.h>
#define	MAX_PATH	MAXPATHLEN

#else
#include <limits.h>
#define	MAX_PATH	PATH_MAX

#endif

#endif/*__OS_H__*/
