/**
 * Playlist class object.
 */
Playlist.prototype = new Array();

function Playlist() {
	/**
	 * Order tracks in an arbitrary order specified by the arguments.
	 *	This method sorts tracks in an arbitrary order by comparing field(s) in
	 *	
	 *	@param	[arguments]		Field name(s) used for sorting tracks.
	 */
	this.order = function()
	{
		// Extract field names for the comparison from the arguments.
		var fields = arguments;

		// Sort the elements by using an anonymous function for the comparison.
		return this.sort(
			function(x, y) {
				var ret = 0;				// Comparison result.
				// Loop over field names.
				for (var i = 0;i < fields.length;++i) {
					var coeff = 1;			// Sorting direction.
					var field = fields[i];	// Field name for sorting.
					if (field[0] == '-') {
						coeff = -1;
						field = field.slice(1);
					} else {
						coeff = +1;
					}

					// Compare field values of two objects, x and y.
					ret = ((x[field])>(y[field]))-((x[field])<(y[field]));
					// Inverse the result when descending sort.
					ret *= coeff;

					// Exit if the two values are not identical.
					if (ret != 0) {
						break;
					}
				}
				// Return the comparison result.
				return ret;
			}
		);
	};

	this.shuffle = function()
	{
		// Assign a random number for each track.
		for (var i = 0;i < this.length;++i) {
			this[i].order = Math.random();
		}

		// Arrange the tracks in a numerical order of the assigned numbers.
		this.sort(
			function(x, y) {
				return ((x.order)>(y.order))-((x.order)<(y.order));
			}
		);

		// Remove the assigned number from each track.
		for (var i = 0;i < this.length;++i) {
			delete this[i].order;
		}
	};
}
