/*
 *      Common routines for tag and audio information retrieval.
 *
 *      Copyright (c) 2005-2007 Naoaki Okazaki
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA, or visit
 * http://www.gnu.org/copyleft/gpl.html .
 *
 */

/* $Id: pmp.c 328 2007-02-10 17:50:11Z nyaochi $ */

#ifdef	HAVE_CONFIG_H
#include <config.h>
#endif/*HAVE_CONFIG_H*/

#include <os.h>
#ifdef HAVE_STRING_H
#include <string.h>
#endif/*HAVE_STRING_H*/

#include <pmplib/ucs2char.h>
#include <pmplib/pmp.h>

void pmplib_record_init(pmp_music_record_t* record)
{
	memset(record, 0, sizeof(*record));

}

void pmplib_record_finish(pmp_music_record_t* record)
{
	ucs2free(record->filename);
	ucs2free(record->title);
	ucs2free(record->artist);
	ucs2free(record->album);
	ucs2free(record->genre);
	ucs2free(record->date);
	pmplib_record_init(record);
}

result_t pmplib_record_clone(pmp_music_record_t* dst, const pmp_music_record_t* src)
{
	memcpy(dst, src, sizeof(*src));
	dst->filename = src->filename ? ucs2dup(src->filename) : NULL;
	dst->title = src->title ? ucs2dup(src->title) : NULL;
	dst->artist = src->artist ? ucs2dup(src->artist) : NULL;
	dst->album = src->album ? ucs2dup(src->album) : NULL;
	dst->genre = src->genre ? ucs2dup(src->genre) : NULL;
	dst->date = src->date ? ucs2dup(src->date) : NULL;
	return 0;
}

void pmplib_records_finish(pmp_music_record_t* records, int num_records)
{
	if (records) {
		int i;
		for (i = 0;i < num_records;++i) {
			pmplib_record_finish(&records[i]);
		}
		ucs2free(records);
	}
}

result_t pmplib_records_clone(pmp_music_record_t* dst, const pmp_music_record_t* src, int num_records)
{
	int i;
	for (i = 0;i < num_records;++i) {
		pmplib_record_clone(&dst[i], &src[i]);
	}
	return 0;
}

void pmplib_playlist_init(pmp_playlist_t* playlist)
{
	memset(playlist, 0, sizeof(*playlist));
}

void pmplib_playlist_finish(pmp_playlist_t* playlist)
{
	int i;
	for (i = 0;i < playlist->num_entries;++i) {
		ucs2free(playlist->entries[i]);
	}
	ucs2free(playlist->entries);
	ucs2free(playlist->name);
}

void pmplib_playlist_clone(pmp_playlist_t* dst, const pmp_playlist_t* src)
{
	int i;

	dst->name = ucs2dup(src->name);
	dst->num_entries = src->num_entries;
	dst->entries = (ucs2char_t**)ucs2calloc(sizeof(ucs2char_t*) * src->num_entries);
	for (i = 0;i < src->num_entries;++i) {
		dst->entries[i] = ucs2dup(src->entries[i]);
	}
}

void pmplib_playlists_finish(pmp_playlist_t* playlists, int num_playlists)
{
	if (playlists) {
		int i;
		for (i = 0;i < num_playlists;++i) {
			pmplib_playlist_finish(&playlists[i]);
		}
		ucs2free(playlists);
	}
}

void pmplib_playlists_clone(pmp_playlist_t* dst, const pmp_playlist_t* src, int num_playlists)
{
	int i;
	for (i = 0;i < num_playlists;++i) {
		pmplib_playlist_clone(&dst[i], &src[i]);
	}
}
