/*
 *      Low level interface for dat (e.g., U10.dat).
 *
 *      Copyright (c) 2005-2007 Naoaki Okazaki
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 *
 */

/* $Id: dat.c 328 2007-02-10 17:50:11Z nyaochi $ */

#ifdef	HAVE_CONFIG_H
#include <config.h>
#endif/*HAVE_CONFIG_H*/
#ifdef	HAVE_STRING_H
#include <string.h>
#endif/*HAVE_STRING_H*/

#include <os.h>
#include <stdio.h>
#include <stdlib.h>
#include <pmplib/ucs2char.h>

#include "util.h"
#include "serialize.h"
#include "ip2db.h"

void dat_init(dat_t* dat)
{
	memset(dat, 0, sizeof(*dat));
	dat->unknown2 = 0x0A;
}

size_t dat_serialize(dat_t* dat, uint8_t* buffer, int is_storing)
{
	int i;
	uint8_t *p = buffer;

	p += serialize_uint32be(p, &dat->entry_number, is_storing);

	p += serialize_ucs2be_string_fixed(p, dat->filename, 8, is_storing) * sizeof(ucs2char_t);
	p += serialize_ucs2be_string_fixed(p, dat->title, 8, is_storing) * sizeof(ucs2char_t);
	p += serialize_ucs2be_string_fixed(p, dat->artist, 8, is_storing) * sizeof(ucs2char_t);
	p += serialize_ucs2be_string_fixed(p, dat->album, 8, is_storing) * sizeof(ucs2char_t);
	p += serialize_ucs2be_string_fixed(p, dat->genre, 8, is_storing) * sizeof(ucs2char_t);
	
	p += serialize_uint32be(p, &dat->rating, is_storing);
	p += serialize_uint32be(p, &dat->play_count, is_storing);
	p += serialize_uint32be(p, &dat->recent_play, is_storing);

	p += serialize_uint32be(p, &dat->format, is_storing);
	p += serialize_uint32be(p, &dat->track_number, is_storing);
	p += serialize_uint32be(p, &dat->unknown5, is_storing);
	p += serialize_uint32be(p, &dat->year, is_storing);
	p += serialize_uint32be(p, &dat->filesize, is_storing);
	p += serialize_uint32be(p, &dat->duration, is_storing);
	p += serialize_uint32be(p, &dat->sample_rate, is_storing);
	p += serialize_uint32be(p, &dat->bitrate, is_storing);
	p += serialize_uint32be(p, &dat->timestamp, is_storing);

	p += serialize_uint8_array(p, dat->unknown1, 156, is_storing);

	for (i = 0;i < IP2DBDAT_IDX_LAST;++i) {
		p += serialize_uint16be(p, &dat->idx_item_field_access[i].offset, is_storing);
		p += serialize_uint16be(p, &dat->idx_item_field_access[i].size, is_storing);
	}
	p += serialize_uint8(p, &dat->unknown2, is_storing);
	p += serialize_uint16be(p, &dat->idx_item_size, is_storing);
	p += serialize_uint8(p, &dat->idx_item_index, is_storing);
	p += serialize_uint8(p, &dat->unknown3, is_storing);
	p += serialize_uint16be(p, &dat->idx_item_page, is_storing);

	return (size_t)(p - buffer);
}

void dat_dump(dat_t* dat, FILE *fp)
{
	int i;

	fprintf(fp, "  entry_number: %d\n", dat->entry_number);
	fprints_fixed(fp, "  filename: %s\n", dat->filename, 8);
	fprints_fixed(fp, "  title: %s\n", dat->title, 8);
	fprints_fixed(fp, "  artist: %s\n", dat->artist, 8);
	fprints_fixed(fp, "  album: %s\n", dat->album, 8);
	fprints_fixed(fp, "  genre: %s\n", dat->genre, 8);
	fprintf(fp, "  rating: %d\n", dat->rating);
	fprintf(fp, "  play_count: %d\n", dat->play_count);
	fprintt(fp, "  recent_play: %s", dat->recent_play);
	fprintf(fp, "  format: %d\n", dat->format);
	fprintf(fp, "  track_number: %d\n", dat->track_number);
	fprintf(fp, "  unknown5: %d\n", dat->unknown5);
	fprintf(fp, "  year: %d\n", dat->year);
	fprintf(fp, "  filesize: %d\n", dat->filesize);
	fprintf(fp, "  duration: %d\n", dat->duration);
	fprintf(fp, "  sample_rate: %d\n", dat->sample_rate);
	fprintf(fp, "  bitrate: %d\n", dat->bitrate);
	fprintf(fp, "  timestamp: %d\n", dat->timestamp);
	fprintf(fp, "  unknown1: %s\n", (is_all_value(dat->unknown1, 156, 0) ? "(all zero)": "(non-zero)"));
	for (i = 0;i < IP2DBDAT_IDX_LAST;++i) {
		fprintf(
			fp,
			"  idx_item_field_access[%d]: {offset: 0x%X; size: 0x%X}\n",
			i,
			dat->idx_item_field_access[i].offset,
			dat->idx_item_field_access[i].size
			);
	}
	fprintf(fp, "  unknown2: 0x%02X\n", dat->unknown2);
	fprintf(fp, "  idx_item_size: 0x%X\n", dat->idx_item_size);
	fprintf(fp, "  idx_item_index: %d\n", dat->idx_item_index);
	fprintf(fp, "  unknown3: 0x%02X\n", dat->unknown3);
	fprintf(fp, "  idx_item_page: %d\n", dat->idx_item_page);
}
