/*
 *      Miscellaneous utilities.
 *
 *      Copyright (c) 2005-2007 Naoaki Okazaki
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 *
 */

/* $Id: util.c 328 2007-02-10 17:50:11Z nyaochi $ */

#ifdef	HAVE_CONFIG_H
#include <config.h>
#endif/*HAVE_CONFIG_H*/
#ifdef	HAVE_STRING_H
#include <string.h>
#endif/*HAVE_STRING_H*/

#include <os.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <pmplib/ucs2char.h>

#include "util.h"

int is_all_value(uint8_t* array, size_t size, uint8_t value)
{
	size_t i;
	for (i = 0;i < size;i++) {
		if (array[0] != value) {
			return 0;
		}
	}
	return 1;
}

void fprints(FILE *fp, const char *format, const ucs2char_t* value)
{
	fprints_fixed(fp, format, value, ucs2len(value));
}

void fprints_fixed(FILE *fp, const char *format, const ucs2char_t* value, size_t length)
{
	char *mbs = NULL;
	ucs2char_t* tmp = alloca(sizeof(ucs2char_t) * (length+1));
	memset(tmp, 0, sizeof(ucs2char_t) * (length+1));
	ucs2ncpy(tmp, value, length);
	mbs = ucs2dupmbs(tmp);
	if (mbs) {
		fprintf(fp, format, mbs);
		ucs2free(mbs);
	}
}

void prints_fixed(FILE *fp, const ucs2char_t* value, size_t length)
{
	size_t i;

	for (i = 0;i < length;++i) {
		if (value[i]) {
			char mbs[8];
			memset(mbs, 0, sizeof(mbs));
			ucs2tombs(mbs, sizeof(mbs), &value[i], 1);
			fprintf(fp, mbs);
		} else {
			fprintf(fp, " ");
		}
	}
}

void fprintt(FILE *fp, const char *format, uint32_t value)
{
	static time_t basetime = 0;	/* Basetime (static variable). */
	time_t timer = 0;

	/* Initialize basetime (Sat Jan 01 00:00:00 2000) for the first time. */
	if (basetime == 0) {
		struct tm bt;
		memset(&bt, 0, sizeof(bt));
		bt.tm_year = 2000 - 1900;
		bt.tm_mon = 1 - 1;
		bt.tm_mday = 1;
		bt.tm_hour = 0;
		bt.tm_min = 0;
		bt.tm_sec = 0;
		basetime = mktime(&bt);
	}

	timer = basetime + (time_t)value;
	fprintf(fp, format, asctime(gmtime(&timer)));
}

void print_keystr(FILE *fp, const ucs2char_t* value, size_t length)
{
	size_t i;

	for (i = 0;i < length;++i) {
		if (value[i] != 0xFFFF) {
			break;
		}
	}
	if (i < length) {
		fprintf(fp, "\"");
		prints_fixed(fp, value, length);
		fprintf(fp, "\"");
	} else {
		fprintf(fp, "LAST");
	}
}

void print_next(FILE *fp, const uint32_t value, uint8_t height)
{
	fprintf(fp, "%s%d", (height > 0 ? "@" : ""), value);
}

result_t fread_all(FILE *fp, uint8_t** ptr_buffer, long* ptr_size)
{
	uint8_t* buffer = NULL;
	long size = 0;

	/* Obtain the stream size. */
	if (fseek(fp, 0, SEEK_END) != 0) {
		return 1;
	}
	if ((size = ftell(fp)) == -1) {
		return 1;
	}
	if (fseek(fp, 0, SEEK_SET) != 0) {
		return 1;
	}

	/* */
	buffer = (uint8_t*)malloc(size);

	fread(buffer, 1, size, fp);

	*ptr_buffer = buffer;
	*ptr_size = size;
	return 0;
}
