/*
 *      Miscellaneous utilities.
 *
 *      Copyright (c) 2005-2007 Naoaki Okazaki
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 *
 */

/* $Id: util.h 328 2007-02-10 17:50:11Z nyaochi $ */

#ifndef	__IP2DB_UTIL_H__
#define	__IP2DB_UTIL_H__

int is_all_value(uint8_t* array, size_t size, uint8_t value);

void fprints(FILE *fp, const char *format, const ucs2char_t* value);
void fprints_fixed(FILE *fp, const char *format, const ucs2char_t* value, size_t length);
void prints_fixed(FILE *fp, const ucs2char_t* value, size_t length);
void fprintt(FILE *fp, const char *format, uint32_t value);
void print_keystr(FILE *fp, const ucs2char_t* value, size_t length);
void print_next(FILE *fp, const uint32_t value, uint8_t height);

result_t fread_all(FILE *fp, uint8_t** ptr_buffer, long* ptr_size);

#endif/*__IP2DB_UTIL_H__*/
