/*
 *      Low-level library for db.idx.
 *
 *      Copyright (c) 2005-2007 Naoaki Okazaki
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 *
 */

/* $Id: idx.h 328 2007-02-10 17:50:11Z nyaochi $ */

#ifndef	__IP3DB_IDX_H__
#define	__IP3DB_IDX_H__

struct tag_avl_t;	typedef struct tag_avl_t avl_t;

struct tag_idx_t {
	avl_t*		avl;
};

idx_t *idx_new();
void idx_finish(idx_t* idx);
result_t idx_read(idx_t* idx, dic_t* dic, FILE *fpi);
result_t idx_write(idx_t* idx, dic_t* dic, FILE *fpo);
result_t idx_dump(idx_t* idx, dic_t* dic, FILE *fpo);
result_t idx_construct(idx_t* idx, dic_t* dic, dat_t* dat);


#endif/*__IP3DB_IDX_H__*/
