/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.jpeg;

import com.frostwire.jpeg.ImageInputStreamAdapter;
import com.frostwire.jpeg.JFIFInputStream;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedList;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;

public class CMYKJPEGImageReader
extends ImageReader {
    private boolean isYCCKInversed = true;
    private static DirectColorModel RGB = new DirectColorModel(24, 0xFF0000, 65280, 255, 0);
    private BufferedImage image;
    private static final int SCALEBITS = 16;
    private static final int MAXJSAMPLE = 255;
    private static final int CENTERJSAMPLE = 128;
    private static final int ONE_HALF = 32768;
    private static final int[] Cr_r_tab = new int[256];
    private static final int[] Cb_b_tab = new int[256];
    private static final int[] Cr_g_tab = new int[256];
    private static final int[] Cb_g_tab = new int[256];

    public CMYKJPEGImageReader(ImageReaderSpi imageReaderSpi) {
        super(imageReaderSpi);
    }

    @Override
    public int getNumImages(boolean bl) throws IOException {
        return 1;
    }

    @Override
    public int getWidth(int n) throws IOException {
        this.readHeader();
        return this.image.getWidth();
    }

    @Override
    public int getHeight(int n) throws IOException {
        this.readHeader();
        return this.image.getHeight();
    }

    @Override
    public Iterator<ImageTypeSpecifier> getImageTypes(int n) throws IOException {
        this.readHeader();
        LinkedList<ImageTypeSpecifier> linkedList = new LinkedList<ImageTypeSpecifier>();
        linkedList.add(new ImageTypeSpecifier(RGB, RGB.createCompatibleSampleModel(this.image.getWidth(), this.image.getHeight())));
        return linkedList.iterator();
    }

    @Override
    public IIOMetadata getStreamMetadata() throws IOException {
        return null;
    }

    @Override
    public IIOMetadata getImageMetadata(int n) throws IOException {
        return null;
    }

    @Override
    public BufferedImage read(int n, ImageReadParam imageReadParam) throws IOException {
        if (n > 0) {
            throw new IndexOutOfBoundsException();
        }
        this.readHeader();
        return this.image;
    }

    private void readHeader() throws IOException {
        if (this.image == null) {
            ImageInputStream imageInputStream = null;
            Object object = this.getInput();
            if (object instanceof byte[]) {
                imageInputStream = ImageIO.createImageInputStream((byte[])object);
            } else if (object instanceof ImageInputStream) {
                imageInputStream = (ImageInputStream)object;
            } else if (object instanceof InputStream) {
                imageInputStream = new MemoryCacheImageInputStream((InputStream)object);
            } else {
                throw new IOException("Can't handle input of type " + object);
            }
            this.image = CMYKJPEGImageReader.read(imageInputStream, this.isYCCKInversed);
        }
    }

    public boolean isYCCKInversed() {
        return this.isYCCKInversed;
    }

    public void setYCCKInversed(boolean bl) {
        this.isYCCKInversed = bl;
    }

    public static BufferedImage read(ImageInputStream imageInputStream, boolean bl) throws IOException {
        Object object;
        imageInputStream.seek(0L);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        JFIFInputStream jFIFInputStream = new JFIFInputStream(new ImageInputStreamAdapter(imageInputStream));
        Object object2 = jFIFInputStream.getNextSegment();
        while (object2 != null) {
            int n6;
            if (65472 <= ((JFIFInputStream.Segment)object2).marker && ((JFIFInputStream.Segment)object2).marker <= 65475 || 65477 <= ((JFIFInputStream.Segment)object2).marker && ((JFIFInputStream.Segment)object2).marker <= 65479 || 65481 <= ((JFIFInputStream.Segment)object2).marker && ((JFIFInputStream.Segment)object2).marker <= 65483 || 65485 <= ((JFIFInputStream.Segment)object2).marker && ((JFIFInputStream.Segment)object2).marker <= 65487) {
                object = new DataInputStream(jFIFInputStream);
                n = ((DataInputStream)object).readUnsignedByte();
                n2 = ((DataInputStream)object).readUnsignedShort();
                n3 = ((DataInputStream)object).readUnsignedShort();
                n4 = ((DataInputStream)object).readUnsignedByte();
                break;
            }
            if (((JFIFInputStream.Segment)object2).marker == 65506) {
                if (((JFIFInputStream.Segment)object2).length >= 26 && ((DataInputStream)(object = new DataInputStream(jFIFInputStream))).readLong() == 5279137264856878918L && ((DataInputStream)object).readInt() == 1229735168) {
                    ((DataInputStream)object).skipBytes(2);
                    byte[] byArray = new byte[512];
                    n6 = ((DataInputStream)object).read(byArray);
                    while (n6 != -1) {
                        byteArrayOutputStream.write(byArray, 0, n6);
                        n6 = ((DataInputStream)object).read(byArray);
                    }
                }
            } else if (((JFIFInputStream.Segment)object2).marker == 65518 && ((JFIFInputStream.Segment)object2).length == 12 && (long)((DataInputStream)(object = new DataInputStream(jFIFInputStream))).readInt() == 1097101154L && ((DataInputStream)object).readUnsignedShort() == 25856) {
                int n7 = ((DataInputStream)object).readUnsignedByte();
                n6 = ((DataInputStream)object).readUnsignedShort();
                int n8 = ((DataInputStream)object).readUnsignedShort();
                n5 = ((DataInputStream)object).readUnsignedByte();
            }
            object2 = jFIFInputStream.getNextSegment();
        }
        object2 = null;
        if (n4 != 4) {
            imageInputStream.seek(0L);
            object2 = CMYKJPEGImageReader.readImageFromYUVorGray(imageInputStream);
        } else if (n4 == 4) {
            object = null;
            if (byteArrayOutputStream.size() > 0) {
                try {
                    object = ICC_Profile.getInstance(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
            if (object == null) {
                object = ICC_Profile.getInstance(CMYKJPEGImageReader.class.getResourceAsStream("Generic CMYK Profile.icc"));
            }
            switch (n5) {
                default: {
                    imageInputStream.seek(0L);
                    object2 = CMYKJPEGImageReader.readRGBAImageFromRGBA(new ImageInputStreamAdapter(imageInputStream), (ICC_Profile)object);
                    break;
                }
                case 1: {
                    throw new IOException("YCbCr not supported");
                }
                case 2: {
                    imageInputStream.seek(0L);
                    object2 = bl ? CMYKJPEGImageReader.readRGBImageFromInvertedYCCK(new ImageInputStreamAdapter(imageInputStream), (ICC_Profile)object) : CMYKJPEGImageReader.readRGBImageFromYCCK(new ImageInputStreamAdapter(imageInputStream), (ICC_Profile)object);
                }
            }
        }
        return object2;
    }

    private static ImageReader createNativeJPEGReader() {
        Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName("jpeg");
        while (iterator.hasNext()) {
            ImageReader imageReader = iterator.next();
            if (imageReader instanceof CMYKJPEGImageReader) continue;
            return imageReader;
        }
        return null;
    }

    public static BufferedImage readRGBImageFromCMYK(InputStream inputStream, ICC_Profile iCC_Profile) throws IOException {
        ImageInputStream imageInputStream = null;
        ImageReader imageReader = CMYKJPEGImageReader.createNativeJPEGReader();
        imageInputStream = inputStream instanceof ImageInputStream ? (ImageInputStream)((Object)inputStream) : ImageIO.createImageInputStream(inputStream);
        imageReader.setInput(imageInputStream);
        Raster raster = imageReader.readRaster(0, null);
        BufferedImage bufferedImage = CMYKJPEGImageReader.createRGBImageFromCMYK(raster, iCC_Profile);
        return bufferedImage;
    }

    public static BufferedImage readRGBAImageFromRGBA(InputStream inputStream, ICC_Profile iCC_Profile) throws IOException {
        ImageInputStream imageInputStream = null;
        ImageReader imageReader = CMYKJPEGImageReader.createNativeJPEGReader();
        imageInputStream = inputStream instanceof ImageInputStream ? (ImageInputStream)((Object)inputStream) : ImageIO.createImageInputStream(inputStream);
        imageReader.setInput(imageInputStream);
        Raster raster = imageReader.readRaster(0, null);
        BufferedImage bufferedImage = CMYKJPEGImageReader.createRGBAImageFromRGBA(raster, iCC_Profile);
        return bufferedImage;
    }

    public static BufferedImage readRGBImageFromYCCK(InputStream inputStream, ICC_Profile iCC_Profile) throws IOException {
        ImageInputStream imageInputStream = null;
        ImageReader imageReader = CMYKJPEGImageReader.createNativeJPEGReader();
        imageInputStream = inputStream instanceof ImageInputStream ? (ImageInputStream)((Object)inputStream) : ImageIO.createImageInputStream(inputStream);
        imageReader.setInput(imageInputStream);
        Raster raster = imageReader.readRaster(0, null);
        BufferedImage bufferedImage = CMYKJPEGImageReader.createRGBImageFromYCCK(raster, iCC_Profile);
        return bufferedImage;
    }

    public static BufferedImage readRGBImageFromInvertedYCCK(InputStream inputStream, ICC_Profile iCC_Profile) throws IOException {
        ImageInputStream imageInputStream = null;
        ImageReader imageReader = CMYKJPEGImageReader.createNativeJPEGReader();
        imageInputStream = inputStream instanceof ImageInputStream ? (ImageInputStream)((Object)inputStream) : ImageIO.createImageInputStream(inputStream);
        imageReader.setInput(imageInputStream);
        Raster raster = imageReader.readRaster(0, null);
        raster = CMYKJPEGImageReader.convertInvertedYCCKToCMYK(raster);
        BufferedImage bufferedImage = CMYKJPEGImageReader.createRGBImageFromCMYK(raster, iCC_Profile);
        return bufferedImage;
    }

    public static BufferedImage createRGBImageFromYCCK(Raster raster, ICC_Profile iCC_Profile) {
        BufferedImage bufferedImage;
        if (iCC_Profile != null) {
            raster = CMYKJPEGImageReader.convertYCCKtoCMYK(raster);
            bufferedImage = CMYKJPEGImageReader.createRGBImageFromCMYK(raster, iCC_Profile);
        } else {
            int n = raster.getWidth();
            int n2 = raster.getHeight();
            int[] nArray = new int[n * n2];
            int[] nArray2 = raster.getSamples(0, 0, n, n2, 0, (int[])null);
            int[] nArray3 = raster.getSamples(0, 0, n, n2, 1, (int[])null);
            int[] nArray4 = raster.getSamples(0, 0, n, n2, 2, (int[])null);
            int[] nArray5 = raster.getSamples(0, 0, n, n2, 3, (int[])null);
            int n3 = nArray2.length;
            for (int i = 0; i < n3; ++i) {
                float f = nArray5[i];
                float f2 = nArray2[i];
                float f3 = nArray3[i];
                float f4 = nArray4[i];
                float f5 = f2 + 1.402f * (f4 - 128.0f) - f;
                float f6 = f2 - 0.34414f * (f3 - 128.0f) - 0.71414f * (f4 - 128.0f) - f;
                float f7 = f2 + 1.772f * (f3 - 128.0f) - f;
                nArray[i] = (0xFF & (f5 < 0.0f ? 0 : (f5 > 255.0f ? 255 : (int)(f5 + 0.5f)))) << 16 | (0xFF & (f6 < 0.0f ? 0 : (f6 > 255.0f ? 255 : (int)(f6 + 0.5f)))) << 8 | 0xFF & (f7 < 0.0f ? 0 : (f7 > 255.0f ? 255 : (int)(f7 + 0.5f)));
            }
            WritableRaster writableRaster = Raster.createPackedRaster(new DataBufferInt(nArray, nArray.length), n, n2, n, new int[]{0xFF0000, 65280, 255}, null);
            ColorSpace colorSpace = ColorSpace.getInstance(1000);
            DirectColorModel directColorModel = new DirectColorModel(colorSpace, 24, 0xFF0000, 65280, 255, 0, false, 3);
            bufferedImage = new BufferedImage(directColorModel, writableRaster, true, null);
        }
        return bufferedImage;
    }

    public static BufferedImage createRGBImageFromInvertedYCCK(Raster raster, ICC_Profile iCC_Profile) {
        BufferedImage bufferedImage;
        if (iCC_Profile != null) {
            raster = CMYKJPEGImageReader.convertInvertedYCCKToCMYK(raster);
            bufferedImage = CMYKJPEGImageReader.createRGBImageFromCMYK(raster, iCC_Profile);
        } else {
            int n = raster.getWidth();
            int n2 = raster.getHeight();
            int[] nArray = new int[n * n2];
            int[] nArray2 = raster.getSamples(0, 0, n, n2, 0, (int[])null);
            int[] nArray3 = raster.getSamples(0, 0, n, n2, 1, (int[])null);
            int[] nArray4 = raster.getSamples(0, 0, n, n2, 2, (int[])null);
            int[] nArray5 = raster.getSamples(0, 0, n, n2, 3, (int[])null);
            int n3 = nArray2.length;
            for (int i = 0; i < n3; ++i) {
                float f = 255 - nArray5[i];
                float f2 = 255 - nArray2[i];
                float f3 = 255 - nArray3[i];
                float f4 = 255 - nArray4[i];
                float f5 = f2 + 1.402f * (f4 - 128.0f) - f;
                float f6 = f2 - 0.34414f * (f3 - 128.0f) - 0.71414f * (f4 - 128.0f) - f;
                float f7 = f2 + 1.772f * (f3 - 128.0f) - f;
                nArray[i] = (0xFF & (f5 < 0.0f ? 0 : (f5 > 255.0f ? 255 : (int)(f5 + 0.5f)))) << 16 | (0xFF & (f6 < 0.0f ? 0 : (f6 > 255.0f ? 255 : (int)(f6 + 0.5f)))) << 8 | 0xFF & (f7 < 0.0f ? 0 : (f7 > 255.0f ? 255 : (int)(f7 + 0.5f)));
            }
            WritableRaster writableRaster = Raster.createPackedRaster(new DataBufferInt(nArray, nArray.length), n, n2, n, new int[]{0xFF0000, 65280, 255}, null);
            ColorSpace colorSpace = ColorSpace.getInstance(1000);
            DirectColorModel directColorModel = new DirectColorModel(colorSpace, 24, 0xFF0000, 65280, 255, 0, false, 3);
            bufferedImage = new BufferedImage(directColorModel, writableRaster, true, null);
        }
        return bufferedImage;
    }

    public static BufferedImage createRGBImageFromCMYK(Raster raster, ICC_Profile iCC_Profile) {
        BufferedImage bufferedImage;
        int n = raster.getWidth();
        int n2 = raster.getHeight();
        if (iCC_Profile != null) {
            ICC_ColorSpace iCC_ColorSpace = new ICC_ColorSpace(iCC_Profile);
            bufferedImage = new BufferedImage(n, n2, 1);
            WritableRaster writableRaster = bufferedImage.getRaster();
            ColorSpace colorSpace = bufferedImage.getColorModel().getColorSpace();
            ColorConvertOp colorConvertOp = new ColorConvertOp(iCC_ColorSpace, colorSpace, null);
            colorConvertOp.filter(raster, writableRaster);
        } else {
            int[] nArray = new int[n * n2];
            int[] nArray2 = raster.getSamples(0, 0, n, n2, 0, (int[])null);
            int[] nArray3 = raster.getSamples(0, 0, n, n2, 1, (int[])null);
            int[] nArray4 = raster.getSamples(0, 0, n, n2, 2, (int[])null);
            int[] nArray5 = raster.getSamples(0, 0, n, n2, 3, (int[])null);
            int n3 = nArray2.length;
            for (int i = 0; i < n3; ++i) {
                int n4 = nArray5[i];
                nArray[i] = 255 - Math.min(255, nArray2[i] + n4) << 16 | 255 - Math.min(255, nArray3[i] + n4) << 8 | 255 - Math.min(255, nArray4[i] + n4);
            }
            WritableRaster writableRaster = Raster.createPackedRaster(new DataBufferInt(nArray, nArray.length), n, n2, n, new int[]{0xFF0000, 65280, 255}, null);
            ColorSpace colorSpace = ColorSpace.getInstance(1000);
            DirectColorModel directColorModel = new DirectColorModel(colorSpace, 24, 0xFF0000, 65280, 255, 0, false, 3);
            bufferedImage = new BufferedImage(directColorModel, writableRaster, true, null);
        }
        return bufferedImage;
    }

    public static BufferedImage createRGBAImageFromRGBA(Raster raster, ICC_Profile iCC_Profile) {
        int n = raster.getWidth();
        int n2 = raster.getHeight();
        iCC_Profile = null;
        int[] nArray = new int[n * n2];
        int[] nArray2 = raster.getSamples(0, 0, n, n2, 0, (int[])null);
        int[] nArray3 = raster.getSamples(0, 0, n, n2, 1, (int[])null);
        int[] nArray4 = raster.getSamples(0, 0, n, n2, 2, (int[])null);
        int[] nArray5 = raster.getSamples(0, 0, n, n2, 3, (int[])null);
        int n3 = nArray2.length;
        for (int i = 0; i < n3; ++i) {
            nArray[i] = nArray5[i] << 24 | nArray2[i] << 16 | nArray3[i] << 8 | nArray4[i];
        }
        WritableRaster writableRaster = Raster.createPackedRaster(new DataBufferInt(nArray, nArray.length), n, n2, n, new int[]{0xFF0000, 65280, 255, -16777216}, null);
        ColorSpace colorSpace = ColorSpace.getInstance(1000);
        DirectColorModel directColorModel = new DirectColorModel(colorSpace, 32, 0xFF0000, 65280, 255, -16777216, false, 3);
        BufferedImage bufferedImage = new BufferedImage(directColorModel, writableRaster, true, null);
        return bufferedImage;
    }

    private static synchronized void buildYCCtoRGBtable() {
        if (Cr_r_tab[0] == 0) {
            int n = 0;
            int n2 = -128;
            while (n <= 255) {
                CMYKJPEGImageReader.Cr_r_tab[n] = (int)(91881.972 * (double)n2 + 32768.0) >> 16;
                CMYKJPEGImageReader.Cb_b_tab[n] = (int)(116130.292 * (double)n2 + 32768.0) >> 16;
                CMYKJPEGImageReader.Cr_g_tab[n] = -46802 * n2;
                CMYKJPEGImageReader.Cb_g_tab[n] = -22554 * n2 + 32768;
                ++n;
                ++n2;
            }
        }
    }

    private static Raster convertInvertedYCCKToCMYK(Raster raster) {
        CMYKJPEGImageReader.buildYCCtoRGBtable();
        int n = raster.getWidth();
        int n2 = raster.getHeight();
        int[] nArray = raster.getSamples(0, 0, n, n2, 0, (int[])null);
        int[] nArray2 = raster.getSamples(0, 0, n, n2, 1, (int[])null);
        int[] nArray3 = raster.getSamples(0, 0, n, n2, 2, (int[])null);
        int[] nArray4 = raster.getSamples(0, 0, n, n2, 3, (int[])null);
        int[] nArray5 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            int n3 = 255 - nArray[i];
            int n4 = 255 - nArray2[i];
            int n5 = 255 - nArray3[i];
            int n6 = 255 - (n3 + Cr_r_tab[n5]);
            int n7 = 255 - (n3 + (Cb_g_tab[n4] + Cr_g_tab[n5] >> 16));
            int n8 = 255 - (n3 + Cb_b_tab[n4]);
            nArray5[i] = (n6 < 0 ? 0 : (n6 > 255 ? 255 : n6)) << 24 | (n7 < 0 ? 0 : (n7 > 255 ? 255 : n7)) << 16 | (n8 < 0 ? 0 : (n8 > 255 ? 255 : n8)) << 8 | 255 - nArray4[i];
        }
        WritableRaster writableRaster = Raster.createPackedRaster(new DataBufferInt(nArray5, nArray5.length), n, n2, n, new int[]{-16777216, 0xFF0000, 65280, 255}, null);
        return writableRaster;
    }

    private static Raster convertYCCKtoCMYK(Raster raster) {
        CMYKJPEGImageReader.buildYCCtoRGBtable();
        int n = raster.getWidth();
        int n2 = raster.getHeight();
        int[] nArray = raster.getSamples(0, 0, n, n2, 0, (int[])null);
        int[] nArray2 = raster.getSamples(0, 0, n, n2, 1, (int[])null);
        int[] nArray3 = raster.getSamples(0, 0, n, n2, 2, (int[])null);
        int[] nArray4 = raster.getSamples(0, 0, n, n2, 3, (int[])null);
        int[] nArray5 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            int n3 = nArray[i];
            int n4 = nArray2[i];
            int n5 = nArray3[i];
            int n6 = 255 - (n3 + Cr_r_tab[n5]);
            int n7 = 255 - (n3 + (Cb_g_tab[n4] + Cr_g_tab[n5] >> 16));
            int n8 = 255 - (n3 + Cb_b_tab[n4]);
            nArray5[i] = (n6 < 0 ? 0 : (n6 > 255 ? 255 : n6)) << 24 | (n7 < 0 ? 0 : (n7 > 255 ? 255 : n7)) << 16 | (n8 < 0 ? 0 : (n8 > 255 ? 255 : n8)) << 8 | nArray4[i];
        }
        return Raster.createPackedRaster(new DataBufferInt(nArray5, nArray5.length), n, n2, n, new int[]{-16777216, 0xFF0000, 65280, 255}, null);
    }

    public static BufferedImage readImageFromYUVorGray(ImageInputStream imageInputStream) throws IOException {
        ImageReader imageReader = CMYKJPEGImageReader.createNativeJPEGReader();
        imageReader.setInput(imageInputStream);
        BufferedImage bufferedImage = imageReader.read(0);
        return bufferedImage;
    }
}

