/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;

public class DigestUtils {
    public static final boolean checkMD5(File file, String string) {
        return DigestUtils.checkMD5(file, string, null);
    }

    public static final boolean checkMD5(File file, String string, DigestProgressListener digestProgressListener) {
        if (!DigestUtils.isValidMD5(string)) {
            return false;
        }
        String string2 = DigestUtils.getMD5(file, digestProgressListener);
        return DigestUtils.compareMD5(string2, string);
    }

    public static final boolean compareMD5(String string, String string2) {
        if (!DigestUtils.isValidMD5(string)) {
            return false;
        }
        if (!DigestUtils.isValidMD5(string2)) {
            return false;
        }
        return string.equalsIgnoreCase(string2);
    }

    private static boolean isValidMD5(String string) {
        if (string == null) {
            return false;
        }
        return string.length() == 32;
    }

    public static final String getMD5(File file) {
        return DigestUtils.getMD5(file, null);
    }

    public static final String getMD5(File file, DigestProgressListener digestProgressListener) {
        try {
            return DigestUtils.getMD5(new FileInputStream(file), file.length(), digestProgressListener);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    public static final String getMD5(InputStream inputStream, long l, DigestProgressListener digestProgressListener) {
        try {
            int n;
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] byArray = new byte[4096];
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            long l2 = 0L;
            boolean bl = false;
            while (!bl && (n = ((InputStream)bufferedInputStream).read(byArray)) != -1) {
                l2 += (long)n;
                messageDigest.update(byArray, 0, n);
                if (digestProgressListener == null) continue;
                if (l > 0L) {
                    int n2 = (int)(l2 * 100L / l);
                    try {
                        digestProgressListener.onProgress(n2);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (!digestProgressListener.stopDigesting()) continue;
                bl = true;
            }
            ((InputStream)bufferedInputStream).close();
            if (!bl) {
                String string = new BigInteger(1, messageDigest.digest()).toString(16);
                if (string.length() < 32) {
                    int n3 = 32 - string.length();
                    for (int i = 0; i < n3; ++i) {
                        string = "0" + string;
                    }
                }
                return string;
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static final String getMD5(String string) {
        try {
            byte[] byArray = string.getBytes("UTF-8");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            return DigestUtils.getMD5(byteArrayInputStream, byArray.length, null);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public static interface DigestProgressListener {
        public void onProgress(int var1);

        public boolean stopDigesting();
    }
}

