/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.collection;

import java.io.Serializable;
import org.limewire.collection.Range;
import org.limewire.util.ByteOrder;

public class LongInterval
extends Range
implements Serializable {
    private static final long serialVersionUID = -2562093104400487445L;
    private final long low;
    private final long high;

    protected LongInterval(long l, long l2) {
        if (l2 < l) {
            throw new IllegalArgumentException("low: " + l + ", high: " + l2);
        }
        if (l < 0L) {
            throw new IllegalArgumentException("low < min int:" + l);
        }
        if (l2 > 0xFFFFFFFFFFL) {
            throw new IllegalArgumentException("high > max int:" + l2);
        }
        this.low = l;
        this.high = l2;
    }

    protected LongInterval(long l) {
        this(l, l);
    }

    @Override
    public final long getLow() {
        return this.low;
    }

    @Override
    public final long getHigh() {
        return this.high;
    }

    @Override
    public byte[] toBytes() {
        if (this.isLong()) {
            byte[] byArray = new byte[10];
            this.toBytes(byArray, 0);
            return byArray;
        }
        byte[] byArray = new byte[8];
        this.toBytes8(byArray, 0);
        return byArray;
    }

    @Override
    public void toBytes(byte[] byArray, int n) {
        if (!this.isLong()) {
            this.toBytes8(byArray, n);
            return;
        }
        byArray[n + 0] = (byte)(this.low >> 32);
        byArray[n + 1] = (byte)(this.low >> 24);
        byArray[n + 2] = (byte)(this.low >> 16);
        byArray[n + 3] = (byte)(this.low >> 8);
        byArray[n + 4] = (byte)this.low;
        byArray[n + 5] = (byte)(this.high >> 32);
        byArray[n + 6] = (byte)(this.high >> 24);
        byArray[n + 7] = (byte)(this.high >> 16);
        byArray[n + 8] = (byte)(this.high >> 8);
        byArray[n + 9] = (byte)this.high;
    }

    private void toBytes8(byte[] byArray, int n) {
        ByteOrder.int2beb((int)this.low, byArray, n);
        ByteOrder.int2beb((int)this.high, byArray, n + 4);
    }

    @Override
    public final boolean isLong() {
        return this.high > Integer.MAX_VALUE;
    }
}

