/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GenericsUtils {
    private GenericsUtils() {
    }

    public static <K, V> Map<K, V> scanForMap(Object object, Class<K> clazz, Class<V> clazz2, ScanMode scanMode) {
        if (scanMode == ScanMode.NEW_COPY_REMOVED) {
            throw new IllegalArgumentException("must use scanForMap(Object, Class, Class, ScanMode, Class");
        }
        return GenericsUtils.scanForMap(object, clazz, clazz2, scanMode, null);
    }

    public static <K, V> Map<K, V> scanForMap(Object object, Class<K> clazz, Class<V> clazz2, ScanMode scanMode, Class<? extends Map<K, V>> clazz3) {
        if (object instanceof Map) {
            Map map = (Map)object;
            Map<K, V> map2 = null;
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Object k = entry.getKey();
                Object v = entry.getValue();
                if (k != null && v != null && clazz.isAssignableFrom(k.getClass()) && clazz2.isAssignableFrom(v.getClass())) continue;
                switch (scanMode) {
                    case EXCEPTION: {
                        StringBuilder stringBuilder = new StringBuilder();
                        if (k == null) {
                            stringBuilder.append("key is null ");
                        } else if (!clazz.isAssignableFrom(k.getClass())) {
                            stringBuilder.append("key class not assignable " + k.getClass() + " to " + clazz);
                        }
                        if (v == null) {
                            stringBuilder.append("value is null for key " + k);
                        } else if (!clazz2.isAssignableFrom(v.getClass())) {
                            stringBuilder.append("value class not assignable " + v.getClass() + " to " + clazz2);
                        }
                        throw new ClassCastException(stringBuilder.toString());
                    }
                    case REMOVE: {
                        iterator.remove();
                        break;
                    }
                    case NEW_COPY_REMOVED: {
                        if (map2 == null) {
                            map2 = GenericsUtils.newInstance(clazz3);
                            map2.putAll(map);
                        }
                        map2.remove(k);
                    }
                }
            }
            if (map2 != null) {
                return map2;
            }
            return map;
        }
        throw new ClassCastException();
    }

    public static <V> Collection<V> scanForCollection(Object object, Class<V> clazz, ScanMode scanMode) {
        if (scanMode == ScanMode.NEW_COPY_REMOVED) {
            throw new IllegalArgumentException("must use scanForCollection(Object, Class, ScanMode, Class");
        }
        return GenericsUtils.scanForCollection(object, clazz, scanMode, null);
    }

    public static <V> Collection<V> scanForCollection(Object object, Class<V> clazz, ScanMode scanMode, Class<? extends Collection<V>> clazz2) {
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            Collection<V> collection2 = null;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e != null && clazz.isAssignableFrom(e.getClass())) continue;
                switch (scanMode) {
                    case EXCEPTION: {
                        throw new ClassCastException("wanted an instanceof: " + clazz + ", but was: " + (e == null ? "null" : e.getClass()));
                    }
                    case REMOVE: {
                        iterator.remove();
                        break;
                    }
                    case NEW_COPY_REMOVED: {
                        if (collection2 == null) {
                            collection2 = GenericsUtils.newInstance(clazz2);
                            collection2.addAll(collection);
                        }
                        collection2.remove(e);
                    }
                }
            }
            if (collection2 != null) {
                return collection2;
            }
            return collection;
        }
        throw new ClassCastException();
    }

    public static <V> Set<V> scanForSet(Object object, Class<V> clazz, ScanMode scanMode) {
        if (scanMode == ScanMode.NEW_COPY_REMOVED) {
            throw new IllegalArgumentException("must use scanForSet(Object, Class, ScanMode, Class");
        }
        return GenericsUtils.scanForSet(object, clazz, scanMode, null);
    }

    public static <V> Set<V> scanForSet(Object object, Class<V> clazz, ScanMode scanMode, Class<? extends Set<V>> clazz2) {
        if (object instanceof Set) {
            return (Set)GenericsUtils.scanForCollection(object, clazz, scanMode, clazz2);
        }
        throw new ClassCastException();
    }

    public static <V> List<V> scanForList(Object object, Class<V> clazz, ScanMode scanMode) {
        if (scanMode == ScanMode.NEW_COPY_REMOVED) {
            throw new IllegalArgumentException("must use scanForList(Object, Class, ScanMode, Class");
        }
        return GenericsUtils.scanForList(object, clazz, scanMode, null);
    }

    public static <V> List<V> scanForList(Object object, Class<V> clazz, ScanMode scanMode, Class<? extends List<V>> clazz2) {
        if (object instanceof List) {
            return (List)GenericsUtils.scanForCollection(object, clazz, scanMode, clazz2);
        }
        throw new ClassCastException();
    }

    private static <T> T newInstance(Class<? extends T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
    }

    public static enum ScanMode {
        EXCEPTION,
        REMOVE,
        NEW_COPY_REMOVED;

    }
}

