/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.text.Normalizer;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import org.limewire.util.AbstractI18NConverter;
import org.limewire.util.CommonUtils;
import org.limewire.util.ConverterObjectInputStream;

final class I18NConvertICU
extends AbstractI18NConverter {
    private BitSet _excluded;
    private Map<?, ?> _cMap;

    I18NConvertICU() throws IOException, ClassNotFoundException {
        BitSet bitSet = null;
        HashMap hashMap = null;
        InputStream inputStream = CommonUtils.getResourceStream("com/frostwire/util/excluded.dat");
        ObjectInputStream objectInputStream = new ObjectInputStream(new BufferedInputStream(inputStream));
        bitSet = (BitSet)objectInputStream.readObject();
        objectInputStream.close();
        inputStream = CommonUtils.getResourceStream("com/frostwire/util/caseMap.dat");
        objectInputStream = new ConverterObjectInputStream(new BufferedInputStream(inputStream));
        hashMap = (HashMap)objectInputStream.readObject();
        objectInputStream.close();
        this._excluded = bitSet;
        this._cMap = hashMap;
    }

    @Override
    public String getNorm(String string) {
        return this.convert(string);
    }

    @Override
    public String compose(String string) {
        return Normalizer.normalize(string, Normalizer.Form.NFC);
    }

    private String convert(String string) {
        String string2 = Normalizer.normalize(string, Normalizer.Form.NFKD);
        StringBuilder stringBuilder = new StringBuilder();
        int n = string2.length();
        for (int i = 0; i < n; ++i) {
            char c = string2.charAt(i);
            if (this._excluded.get(c)) continue;
            String string3 = (String)this._cMap.get(String.valueOf(c));
            if (string3 != null) {
                stringBuilder.append(string3);
                continue;
            }
            stringBuilder.append(c);
        }
        return this.blockSplit(Normalizer.normalize(stringBuilder.toString(), Normalizer.Form.NFC));
    }
}

