/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.adobe;

import com.drew.lang.BufferBoundsException;
import com.drew.lang.BufferReader;
import com.drew.lang.annotations.NotNull;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataReader;
import com.drew.metadata.adobe.AdobeJpegDirectory;

public class AdobeJpegReader
implements MetadataReader {
    @Override
    public void extract(@NotNull BufferReader bufferReader, @NotNull Metadata metadata) {
        AdobeJpegDirectory adobeJpegDirectory = metadata.getOrCreateDirectory(AdobeJpegDirectory.class);
        if (bufferReader.getLength() != 12L) {
            adobeJpegDirectory.addError(String.format("Adobe JPEG data is expected to be 12 bytes long, not %d.", bufferReader.getLength()));
            return;
        }
        try {
            bufferReader.setMotorolaByteOrder(false);
            if (!bufferReader.getString(0, 5).equals("Adobe")) {
                adobeJpegDirectory.addError("Invalid Adobe JPEG data header.");
                return;
            }
            adobeJpegDirectory.setInt(0, bufferReader.getUInt16(5));
            adobeJpegDirectory.setInt(1, bufferReader.getUInt16(7));
            adobeJpegDirectory.setInt(2, bufferReader.getUInt16(9));
            adobeJpegDirectory.setInt(3, bufferReader.getInt8(11));
        }
        catch (BufferBoundsException bufferBoundsException) {
            adobeJpegDirectory.addError("Exif data segment ended prematurely");
        }
    }
}

