/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.jfif;

import com.drew.lang.annotations.NotNull;
import com.drew.metadata.Directory;
import com.drew.metadata.MetadataException;
import com.drew.metadata.jfif.JfifDescriptor;
import java.util.HashMap;

public class JfifDirectory
extends Directory {
    public static final int TAG_JFIF_VERSION = 5;
    public static final int TAG_JFIF_UNITS = 7;
    public static final int TAG_JFIF_RESX = 8;
    public static final int TAG_JFIF_RESY = 10;
    @NotNull
    protected static final HashMap<Integer, String> _tagNameMap = new HashMap();

    public JfifDirectory() {
        this.setDescriptor(new JfifDescriptor(this));
    }

    @Override
    @NotNull
    public String getName() {
        return "Jfif";
    }

    @Override
    @NotNull
    protected HashMap<Integer, String> getTagNameMap() {
        return _tagNameMap;
    }

    public int getVersion() throws MetadataException {
        return this.getInt(5);
    }

    public int getResUnits() throws MetadataException {
        return this.getInt(7);
    }

    public int getImageWidth() throws MetadataException {
        return this.getInt(10);
    }

    public int getImageHeight() throws MetadataException {
        return this.getInt(8);
    }

    static {
        _tagNameMap.put(5, "Version");
        _tagNameMap.put(7, "Resolution Units");
        _tagNameMap.put(10, "Y Resolution");
        _tagNameMap.put(8, "X Resolution");
    }
}

