/*
 * Decompiled with CFR 0.152.
 */
package de.savemytube.flv;

import de.log.Category;
import de.savemytube.flv.ByteData;
import de.savemytube.flv.FLVTag;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;

public class FLVTagAudio
extends FLVTag {
    public static final int SOUND_TYPE_MONO = 0;
    public static final int SOUND_TYPE_STEREO = 1;
    public static final int SOUND_SIZE_8BIT = 0;
    public static final int SOUND_SIZE_16BIT = 1;
    public static final int SOUND_RATE_5_5 = 0;
    public static final int SOUND_RATE_11 = 1;
    public static final int SOUND_RATE_22 = 2;
    public static final int SOUND_RATE_44 = 3;
    public static final int SOUND_FORMAT_UNCOMPRESSED = 0;
    public static final int SOUND_FORMAT_ADPCM = 1;
    public static final int SOUND_FORMAT_MP3 = 2;
    public static final int SOUND_FORMAT_NELLYMOSER_8_MONO = 5;
    public static final int SOUND_FORMAT_NELLYMOSER = 6;
    public static String[] S_TYPES = new String[]{"Mono", "Stereo"};
    public static String[] S_SIZE = new String[]{"8 Bit", "16 Bit"};
    public static String[] S_RATE = new String[]{"5.5 kHz", "11 kHz", "22 kHz", "44 kHz"};
    public static String[] S_FORMAT = new String[]{"uncompressed", "ADPCM", "Mp3", "", "", "Nellymoser 8 Bit Mono", "Nellymoser"};
    private int soundType;
    private int soundSize;
    private int soundRate;
    private int soundFormat;
    static Category log = Category.getInstance(FLVTagAudio.class);

    public FLVTagAudio(byte by, int n, int n2, byte by2, int n3) {
        super(by, n, n2, by2, n3);
    }

    @Override
    public void read(ReadableByteChannel readableByteChannel) throws IOException {
        ByteData byteData = this.read(readableByteChannel, 1);
        ByteBuffer byteBuffer = byteData.getByteBuffer();
        byte by = this.getBytes(byteBuffer)[0];
        this.setInfo(by);
        this.setBodyLength(this.getBodyLength() - 1);
        byteData = this.read(readableByteChannel, this.getBodyLength());
        this.setBody(this.getBytes(byteData.getByteBuffer()));
    }

    private void setInfo(byte by) {
        this.soundFormat = (by & 0xF0) >> 4;
        this.soundType = (by & 1) >> 0;
        this.soundSize = (by & 2) >> 1;
        this.soundRate = (by & 0xC) >> 2;
    }

    @Override
    public String toString() {
        String string = "---- AudioFormat ----\n";
        string = string + super.toString() + "\n";
        string = string + S_FORMAT[this.soundFormat] + " " + S_SIZE[this.soundSize] + " " + S_TYPES[this.soundType] + " " + S_RATE[this.soundRate];
        return string;
    }
}

