/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling;

import jd.controlling.JDLogger;
import jd.nutils.Formatter;

public final class GarbageController
implements Runnable {
    private static final GarbageController INSTANCE = new GarbageController();
    private static long GCTimeout = 600000L;
    private static long GCFactor = 30000L;
    private static long gcRequested = 0L;
    private Thread thread = new Thread(this);
    private boolean running = false;

    public static GarbageController getInstance() {
        return INSTANCE;
    }

    private GarbageController() {
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public static synchronized void requestGC() {
        ++gcRequested;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        block17: {
            GarbageController garbageController = this;
            // MONITORENTER : garbageController
            if (!this.running) break block17;
            // MONITOREXIT : garbageController
            GarbageController garbageController2 = this;
            // MONITORENTER : garbageController2
            this.running = false;
            // MONITOREXIT : garbageController2
            return;
        }
        try {
            this.running = true;
            // MONITOREXIT : garbageController
            long l = 0L;
            while (true) {
                GarbageController garbageController = this;
                // MONITORENTER : garbageController
                l -= gcRequested * GCFactor;
                gcRequested = 0L;
                // MONITOREXIT : garbageController
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                if ((l -= 10000L) > 0L) continue;
                long l2 = Runtime.getRuntime().totalMemory();
                Runtime.getRuntime().gc();
                Runtime.getRuntime().runFinalization();
                Runtime.getRuntime().gc();
                long l3 = Runtime.getRuntime().totalMemory();
                JDLogger.getLogger().info("GCed: before: " + Formatter.formatReadable(l2) + " now: " + Formatter.formatReadable(l3) + " freed: " + Formatter.formatReadable(Math.max(0L, l2 - l3)));
                GarbageController garbageController3 = this;
                // MONITORENTER : garbageController3
                l = GCTimeout;
                gcRequested = 0L;
                // MONITOREXIT : garbageController3
            }
        }
        catch (Throwable throwable) {
            GarbageController garbageController = this;
            // MONITORENTER : garbageController
            this.running = false;
            // MONITOREXIT : garbageController
            throw throwable;
        }
    }
}

