/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.downloadcontroller;

import java.util.HashMap;
import jd.crypt.JDCrypt;
import jd.plugins.DownloadLink;
import jd.plugins.LinkStatus;
import org.appwork.storage.Storable;
import org.appwork.utils.encoding.Base64;
import org.appwork.utils.logging.Log;

public class DownloadLinkStorable
implements Storable {
    private static final byte[] KEY = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    private static final String CRYPTED = "CRYPTED:";
    private DownloadLink link;

    private DownloadLinkStorable() {
        this.link = new DownloadLink(null, null, null, null, false);
    }

    public DownloadLinkStorable(DownloadLink downloadLink) {
        this.link = downloadLink;
    }

    public String getName() {
        return this.link.getName();
    }

    public void setName(String string) {
        this.link.setName(string);
    }

    public HashMap<String, Object> getProperties() {
        return this.link.getProperties();
    }

    public void setProperties(HashMap<String, Object> hashMap) {
        this.link.setProperties(hashMap);
    }

    public HashMap<String, String> getLinkStatus() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("errormsg", this.link.getLinkStatus().getErrorMessage());
        hashMap.put("lateststatus", "" + this.link.getLinkStatus().getLatestStatus());
        hashMap.put("status", "" + this.link.getLinkStatus().getStatus());
        hashMap.put("statustxt", this.link.getLinkStatus().getStatusText());
        return hashMap;
    }

    public void setLinkStatus(HashMap<String, String> hashMap) {
        if (hashMap != null) {
            try {
                LinkStatus linkStatus = this.link.getLinkStatus();
                linkStatus.setStatus(Integer.parseInt(hashMap.get("status")));
                linkStatus.setLatestStatus(Integer.parseInt(hashMap.get("lateststatus")));
                linkStatus.setErrorMessage(hashMap.get("errormsg"));
                linkStatus.setStatusText(hashMap.get("statustxt"));
            }
            catch (Throwable throwable) {
                Log.exception(throwable);
            }
        }
    }

    public long getSize() {
        return this.link.getDownloadSize();
    }

    public void setSize(long l) {
        this.link.setDownloadSize(l);
    }

    public long getCurrent() {
        return this.link.getDownloadCurrent();
    }

    public void setCurrent(long l) {
        this.link.setDownloadCurrent(l);
    }

    public String getURL() {
        if (this.link.gotBrowserUrl()) {
            byte[] byArray = JDCrypt.encrypt(this.link.getDownloadURL(), KEY);
            return CRYPTED + Base64.encodeToString(byArray, false);
        }
        return this.link.getDownloadURL();
    }

    public void setURL(String string) {
        if (string.startsWith(CRYPTED)) {
            byte[] byArray = Base64.decodeFast(string.substring(CRYPTED.length()));
            String string2 = JDCrypt.decrypt(byArray, KEY);
            this.link.setUrlDownload(string2);
        } else {
            this.link.setUrlDownload(string);
        }
    }

    public String getHost() {
        return this.link.getHost();
    }

    public void setHost(String string) {
        this.link.setHost(string);
    }

    public String getBrowserURL() {
        if (!this.link.gotBrowserUrl()) {
            return null;
        }
        return this.link.getBrowserUrl();
    }

    public void setBrowserURL(String string) {
        this.link.setBrowserUrl(string);
    }

    public long[] getChunkProgress() {
        return this.link.getChunksProgress();
    }

    public void setChunkProgress(long[] lArray) {
        this.link.setChunksProgress(lArray);
    }

    public int getLinkType() {
        return this.link.getLinkType();
    }

    public void setLinkType(int n) {
        this.link.setLinkType(n);
    }

    public boolean isEnabled() {
        return this.link.isEnabled();
    }

    public void setEnabled(boolean bl) {
        this.link.setEnabled(bl);
    }

    public long getCreated() {
        return this.link.getCreated();
    }

    public void setCreated(long l) {
        this.link.setCreated(l);
    }

    public DownloadLink _getDownloadLink() {
        return this.link;
    }
}

