/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.linkcollector;

import java.util.ArrayList;
import jd.controlling.linkcollector.CrawledLinkStorable;
import jd.controlling.linkcollector.OfflineCrawledPackage;
import jd.controlling.linkcollector.PermanentOfflinePackage;
import jd.controlling.linkcollector.VariousCrawledPackage;
import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.linkcrawler.CrawledPackage;
import org.appwork.storage.Storable;

public class CrawledPackageStorable
implements Storable {
    private TYPE type = null;
    private String packageID = null;
    private CrawledPackage pkg;
    private ArrayList<CrawledLinkStorable> links;

    public TYPE getType() {
        if (this.pkg instanceof OfflineCrawledPackage) {
            return TYPE.OFFLINE;
        }
        if (this.pkg instanceof PermanentOfflinePackage) {
            return TYPE.POFFLINE;
        }
        if (this.pkg instanceof VariousCrawledPackage) {
            return TYPE.VARIOUS;
        }
        return TYPE.NORMAL;
    }

    public void setType(TYPE tYPE) {
        this.type = tYPE;
    }

    public TYPE _getType() {
        return this.type;
    }

    public String getComment() {
        return this.pkg.getComment();
    }

    public void setComment(String string) {
        this.pkg.setComment(string);
    }

    private CrawledPackageStorable() {
        this.pkg = new CrawledPackage();
        this.links = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CrawledPackageStorable(CrawledPackage crawledPackage) {
        this.pkg = crawledPackage;
        this.links = new ArrayList(crawledPackage.getChildren().size());
        CrawledPackage crawledPackage2 = crawledPackage;
        synchronized (crawledPackage2) {
            for (CrawledLink crawledLink : crawledPackage.getChildren()) {
                this.links.add(new CrawledLinkStorable(crawledLink));
            }
        }
    }

    public CrawledPackage _getCrawledPackage() {
        return this.pkg;
    }

    public long getCreated() {
        return this.pkg.getCreated();
    }

    public String getDownloadFolder() {
        if (!this.pkg.isDownloadFolderSet()) {
            return null;
        }
        return this.pkg.getRawDownloadFolder();
    }

    public ArrayList<String> getExtractionPasswords() {
        if (this.pkg.getExtractionPasswords().size() == 0) {
            return null;
        }
        return new ArrayList<String>(this.pkg.getExtractionPasswords());
    }

    public ArrayList<CrawledLinkStorable> getLinks() {
        return this.links;
    }

    public boolean isAutoExtractionEnabled() {
        return this.pkg.isAutoExtractionEnabled();
    }

    public boolean isExpanded() {
        return this.pkg.isExpanded();
    }

    public void setAutoExtractionEnabled(boolean bl) {
        this.pkg.setAutoExtractionEnabled(bl);
    }

    public void setCreated(long l) {
        this.pkg.setCreated(l);
    }

    public void setDownloadFolder(String string) {
        this.pkg.setDownloadFolder(string);
    }

    public void setExpanded(boolean bl) {
        this.pkg.setExpanded(bl);
    }

    public void setExtractionPasswords(ArrayList<String> arrayList) {
        if (arrayList == null) {
            return;
        }
        this.pkg.getExtractionPasswords().addAll(arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLinks(ArrayList<CrawledLinkStorable> arrayList) {
        if (arrayList != null) {
            this.links = arrayList;
            CrawledPackage crawledPackage = this.pkg;
            synchronized (crawledPackage) {
                for (CrawledLinkStorable crawledLinkStorable : arrayList) {
                    CrawledLink crawledLink = crawledLinkStorable._getCrawledLink();
                    this.pkg.getChildren().add(crawledLink);
                    crawledLink.setParentNode(this.pkg);
                }
            }
        }
    }

    public void setName(String string) {
        this.pkg.setName(string);
    }

    public String getName() {
        return this.pkg.getName();
    }

    public void setPackageID(String string) {
        this.packageID = string;
    }

    public String getPackageID() {
        return this.packageID;
    }

    public static enum TYPE {
        NORMAL,
        OFFLINE,
        POFFLINE,
        VARIOUS;

    }
}

