/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.packagecontroller;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import jd.controlling.IOEQ;
import jd.controlling.packagecontroller.AbstractNodeNotifier;
import jd.controlling.packagecontroller.AbstractPackageChildrenNode;
import jd.controlling.packagecontroller.AbstractPackageChildrenNodeFilter;
import jd.controlling.packagecontroller.AbstractPackageNode;
import org.appwork.utils.event.queue.Queue;
import org.appwork.utils.event.queue.QueueAction;
import org.appwork.utils.logging.Log;

public abstract class PackageController<PackageType extends AbstractPackageNode<ChildType, PackageType>, ChildType extends AbstractPackageChildrenNode<PackageType>>
implements AbstractNodeNotifier<PackageType> {
    private final AtomicLong structureChanged = new AtomicLong(0L);
    private final AtomicLong childrenChanged = new AtomicLong(0L);
    private final AtomicLong contentChanged = new AtomicLong(0L);
    protected LinkedList<PackageType> packages = new LinkedList();
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
    private final ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();

    public long getPackageControllerChanges() {
        return this.structureChanged.get();
    }

    public long getChildrenChanges() {
        return this.childrenChanged.get();
    }

    public long getContentChanges() {
        return this.contentChanged.get();
    }

    public void addmovePackageAt(PackageType PackageType, int n) {
        this.addmovePackageAt(PackageType, n, false);
    }

    public void sortPackageChildren(final PackageType PackageType, final Comparator<ChildType> comparator) {
        if (PackageType != null && comparator != null) {
            IOEQ.getQueue().add(new QueueAction<Void, RuntimeException>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected Void run() throws RuntimeException {
                    PackageController.this.writeLock();
                    try {
                        AbstractPackageNode abstractPackageNode = PackageType;
                        synchronized (abstractPackageNode) {
                            List list = PackageType.getChildren();
                            Collections.sort(list, comparator);
                        }
                    }
                    finally {
                        PackageController.this.writeUnlock();
                    }
                    PackageController.this.structureChanged.incrementAndGet();
                    PackageController.this._controllerStructureChanged(this.getQueuePrio());
                    return null;
                }
            });
        }
    }

    protected void addmovePackageAt(final PackageType PackageType, final int n, final boolean bl) {
        if (PackageType != null) {
            IOEQ.getQueue().add(new QueueAction<Void, RuntimeException>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected Void run() throws RuntimeException {
                    if (!bl && PackageType.getChildren().size() == 0) {
                        return null;
                    }
                    boolean bl5 = true;
                    PackageController packageController = PackageType.getControlledBy();
                    boolean bl2 = false;
                    if (PackageController.this == packageController) {
                        bl2 = true;
                    } else if (packageController != null) {
                        packageController.removePackage(PackageType);
                    }
                    PackageController.this.writeLock();
                    try {
                        ListIterator<AbstractPackageNode> listIterator = PackageController.this.packages.listIterator();
                        int n2 = 0;
                        boolean bl3 = false;
                        boolean bl4 = false;
                        if (n < 0 || n > PackageController.this.packages.size() - 1) {
                            bl3 = true;
                            bl4 = true;
                        }
                        while (listIterator.hasNext() && (!bl3 || bl2)) {
                            AbstractPackageNode abstractPackageNode;
                            AbstractPackageNode abstractPackageNode2 = (AbstractPackageNode)listIterator.next();
                            if (abstractPackageNode2 == PackageType && n2 == n) {
                                abstractPackageNode = null;
                                return abstractPackageNode;
                            }
                            if (n2 == n) {
                                abstractPackageNode = abstractPackageNode2;
                                listIterator.set(PackageType);
                                listIterator.add(abstractPackageNode);
                                bl3 = true;
                            } else if (abstractPackageNode2 == PackageType) {
                                listIterator.remove();
                                bl5 = false;
                                bl2 = false;
                            }
                            ++n2;
                        }
                        if (!bl3 || bl4) {
                            PackageController.this.packages.addLast(PackageType);
                        }
                        PackageType.setControlledBy(PackageController.this);
                    }
                    finally {
                        PackageController.this.writeUnlock();
                    }
                    PackageController.this.structureChanged.incrementAndGet();
                    if (bl5) {
                        if (PackageType.getChildren().size() > 0) {
                            PackageController.this.childrenChanged.incrementAndGet();
                        }
                        PackageController.this._controllerPackageNodeAdded(PackageType, this.getQueuePrio());
                    } else {
                        PackageController.this._controllerStructureChanged(this.getQueuePrio());
                    }
                    return null;
                }
            });
        }
    }

    public int size() {
        return this.packages.size();
    }

    public void removePackage(final PackageType PackageType) {
        if (PackageType != null) {
            IOEQ.getQueue().add(new QueueAction<Void, RuntimeException>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected Void run() throws RuntimeException {
                    boolean bl = false;
                    ArrayList arrayList = null;
                    PackageController packageController = PackageType.getControlledBy();
                    if (packageController == null) {
                        Log.exception(new Throwable("NO CONTROLLER!!!"));
                        return null;
                    }
                    if (PackageType.getControlledBy() != null) {
                        if (PackageController.this != PackageType.getControlledBy()) {
                            Log.exception(new Throwable("removing a package which is not controlled by this controller?!?!?"));
                        }
                        PackageType.setControlledBy(null);
                        PackageController.this.writeLock();
                        try {
                            bl = packageController.packages.remove(PackageType);
                        }
                        finally {
                            PackageController.this.writeUnlock();
                        }
                    }
                    AbstractPackageNode abstractPackageNode = PackageType;
                    synchronized (abstractPackageNode) {
                        arrayList = new ArrayList(PackageType.getChildren());
                    }
                    if (bl && arrayList != null && arrayList.size() > 0) {
                        PackageController.this.childrenChanged.incrementAndGet();
                        packageController._controllerParentlessLinks(arrayList, this.getQueuePrio());
                    }
                    if (bl) {
                        packageController.structureChanged.incrementAndGet();
                        packageController._controllerPackageNodeRemoved(PackageType, this.getQueuePrio());
                    }
                    return null;
                }
            });
        }
    }

    public void removeChildren(final List<ChildType> list) {
        if (list != null && list.size() > 0) {
            IOEQ.getQueue().add(new QueueAction<Void, RuntimeException>(){

                @Override
                protected Void run() throws RuntimeException {
                    Object object;
                    Object object2;
                    Object object32;
                    LinkedList linkedList = new LinkedList(list);
                    boolean bl = false;
                    HashMap<Object, LinkedList<Object>> hashMap = new HashMap<Object, LinkedList<Object>>();
                    for (Object object32 : linkedList) {
                        object2 = (AbstractPackageNode)object32.getParentNode();
                        if (object2 == null) continue;
                        object = (LinkedList)hashMap.get(object2);
                        if (object == null) {
                            bl = true;
                            object = new LinkedList();
                            hashMap.put(object2, (LinkedList<Object>)object);
                        }
                        ((LinkedList)object).add(object32);
                    }
                    Set set = hashMap.entrySet();
                    object32 = set.iterator();
                    while (object32.hasNext()) {
                        object2 = (Map.Entry)object32.next();
                        object = (AbstractPackageNode)object2.getKey();
                        PackageController packageController = object.getControlledBy();
                        if (packageController == null) {
                            Log.exception(new Throwable("NO CONTROLLER!!!"));
                            continue;
                        }
                        packageController.removeChildren(object, (List)object2.getValue(), true);
                    }
                    PackageController.this.structureChanged.incrementAndGet();
                    if (bl) {
                        PackageController.this.childrenChanged.incrementAndGet();
                    }
                    PackageController.this._controllerStructureChanged(this.getQueuePrio());
                    return null;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<ChildType> getChildrenByFilter(AbstractPackageChildrenNodeFilter<ChildType> abstractPackageChildrenNodeFilter) {
        ArrayList<AbstractPackageChildrenNode> arrayList = new ArrayList<AbstractPackageChildrenNode>();
        boolean bl = this.readLock();
        try {
            Iterator iterator = this.packages.iterator();
            while (iterator.hasNext()) {
                AbstractPackageNode abstractPackageNode;
                AbstractPackageNode abstractPackageNode2 = abstractPackageNode = (AbstractPackageNode)iterator.next();
                synchronized (abstractPackageNode2) {
                    for (AbstractPackageChildrenNode abstractPackageChildrenNode : abstractPackageNode.getChildren()) {
                        if (abstractPackageChildrenNodeFilter.returnMaxResults() > 0 && arrayList.size() == abstractPackageChildrenNodeFilter.returnMaxResults()) {
                            ArrayList<AbstractPackageChildrenNode> arrayList2 = arrayList;
                            return arrayList2;
                        }
                        if (!abstractPackageChildrenNodeFilter.isChildrenNodeFiltered(abstractPackageChildrenNode)) continue;
                        arrayList.add(abstractPackageChildrenNode);
                    }
                }
            }
            return arrayList;
        }
        finally {
            this.readUnlock(bl);
        }
    }

    public void merge(final PackageType PackageType, final ArrayList<ChildType> arrayList, final ArrayList<PackageType> arrayList2, final boolean bl) {
        if (PackageType == null) {
            return;
        }
        if (arrayList == null && arrayList2 == null) {
            return;
        }
        IOEQ.getQueue().add(new QueueAction<Void, RuntimeException>(){

            @Override
            protected Void run() throws RuntimeException {
                int n;
                int n2 = n = bl ? 0 : -1;
                if (arrayList != null) {
                    PackageController.this.addmoveChildren(PackageType, arrayList, n);
                    if (n != -1) {
                        n += arrayList.size();
                    }
                }
                if (arrayList2 != null) {
                    for (AbstractPackageNode abstractPackageNode : arrayList2) {
                        int n3 = abstractPackageNode.getChildren().size();
                        PackageController.this.addmoveChildren(PackageType, abstractPackageNode.getChildren(), n);
                        if (n == -1) continue;
                        n += n3;
                    }
                }
                return null;
            }
        });
    }

    public void addmoveChildren(final PackageType PackageType, final List<ChildType> list, final int n) {
        if (PackageType != null && list != null && list.size() > 0) {
            IOEQ.getQueue().add(new QueueAction<Void, RuntimeException>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected Void run() throws RuntimeException {
                    PackageController packageController;
                    Object object;
                    Object object2;
                    Object object32;
                    LinkedList linkedList = new LinkedList(list);
                    if (PackageController.this != PackageType.getControlledBy()) {
                        PackageController.this.addmovePackageAt(PackageType, -1, true);
                    }
                    boolean bl = false;
                    HashMap<Object, LinkedList<Object>> hashMap = new HashMap<Object, LinkedList<Object>>();
                    for (Object object32 : linkedList) {
                        object2 = (AbstractPackageNode)object32.getParentNode();
                        if (object2 == null || PackageType == object2) {
                            if (object2 != null) continue;
                            bl = true;
                            continue;
                        }
                        object = (LinkedList)hashMap.get(object2);
                        if (object == null) {
                            object = new LinkedList();
                            hashMap.put(object2, (LinkedList<Object>)object);
                        }
                        ((LinkedList)object).add(object32);
                    }
                    Set set = hashMap.entrySet();
                    object32 = set.iterator();
                    while (object32.hasNext()) {
                        object2 = (Map.Entry)object32.next();
                        object = (AbstractPackageNode)object2.getKey();
                        packageController = object.getControlledBy();
                        if (packageController == null) {
                            Log.exception(new Throwable("NO CONTROLLER!!!"));
                            continue;
                        }
                        packageController.removeChildren(object, (List)object2.getValue(), false);
                    }
                    PackageController.this.writeLock();
                    try {
                        object2 = PackageType;
                        synchronized (object2) {
                            int n3 = n;
                            packageController = PackageType.getChildren();
                            for (AbstractPackageChildrenNode abstractPackageChildrenNode : linkedList) {
                                int n2 = packageController.indexOf(abstractPackageChildrenNode);
                                if (n2 < 0) continue;
                                if (n2 < n3) {
                                    --n3;
                                }
                                packageController.remove(n2);
                            }
                            if (n3 < 0 || n3 > packageController.size() - 1) {
                                packageController.addAll(linkedList);
                            } else {
                                packageController.addAll(n3, linkedList);
                            }
                            for (AbstractPackageChildrenNode abstractPackageChildrenNode : linkedList) {
                                abstractPackageChildrenNode.setParentNode(PackageType);
                            }
                        }
                        PackageType.notifyStructureChanges();
                    }
                    finally {
                        PackageController.this.writeUnlock();
                    }
                    PackageController.this.structureChanged.incrementAndGet();
                    if (bl) {
                        PackageController.this.childrenChanged.incrementAndGet();
                    }
                    PackageController.this._controllerStructureChanged(this.getQueuePrio());
                    return null;
                }
            });
        }
    }

    public void removeChildren(final PackageType PackageType, final List<ChildType> list, final boolean bl) {
        if (PackageType != null && list != null && list.size() > 0) {
            IOEQ.getQueue().add(new QueueAction<Void, RuntimeException>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected Void run() throws RuntimeException {
                    LinkedList linkedList = new LinkedList(list);
                    PackageController packageController = PackageType.getControlledBy();
                    if (packageController == null) {
                        Log.exception(new Throwable("NO CONTROLLER!!!"));
                        return null;
                    }
                    PackageController.this.writeLock();
                    try {
                        AbstractPackageNode abstractPackageNode = PackageType;
                        synchronized (abstractPackageNode) {
                            List list2 = PackageType.getChildren();
                            Iterator iterator = linkedList.iterator();
                            while (iterator.hasNext()) {
                                AbstractPackageChildrenNode abstractPackageChildrenNode = (AbstractPackageChildrenNode)iterator.next();
                                if (list2.remove(abstractPackageChildrenNode)) {
                                    if (abstractPackageChildrenNode.getParentNode() == PackageType) {
                                        abstractPackageChildrenNode.setParentNode(null);
                                        continue;
                                    }
                                    Log.exception(new Throwable("removing children from wrong parent?!?!?"));
                                    continue;
                                }
                                iterator.remove();
                            }
                        }
                        PackageType.notifyStructureChanges();
                    }
                    finally {
                        PackageController.this.writeUnlock();
                    }
                    if (linkedList.size() > 0) {
                        packageController.structureChanged.incrementAndGet();
                        if (bl) {
                            PackageController.this.childrenChanged.incrementAndGet();
                            packageController._controllerParentlessLinks(linkedList, this.getQueuePrio());
                        }
                        if (PackageType.getChildren().size() == 0) {
                            packageController.removePackage(PackageType);
                        }
                    }
                    return null;
                }
            });
        }
    }

    public void clear() {
        IOEQ.getQueue().add(new QueueAction<Void, RuntimeException>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected Void run() throws RuntimeException {
                ArrayList arrayList = null;
                boolean bl = PackageController.this.readLock();
                try {
                    arrayList = new ArrayList(PackageController.this.packages);
                }
                finally {
                    PackageController.this.readUnlock(bl);
                }
                for (AbstractPackageNode abstractPackageNode : arrayList) {
                    PackageController.this.removePackage(abstractPackageNode);
                }
                return null;
            }
        });
    }

    public void move(final ArrayList<PackageType> arrayList, final PackageType PackageType) {
        if (arrayList == null || arrayList.size() == 0) {
            return;
        }
        IOEQ.getQueue().add(new QueueAction<Void, RuntimeException>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected Void run() throws RuntimeException {
                AbstractPackageNode abstractPackageNode = PackageType;
                for (AbstractPackageNode abstractPackageNode2 : arrayList) {
                    int n = 0;
                    if (abstractPackageNode != null) {
                        int n2 = 0;
                        boolean bl = PackageController.this.readLock();
                        try {
                            n2 = PackageController.this.packages.indexOf(abstractPackageNode);
                        }
                        finally {
                            PackageController.this.readUnlock(bl);
                        }
                        n = Math.max(n2, 0) + 1;
                    }
                    PackageController.this.addmovePackageAt(abstractPackageNode2, n);
                    abstractPackageNode = abstractPackageNode2;
                }
                return null;
            }
        });
    }

    public void move(final ArrayList<ChildType> arrayList, final PackageType PackageType, final ChildType ChildType) {
        if (PackageType == null || arrayList == null || arrayList.size() == 0) {
            return;
        }
        IOEQ.getQueue().add(new QueueAction<Void, RuntimeException>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected Void run() throws RuntimeException {
                int n = 0;
                if (ChildType != null) {
                    int n2 = 0;
                    AbstractPackageNode abstractPackageNode = PackageType;
                    synchronized (abstractPackageNode) {
                        n2 = PackageType.getChildren().indexOf(ChildType);
                    }
                    n = Math.max(n2, 0) + 1;
                }
                PackageController.this.addmoveChildren(PackageType, arrayList, n);
                return null;
            }
        });
    }

    protected abstract void _controllerParentlessLinks(List<ChildType> var1, Queue.QueuePriority var2);

    protected abstract void _controllerPackageNodeRemoved(PackageType var1, Queue.QueuePriority var2);

    protected abstract void _controllerStructureChanged(Queue.QueuePriority var1);

    protected abstract void _controllerPackageNodeAdded(PackageType var1, Queue.QueuePriority var2);

    public boolean readLock() {
        if (!this.writeLock.isHeldByCurrentThread()) {
            this.readLock.lock();
            return true;
        }
        return false;
    }

    public void readUnlock(boolean bl) {
        if (!bl) {
            return;
        }
        this.readUnlock();
    }

    public void readUnlock() {
        try {
            this.readLock.unlock();
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            Log.exception(illegalMonitorStateException);
        }
    }

    public void writeLock() {
        this.writeLock.lock();
    }

    public void writeUnlock() {
        this.writeLock.unlock();
    }

    public LinkedList<PackageType> getPackages() {
        return this.packages;
    }

    @Override
    public void nodeUpdated(PackageType PackageType) {
        this.contentChanged.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int indexOf(PackageType PackageType) {
        boolean bl = this.readLock();
        try {
            int n = this.packages.indexOf(PackageType);
            return n;
        }
        finally {
            this.readUnlock(bl);
        }
    }
}

