/*
 * Decompiled with CFR 0.152.
 */
package jd.http;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.CookieHandler;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import jd.http.BrowserSettings;
import jd.http.Cookie;
import jd.http.Cookies;
import jd.http.Request;
import jd.http.RequestHeader;
import jd.http.URLConnectionAdapter;
import jd.http.XTrustProvider;
import jd.http.requests.FormData;
import jd.http.requests.GetRequest;
import jd.http.requests.PostFormDataRequest;
import jd.http.requests.PostRequest;
import jd.http.requests.RequestVariable;
import jd.nutils.encoding.Encoding;
import jd.parser.Regex;
import jd.parser.html.Form;
import jd.parser.html.InputField;
import org.appwork.utils.net.httpconnection.HTTPProxy;

public class Browser {
    private static final HashMap<String, Cookies> COOKIES = new HashMap();
    private static HTTPProxy GLOBAL_PROXY = null;
    private static Logger LOGGER = null;
    private static HashMap<String, Integer> REQUEST_INTERVAL_LIMIT_MAP;
    private static HashMap<String, Long> REQUESTTIME_MAP;
    private static int TIMEOUT_CONNECT;
    private static int TIMEOUT_READ;
    private int[] allowedResponseCodes = new int[0];
    private static boolean VERBOSE;
    private String acceptLanguage = "de, en-gb;q=0.9, en;q=0.8";
    private int connectTimeout = -1;
    private HashMap<String, Cookies> cookies = new HashMap();
    private boolean cookiesExclusive = true;
    private URL currentURL = null;
    private String customCharset = null;
    private boolean debug = false;
    private boolean doRedirects = false;
    private RequestHeader headers;
    private int limit = 0x100000;
    private Logger logger = null;
    private HTTPProxy proxy;
    private int readTimeout = -1;
    private int redirectLoopCounter = 0;
    private Request request;
    private HashMap<String, Integer> requestIntervalLimitMap;
    private HashMap<String, Long> requestTimeMap;
    private boolean verbose = false;

    public static HTTPProxy _getGlobalProxy() {
        return GLOBAL_PROXY;
    }

    public static int getGlobalReadTimeout() {
        return TIMEOUT_READ;
    }

    public static String getHost(String string) {
        return Browser.getHost(string, false);
    }

    public static String getHost(String string, boolean bl) {
        if (string == null) {
            return null;
        }
        String string2 = new Regex(string, "(.*?://)?(\\d+\\.\\d+\\.\\d+\\.\\d+)(/|$|:)").getMatch(1);
        if (string2 != null) {
            return string2;
        }
        if (bl) {
            string2 = new Regex(string, ".*?://(.*?@)?(.*?)(/|$|:)").getMatch(1);
        }
        if (string2 == null) {
            string2 = new Regex(string, ".*?([^.:/]+\\.[^.:/]+)(/|$|:)").getMatch(0);
        }
        if (string2 != null) {
            return string2.toLowerCase(Locale.ENGLISH);
        }
        return string;
    }

    public static String getHost(URL uRL) {
        return Browser.getHost(uRL.getHost());
    }

    public static void init() {
        CookieHandler.setDefault(null);
        XTrustProvider.install();
        HostnameVerifier hostnameVerifier = new HostnameVerifier(){

            @Override
            public boolean verify(String string, SSLSession sSLSession) {
                return true;
            }
        };
        HttpsURLConnection.setDefaultHostnameVerifier(hostnameVerifier);
    }

    public static void setGlobalConnectTimeout(int n) {
        TIMEOUT_CONNECT = n;
    }

    public static void setGlobalLogger(Logger logger) {
        LOGGER = logger;
    }

    public static void setGlobalProxy(HTTPProxy hTTPProxy) {
        GLOBAL_PROXY = hTTPProxy;
    }

    public static void setGlobalReadTimeout(int n) {
        TIMEOUT_READ = n;
    }

    public static void setGlobalVerbose(boolean bl) {
        VERBOSE = bl;
    }

    public static synchronized void setRequestIntervalLimitGlobal(String string, int n) {
        String string2 = Browser.getHost(string);
        if (string2 == null) {
            return;
        }
        if (REQUEST_INTERVAL_LIMIT_MAP == null) {
            REQUEST_INTERVAL_LIMIT_MAP = new HashMap();
            REQUESTTIME_MAP = new HashMap();
        }
        REQUEST_INTERVAL_LIMIT_MAP.put(string2, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void waitForPageAccess(Browser browser, Request request) throws InterruptedException {
        try {
            long l;
            String string = Browser.getHost(request.getUrl().getHost());
            Integer n = null;
            Integer n2 = null;
            Long l2 = null;
            Long l3 = null;
            if (browser.requestIntervalLimitMap != null) {
                n = browser.requestIntervalLimitMap.get(string);
                l2 = browser.requestTimeMap.get(string);
            }
            if (REQUEST_INTERVAL_LIMIT_MAP != null) {
                n2 = REQUEST_INTERVAL_LIMIT_MAP.get(string);
                l3 = REQUESTTIME_MAP.get(string);
            }
            if (n == null && n2 == null) {
                return;
            }
            if (l2 == null && l3 == null) {
                return;
            }
            if (n != null && l2 == null) {
                return;
            }
            if (n2 != null && l3 == null) {
                return;
            }
            if (n2 == null) {
                n2 = 0;
            }
            if (n == null) {
                n = 0;
            }
            if (l2 == null) {
                l2 = System.currentTimeMillis();
            }
            if (l3 == null) {
                l3 = System.currentTimeMillis();
            }
            if ((l = Math.max((long)n.intValue() - (System.currentTimeMillis() - l2), (long)n2.intValue() - (System.currentTimeMillis() - l3))) > 0L) {
                Thread.sleep(l);
            }
        }
        finally {
            String string = Browser.getHost(request.getUrl().getHost());
            if (browser.requestTimeMap != null) {
                browser.requestTimeMap.put(string, System.currentTimeMillis());
            }
            if (REQUESTTIME_MAP != null) {
                REQUESTTIME_MAP.put(string, System.currentTimeMillis());
            }
        }
    }

    public static String correctURL(String string) {
        if (string == null) {
            return string;
        }
        int n = string.indexOf("://");
        if (n > 0 && string.indexOf("/", n + 3) < 0) {
            string = string + "/";
        }
        if (n > 0 && !string.substring(n + 3).contains("//") && !string.contains("./")) {
            return string;
        }
        String string2 = string;
        String string3 = null;
        String string4 = null;
        boolean bl = false;
        n = string.startsWith("http://") ? 8 : (string.startsWith("https://") ? 9 : 0);
        int n2 = string.indexOf("/", n);
        if (n2 < 0) {
            return string2;
        }
        string2 = string.substring(0, n2);
        int n3 = string.indexOf("?", n2);
        if (n3 > 0) {
            string3 = string.substring(n3);
            string4 = string.substring(n2, n3);
        } else {
            string4 = string.substring(n2);
        }
        bl = string4.endsWith("/");
        string4 = string4.replaceAll("/+", "/");
        String[] stringArray = string4.split("/");
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase(".")) {
                stringArray[i] = "";
                continue;
            }
            if (!stringArray[i].equalsIgnoreCase("..")) continue;
            if (i > 0) {
                for (int j = i - 1; j > 0; --j) {
                    if (stringArray[j].length() <= 0) continue;
                    stringArray[j] = "";
                    break;
                }
            }
            stringArray[i] = "";
        }
        string4 = "";
        for (String string5 : stringArray) {
            if (string5.length() <= 0) continue;
            string4 = string4 + "/" + string5;
        }
        if (bl) {
            string4 = string4 + "/";
        }
        return string2 + string4 + (string3 != null ? string3 : "");
    }

    public static void download(File file, String string) throws IOException {
        new Browser().getDownload(file, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void download(File file, URLConnectionAdapter uRLConnectionAdapter) throws IOException {
        if (file.isFile() && !file.delete()) {
            System.out.println("Konnte Datei nicht l\u00c3\u00b6schen " + file);
            throw new IOException("Could not overwrite file: " + file);
        }
        File file2 = file.getParentFile();
        if (file2 != null && !file2.exists()) {
            file2.mkdirs();
        }
        file.createNewFile();
        FileOutputStream fileOutputStream = null;
        FilterOutputStream filterOutputStream = null;
        BufferedInputStream bufferedInputStream = null;
        boolean bl = false;
        try {
            int n;
            fileOutputStream = new FileOutputStream(file, false);
            filterOutputStream = new BufferedOutputStream(fileOutputStream);
            bufferedInputStream = new BufferedInputStream(uRLConnectionAdapter.getInputStream());
            byte[] byArray = new byte[1024];
            while ((n = bufferedInputStream.read(byArray)) != -1) {
                ((BufferedOutputStream)filterOutputStream).write(byArray, 0, n);
            }
            bl = true;
        }
        finally {
            try {
                filterOutputStream.close();
            }
            catch (Throwable throwable) {}
            try {
                bufferedInputStream.close();
            }
            catch (Throwable throwable) {}
            try {
                fileOutputStream.close();
            }
            catch (Throwable throwable) {}
            if (!bl) {
                file.delete();
            }
        }
    }

    public static String getBasicAuthfromURL(String string) {
        if (string == null) {
            return null;
        }
        String string2 = new Regex(string, "http.*?/([^/]{1}.*?)@").getMatch(0);
        if (string2 != null && string2.contains(":")) {
            return Encoding.Base64Encode(string2);
        }
        return null;
    }

    public static int getGlobalConnectTimeout() {
        return TIMEOUT_CONNECT;
    }

    public static Logger getGlobalLogger() {
        return LOGGER;
    }

    public Browser() {
        Thread thread = Thread.currentThread();
        if (thread != null && thread instanceof BrowserSettings) {
            BrowserSettings browserSettings = (BrowserSettings)((Object)thread);
            this.proxy = browserSettings.getCurrentProxy();
            this.debug = browserSettings.isDebug();
            this.verbose = browserSettings.isVerbose();
            this.logger = browserSettings.getLogger();
        }
    }

    private void checkContentLengthLimit(Request request) throws BrowserException {
        if (request == null || request.getHttpConnection() == null || request.getHttpConnection().getHeaderField("Content-Length") == null) {
            return;
        }
        if (Long.parseLong(request.getHttpConnection().getHeaderField("Content-Length")) > (long)this.limit) {
            if (this.getLogger() != null) {
                this.getLogger().severe(request.printHeaders());
            }
            throw new BrowserException("Content-length too big", request.getHttpConnection());
        }
    }

    public void clearCookies(String string) {
        if (string == null) {
            this.cookies.clear();
        }
        String string2 = Browser.getHost(string);
        Iterator<String> iterator = this.getCookies().keySet().iterator();
        String string3 = null;
        while (iterator.hasNext()) {
            string3 = iterator.next();
            if (!string3.contains(string2)) continue;
            this.cookies.get(string3).clear();
            break;
        }
    }

    public Browser cloneBrowser() {
        Browser browser = new Browser();
        browser.requestIntervalLimitMap = this.requestIntervalLimitMap;
        browser.requestTimeMap = this.requestTimeMap;
        browser.acceptLanguage = this.acceptLanguage;
        browser.connectTimeout = this.connectTimeout;
        browser.currentURL = this.currentURL;
        browser.doRedirects = this.doRedirects;
        browser.setCustomCharset(this.customCharset);
        browser.getHeaders().putAll(this.getHeaders());
        browser.limit = this.limit;
        browser.readTimeout = this.readTimeout;
        browser.request = this.request;
        browser.cookies = this.cookies;
        browser.cookiesExclusive = this.cookiesExclusive;
        browser.debug = this.debug;
        browser.verbose = this.verbose;
        browser.logger = this.logger;
        browser.proxy = this.proxy;
        browser.allowedResponseCodes = this.allowedResponseCodes;
        return browser;
    }

    public void connect(Request request) throws IOException {
        this.request = request;
        try {
            Browser.waitForPageAccess(this, request);
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("requestIntervalTime Exception");
        }
        request.connect();
    }

    public boolean containsHTML(String string) {
        return new Regex((Object)this, string).matches();
    }

    public Request createFormRequest(Form form) throws Exception {
        String string;
        String string2 = null;
        String string3 = null;
        if (this.request != null) {
            string2 = this.request.getUrl().toString();
            string3 = form.getAction(string2);
        }
        try {
            string = this.getRegex("<base.*?href=\"(.+?)\"").getMatch(0).trim();
            new URL(string);
            string2 = string;
            if (form.getAction(null) != null) {
                string3 = form.getAction(string2);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        switch (form.getMethod()) {
            case GET: {
                string = form.getPropertyString();
                if (string != null && !string.matches("[\\s]*")) {
                    if (string3.matches(".*\\?.+")) {
                        string3 = string3 + "&";
                    } else if (string3.matches("[^\\?]*")) {
                        string3 = string3 + "?";
                    }
                    string3 = string3 + string;
                }
                return this.createGetRequest(string3);
            }
            case POST: {
                if (form.getEncoding() == null || !form.getEncoding().toLowerCase().endsWith("form-data")) {
                    return this.createPostRequest(string3, form.getRequestVariables(), form.getEncoding());
                }
                PostFormDataRequest postFormDataRequest = (PostFormDataRequest)this.createPostFormDataRequest(string3);
                if (form.getEncoding() != null) {
                    postFormDataRequest.setEncodeType(form.getEncoding());
                }
                int n = form.getInputFields().size();
                for (int i = 0; i < n; ++i) {
                    InputField inputField = form.getInputFields().get(i);
                    if (inputField.getValue() == null) continue;
                    if (inputField.getType() != null && inputField.getType().equalsIgnoreCase("image")) {
                        postFormDataRequest.addFormData(new FormData(inputField.getKey() + ".x", inputField.getProperty("x", (int)(Math.random() * 100.0) + "")));
                        postFormDataRequest.addFormData(new FormData(inputField.getKey() + ".y", inputField.getProperty("y", (int)(Math.random() * 100.0) + "")));
                        continue;
                    }
                    if (inputField.getType() != null && inputField.getType().equalsIgnoreCase("file")) {
                        postFormDataRequest.addFormData(new FormData(inputField.getKey(), inputField.getFileToPost().getName(), inputField.getFileToPost()));
                        continue;
                    }
                    if (inputField.getKey() == null || inputField.getValue() == null) continue;
                    postFormDataRequest.addFormData(new FormData(inputField.getKey(), inputField.getValue()));
                }
                return postFormDataRequest;
            }
        }
        return null;
    }

    public Request createGetRequest(String string) throws IOException {
        return this.createGetRequest(string, null);
    }

    public Request createGetRequest(String string, Request request) throws IOException {
        string = this.getURL(string);
        boolean bl = true;
        if (this.currentURL == null) {
            bl = false;
            this.currentURL = new URL(string);
        }
        GetRequest getRequest = new GetRequest(string);
        getRequest.setCustomCharset(this.customCharset);
        if (this.selectProxy() != null) {
            getRequest.setProxy(this.selectProxy());
        }
        if (request != null) {
            getRequest.setCookies(request.getCookies());
        }
        getRequest.setConnectTimeout(this.getConnectTimeout());
        getRequest.setReadTimeout(this.getReadTimeout());
        getRequest.getHeaders().put("Accept-Language", this.acceptLanguage);
        this.forwardCookies(getRequest);
        if (bl) {
            getRequest.getHeaders().put("Referer", this.currentURL.toString());
        }
        if (this.headers != null) {
            this.mergeHeaders(getRequest);
        }
        return getRequest;
    }

    public Request createGetRequestRedirectedRequest(Request request) throws IOException {
        return this.createGetRequest(request.getLocation(), request);
    }

    public Request createPostFormDataRequest(String string) throws IOException {
        string = this.getURL(string);
        boolean bl = true;
        if (this.currentURL == null) {
            bl = false;
            this.currentURL = new URL(string);
        }
        PostFormDataRequest postFormDataRequest = new PostFormDataRequest(string);
        postFormDataRequest.setCustomCharset(this.customCharset);
        if (this.selectProxy() != null) {
            postFormDataRequest.setProxy(this.selectProxy());
        }
        postFormDataRequest.getHeaders().put("Accept-Language", this.acceptLanguage);
        postFormDataRequest.setConnectTimeout(this.getConnectTimeout());
        postFormDataRequest.setReadTimeout(this.getReadTimeout());
        this.forwardCookies(postFormDataRequest);
        if (bl) {
            postFormDataRequest.getHeaders().put("Referer", this.currentURL.toString());
        }
        if (this.headers != null) {
            this.mergeHeaders(postFormDataRequest);
        }
        return postFormDataRequest;
    }

    private Request createPostRequest(String string, ArrayList<RequestVariable> arrayList, String string2) throws IOException {
        string = this.getURL(string);
        boolean bl = true;
        if (this.currentURL == null) {
            bl = false;
            this.currentURL = new URL(string);
        }
        PostRequest postRequest = new PostRequest(string);
        postRequest.setCustomCharset(this.customCharset);
        if (this.selectProxy() != null) {
            postRequest.setProxy(this.selectProxy());
        }
        postRequest.getHeaders().put("Accept-Language", this.acceptLanguage);
        postRequest.setConnectTimeout(this.getConnectTimeout());
        postRequest.setReadTimeout(this.getReadTimeout());
        this.forwardCookies(postRequest);
        if (bl) {
            postRequest.getHeaders().put("Referer", this.currentURL.toString());
        }
        if (arrayList != null) {
            postRequest.addAll(arrayList);
        }
        String string3 = null;
        if (this.headers != null) {
            string3 = this.headers.remove("Content-Type");
        }
        if (string3 == null) {
            string3 = string2;
        }
        if (string3 == null) {
            string3 = "application/x-www-form-urlencoded";
        }
        postRequest.setContentType(string3);
        if (this.headers != null) {
            this.mergeHeaders(postRequest);
        }
        return postRequest;
    }

    public Request createPostRequest(String string, LinkedHashMap<String, String> linkedHashMap) throws IOException {
        return this.createPostRequest(string, PostRequest.variableMaptoArray(linkedHashMap), null);
    }

    public Request createPostRequest(String string, String string2) throws MalformedURLException, IOException {
        return this.createPostRequest(string, Request.parseQuery(string2));
    }

    public Request createPostRequestfromRedirectedRequest(Request request, String string) throws IOException {
        String string2 = this.getURL(request.getLocation());
        boolean bl = true;
        if (this.currentURL == null) {
            bl = false;
            this.currentURL = new URL(string2);
        }
        LinkedHashMap<String, String> linkedHashMap = Request.parseQuery(string);
        PostRequest postRequest = new PostRequest(string2);
        postRequest.setCustomCharset(this.customCharset);
        if (this.selectProxy() != null) {
            postRequest.setProxy(this.selectProxy());
        }
        postRequest.setCookies(request.getCookies());
        postRequest.getHeaders().put("Accept-Language", this.acceptLanguage);
        postRequest.setConnectTimeout(this.getConnectTimeout());
        postRequest.setReadTimeout(this.getReadTimeout());
        this.forwardCookies(postRequest);
        if (bl) {
            postRequest.getHeaders().put("Referer", this.currentURL.toString());
        }
        if (linkedHashMap != null) {
            postRequest.addAll(linkedHashMap);
        }
        if (this.headers != null) {
            this.mergeHeaders(postRequest);
        }
        return postRequest;
    }

    public Request createRequest(Form form) throws Exception {
        return this.createFormRequest(form);
    }

    public Request createRequest(String string) throws Exception {
        return this.createGetRequest(string);
    }

    public void downloadConnection(File file, URLConnectionAdapter uRLConnectionAdapter) throws IOException {
        if (uRLConnectionAdapter == null) {
            uRLConnectionAdapter = this.request.getHttpConnection();
        }
        Browser.download(file, uRLConnectionAdapter);
    }

    public String followConnection() throws IOException {
        if (this.request.getHtmlCode() != null) {
            if (this.getLogger() != null) {
                this.getLogger().warning("Request has already been read");
            }
            return null;
        }
        try {
            this.checkContentLengthLimit(this.request);
            this.request.getHttpConnection().setAllowedResponseCodes(this.allowedResponseCodes);
            this.request.read();
        }
        catch (BrowserException browserException) {
            throw browserException;
        }
        catch (IOException iOException) {
            throw new BrowserException(iOException.getMessage(), this.request.getHttpConnection(), iOException);
        }
        finally {
            this.request.disconnect();
        }
        if (this.isVerbose() && this.getLogger() != null) {
            this.getLogger().finest("\r\n" + this.request + "\r\n");
        }
        return this.request.getHtmlCode();
    }

    public void forceDebug(boolean bl) {
        this.debug = bl;
    }

    public void forwardCookies(Request request) {
        if (request == null) {
            return;
        }
        String string = Browser.getHost(request.getUrl());
        Cookies cookies = this.getCookies().get(string);
        if (cookies == null) {
            return;
        }
        for (Cookie cookie : cookies.getCookies()) {
            if (cookie.isExpired()) continue;
            request.getCookies().add(cookie);
        }
    }

    public void forwardCookies(URLConnectionAdapter uRLConnectionAdapter) {
        if (uRLConnectionAdapter == null) {
            return;
        }
        String string = Browser.getHost(uRLConnectionAdapter.getURL().toString());
        Cookies cookies = this.getCookies().get(string);
        String string2 = Request.getCookieString(cookies);
        if (string2 != null && string2.trim().length() > 0) {
            uRLConnectionAdapter.setRequestProperty("Cookie", string2);
        }
    }

    public String getAcceptLanguage() {
        return this.acceptLanguage;
    }

    public int[] getAllowedResponseCodes() {
        return this.allowedResponseCodes;
    }

    private String getBase(String string) {
        String string2;
        int n;
        if (string == null) {
            return "";
        }
        String string3 = this.getRegex("<base\\s*href=\"(.*?)\"").getMatch(0);
        if (string3 != null) {
            return string3;
        }
        URL uRL = this.request.getHttpConnection().getURL();
        String string4 = uRL.getHost();
        String string5 = "";
        if (uRL.getDefaultPort() > 0 && uRL.getPort() > 0 && uRL.getDefaultPort() != uRL.getPort()) {
            string5 = ":" + uRL.getPort();
        }
        String string6 = "http://";
        if (uRL.toString().startsWith("https")) {
            string6 = "https://";
        }
        if ((n = (string2 = uRL.getPath()).lastIndexOf(47)) >= 0) {
            string2 = string2.substring(0, n);
        }
        return string6 + string4 + string5 + string2 + "/";
    }

    public String getBaseURL() {
        if (this.request == null) {
            return null;
        }
        String string = this.request.getUrl().toString();
        return string.matches("https?://.*/.*") ? string.substring(0, string.lastIndexOf("/")) + "/" : string + "/";
    }

    public int getConnectTimeout() {
        return this.connectTimeout < 0 ? TIMEOUT_CONNECT : this.connectTimeout;
    }

    public String getCookie(String string, String string2) {
        String string3 = Browser.getHost(string);
        Cookies cookies = this.getCookies(string3);
        Cookie cookie = cookies.get(string2);
        return cookie != null ? cookie.getValue() : null;
    }

    private HashMap<String, Cookies> getCookies() {
        return this.cookiesExclusive ? this.cookies : COOKIES;
    }

    public Cookies getCookies(String string) {
        String string2 = Browser.getHost(string);
        Cookies cookies = this.getCookies().get(string2);
        if (cookies == null) {
            cookies = new Cookies();
            this.getCookies().put(string2, cookies);
        }
        return cookies;
    }

    public void getDownload(File file, String string) throws IOException {
        URLConnectionAdapter uRLConnectionAdapter = this.openGetConnection(URLDecoder.decode(string, "UTF-8"));
        Browser.download(file, uRLConnectionAdapter);
    }

    public Form getForm(int n) {
        Form[] formArray = this.getForms();
        return formArray.length <= n ? null : formArray[n];
    }

    public Form getFormbyKey(String string) {
        for (Form form : this.getForms()) {
            if (!form.hasInputFieldByName(string)) continue;
            return form;
        }
        return null;
    }

    public Form getFormbyProperty(String string, String string2) {
        for (Form form : this.getForms()) {
            if (form.getStringProperty(string) == null || !form.getStringProperty(string).equalsIgnoreCase(string2)) continue;
            return form;
        }
        return null;
    }

    public Form getFormBySubmitvalue(String string) {
        for (Form form : this.getForms()) {
            try {
                form.setPreferredSubmit(string);
                return form;
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
        }
        return null;
    }

    public Form[] getForms() {
        return Form.getForms(this);
    }

    public Form[] getForms(String string) throws IOException {
        this.getPage(string);
        return this.getForms();
    }

    public RequestHeader getHeaders() {
        if (this.headers == null) {
            this.headers = new RequestHeader();
        }
        return this.headers;
    }

    public String getHost() {
        return this.request == null ? null : this.request.getUrl().getHost();
    }

    public URLConnectionAdapter getHttpConnection() {
        if (this.request == null) {
            return null;
        }
        return this.request.getHttpConnection();
    }

    public Logger getLogger() {
        if (this.logger != null) {
            return this.logger;
        }
        return LOGGER;
    }

    public String getMatch(String string) {
        return this.getRegex(string).getMatch(0);
    }

    public String getPage(String string) throws IOException {
        this.openRequestConnection(this.createGetRequest(string));
        return this.loadConnection(null).getHtmlCode();
    }

    public String getPage(URL uRL) throws IOException {
        return this.getPage(uRL + "");
    }

    public HTTPProxy getProxy() {
        return this.proxy;
    }

    public int getReadTimeout() {
        return this.readTimeout < 0 ? TIMEOUT_READ : this.readTimeout;
    }

    public String getRedirectLocation() {
        if (this.request == null) {
            return null;
        }
        return this.request.getLocation();
    }

    public Regex getRegex(Pattern pattern) {
        return new Regex((Object)this, pattern);
    }

    public Regex getRegex(String string) {
        return new Regex((Object)this, string);
    }

    public Request getRequest() {
        return this.request;
    }

    public String getURL() {
        return this.request == null ? null : this.request.getUrl().toString();
    }

    public String getURL(String string) throws BrowserException {
        if (string == null) {
            string = this.getRedirectLocation();
        }
        if (string == null) {
            throw new BrowserException("Null URL");
        }
        try {
            new URL(string);
        }
        catch (Exception exception) {
            if (this.request == null || this.request.getHttpConnection() == null) {
                return string;
            }
            String string2 = this.getBase(string);
            if (string.startsWith("/") || string.startsWith("\\")) {
                try {
                    URL uRL = new URL(string2);
                    String string3 = "http://";
                    if (string2.startsWith("https")) {
                        string3 = "https://";
                    }
                    String string4 = "";
                    if (uRL.getDefaultPort() > 0 && uRL.getPort() > 0 && uRL.getDefaultPort() != uRL.getPort()) {
                        string4 = ":" + uRL.getPort();
                    }
                    string = string3 + new URL(string2).getHost() + string4 + string;
                }
                catch (MalformedURLException malformedURLException) {
                    malformedURLException.printStackTrace();
                }
            }
            string = string2 + string;
        }
        return Browser.correctURL(Encoding.urlEncode_light(string));
    }

    public boolean isCookiesExclusive() {
        return this.cookiesExclusive;
    }

    public boolean isDebug() {
        return this.debug || this.isVerbose();
    }

    public boolean isFollowingRedirects() {
        return this.doRedirects;
    }

    public boolean isVerbose() {
        return VERBOSE || this.verbose;
    }

    public Request loadConnection(URLConnectionAdapter uRLConnectionAdapter) throws IOException {
        Request request = uRLConnectionAdapter == null ? this.request : new Request(uRLConnectionAdapter){

            @Override
            public long postRequest() throws IOException {
                return 0L;
            }

            @Override
            public void preRequest() throws IOException {
            }
        };
        try {
            this.checkContentLengthLimit(request);
            uRLConnectionAdapter = request.getHttpConnection();
            uRLConnectionAdapter.setAllowedResponseCodes(this.allowedResponseCodes);
            request.read();
        }
        catch (BrowserException browserException) {
            throw browserException;
        }
        catch (IOException iOException) {
            throw new BrowserException(iOException.getMessage(), uRLConnectionAdapter, iOException);
        }
        finally {
            try {
                uRLConnectionAdapter.disconnect();
            }
            catch (Throwable throwable) {}
        }
        if (this.isVerbose() && this.getLogger() != null) {
            this.getLogger().finest("\r\n" + request + "\r\n");
        }
        return request;
    }

    private void mergeHeaders(Request request) {
        if (this.headers.isDominant()) {
            request.getHeaders().clear();
        }
        int n = this.headers.size();
        for (int i = 0; i < n; ++i) {
            String string = this.headers.getValue(i);
            if (string == null) {
                request.getHeaders().remove(this.headers.getKey(i));
                continue;
            }
            request.getHeaders().put(this.headers.getKey(i), string);
        }
    }

    public URLConnectionAdapter openFormConnection(Form form) throws Exception {
        return this.openRequestConnection(this.createFormRequest(form));
    }

    public URLConnectionAdapter openFormConnection(int n) throws Exception {
        return this.openFormConnection(this.getForm(n));
    }

    public URLConnectionAdapter openGetConnection(String string) throws IOException {
        return this.openRequestConnection(this.createGetRequest(string));
    }

    public URLConnectionAdapter openPostConnection(String string, LinkedHashMap<String, String> linkedHashMap) throws IOException {
        return this.openRequestConnection(this.createPostRequest(string, linkedHashMap));
    }

    public URLConnectionAdapter openPostConnection(String string, String string2) throws IOException {
        return this.openPostConnection(string, Request.parseQuery(string2));
    }

    public URLConnectionAdapter openRequestConnection(Request request) throws IOException {
        this.connect(request);
        if (this.isDebug() && this.getLogger() != null) {
            this.getLogger().finest("\r\n" + request.printHeaders());
        }
        this.updateCookies(request);
        this.request = request;
        if (this.doRedirects && request.getLocation() != null) {
            String string;
            if (request.getLocation().toLowerCase().startsWith("ftp://")) {
                throw new BrowserException("Cannot redirect to FTP");
            }
            String string2 = request.getUrl().toExternalForm();
            if (string2.equalsIgnoreCase(string = request.getLocation()) && this.redirectLoopCounter >= 20) {
                if (this.getLogger() != null) {
                    this.getLogger().severe("20 Redirects!!!");
                }
            } else if (!string2.equalsIgnoreCase(string) || this.redirectLoopCounter < 20) {
                this.redirectLoopCounter = string2.equalsIgnoreCase(string) ? ++this.redirectLoopCounter : 0;
                try {
                    request.httpConnection.disconnect();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.openGetConnection(null);
            }
        } else {
            this.currentURL = request.getUrl();
        }
        return this.request.getHttpConnection();
    }

    public String postPage(String string, LinkedHashMap<String, String> linkedHashMap) throws IOException {
        this.openPostConnection(string, linkedHashMap);
        return this.loadConnection(null).getHtmlCode();
    }

    public String postPage(String string, String string2) throws IOException {
        return this.postPage(string, Request.parseQuery(string2));
    }

    public String postPageRaw(String string, byte[] byArray) throws IOException {
        PostRequest postRequest = (PostRequest)this.createPostRequest(string, new ArrayList<RequestVariable>(), null);
        postRequest.setCustomCharset(this.customCharset);
        if (byArray != null) {
            postRequest.setPostBytes(byArray);
        }
        this.openRequestConnection(postRequest);
        return this.loadConnection(null).getHtmlCode();
    }

    public String postPageRaw(String string, String string2) throws IOException {
        PostRequest postRequest = (PostRequest)this.createPostRequest(string, new ArrayList<RequestVariable>(), null);
        postRequest.setCustomCharset(this.customCharset);
        if (string2 != null) {
            postRequest.setPostDataString(string2);
        }
        this.openRequestConnection(postRequest);
        return this.loadConnection(null).getHtmlCode();
    }

    public void reset() {
        this.currentURL = null;
        this.request = null;
        this.setCustomCharset(null);
        this.doRedirects = false;
        this.cookies = new HashMap();
        this.connectTimeout = -1;
        this.readTimeout = -1;
        this.headers = null;
        this.limit = 0x100000;
        this.proxy = null;
        this.debug = false;
        this.requestIntervalLimitMap = null;
        this.requestTimeMap = null;
        this.cookiesExclusive = true;
        this.verbose = false;
        this.allowedResponseCodes = new int[0];
        this.acceptLanguage = "de, en-gb;q=0.9, en;q=0.8";
    }

    private HTTPProxy selectProxy() {
        if (this.proxy != null) {
            if (this.proxy == HTTPProxy.NONE) {
                return HTTPProxy.NONE;
            }
            return this.proxy;
        }
        return GLOBAL_PROXY;
    }

    public void setAcceptLanguage(String string) {
        this.acceptLanguage = string;
    }

    public void setAllowedResponseCodes(int[] nArray) {
        this.allowedResponseCodes = nArray;
    }

    public void setAuth(String string, String string2, String string3) {
    }

    public void setConnectTimeout(int n) {
        this.connectTimeout = n;
    }

    public void setCookie(String string, String string2, String string3) {
        Cookies cookies;
        String string4 = Browser.getHost(string);
        if (!this.getCookies().containsKey(string4) || (cookies = this.getCookies().get(string4)) == null) {
            cookies = new Cookies();
            this.getCookies().put(string4, cookies);
        }
        cookies.add(new Cookie(string4, string2, string3));
    }

    public void setCookiesExclusive(boolean bl) {
        if (this.cookiesExclusive == bl) {
            return;
        }
        this.cookiesExclusive = bl;
        if (bl) {
            this.cookies.clear();
            for (Map.Entry<String, Cookies> entry : COOKIES.entrySet()) {
                Cookies cookies = new Cookies();
                this.cookies.put(entry.getKey(), cookies);
                cookies.add(entry.getValue());
            }
        } else {
            this.cookies.clear();
        }
    }

    public void setCurrentURL(String string) throws MalformedURLException {
        this.currentURL = string == null || string.length() == 0 ? null : new URL(string);
    }

    public void setCustomCharset(String string) {
        this.customCharset = string;
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public void setFollowRedirects(boolean bl) {
        this.doRedirects = bl;
    }

    public void setHeader(String string, String string2) {
        this.getHeaders().put(string, string2);
    }

    public void setHeaders(RequestHeader requestHeader) {
        this.headers = requestHeader;
    }

    public void setLoadLimit(int n) {
        this.limit = n;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void setProxy(HTTPProxy hTTPProxy) {
        if (this.debug && LOGGER != null) {
            LOGGER.info("Use local proxy: " + hTTPProxy);
        }
        this.proxy = hTTPProxy;
    }

    public void setReadTimeout(int n) {
        this.readTimeout = n;
    }

    public void setRequest(Request request) {
        if (request == null) {
            return;
        }
        this.updateCookies(request);
        this.request = request;
        this.currentURL = request.getUrl();
    }

    public void setRequestIntervalLimit(String string, int n) {
        String string2 = Browser.getHost(string);
        if (string2 == null) {
            return;
        }
        if (this.requestIntervalLimitMap == null) {
            this.requestTimeMap = new HashMap();
            this.requestIntervalLimitMap = new HashMap();
        }
        this.requestIntervalLimitMap.put(string2, n);
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public String submitForm(Form form) throws Exception {
        this.openFormConnection(form);
        this.checkContentLengthLimit(this.request);
        this.request.getHttpConnection().setAllowedResponseCodes(this.allowedResponseCodes);
        return this.request.read().getHtmlCode();
    }

    public String submitForm(String string) throws Exception {
        return this.submitForm(this.getFormBySubmitvalue(string));
    }

    public String toString() {
        if (this.request == null) {
            return "Browser. no request yet";
        }
        return this.request.toString();
    }

    public void updateCookies(Request request) {
        if (request == null) {
            return;
        }
        String string = Browser.getHost(request.getUrl());
        Cookies cookies = this.getCookies().get(string);
        if (cookies == null) {
            cookies = new Cookies();
            this.getCookies().put(string, cookies);
        }
        cookies.add(request.getCookies());
    }

    static {
        TIMEOUT_CONNECT = 30000;
        TIMEOUT_READ = 30000;
        VERBOSE = false;
    }

    public class BrowserException
    extends IOException {
        private static final long serialVersionUID = 1509988898224037320L;
        private URLConnectionAdapter connection;
        private Exception e;

        public BrowserException(String string) {
            super(string);
            this.e = null;
        }

        public BrowserException(String string, Exception exception) {
            this(string);
            this.e = exception;
        }

        public BrowserException(String string, URLConnectionAdapter uRLConnectionAdapter) {
            this(string);
            this.connection = uRLConnectionAdapter;
        }

        public BrowserException(String string, URLConnectionAdapter uRLConnectionAdapter, Exception exception) {
            this(string, uRLConnectionAdapter);
            this.e = exception;
        }

        public URLConnectionAdapter getConnection() {
            return this.connection;
        }

        public Exception getException() {
            return this.e;
        }
    }
}

