/*
 * Decompiled with CFR 0.152.
 */
package jd.nutils;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import jd.controlling.JDLogger;

public class DynByteBuffer {
    private ByteBuffer buffer;

    public DynByteBuffer(int n) {
        this.buffer = ByteBuffer.allocateDirect(n);
    }

    public void put(byte[] byArray, int n) {
        this.checkBufferSize(n);
        this.buffer.put(byArray);
    }

    public void put(byte by) {
        this.checkBufferSize(1);
        this.buffer.put(by);
    }

    public void put(byte[] byArray, int n, int n2) {
        this.checkBufferSize(n2);
        this.buffer.put(byArray, n, n2);
    }

    public void clear() {
        this.buffer.clear();
    }

    public String toString() {
        return new String(this.getLast(this.buffer.position()));
    }

    public byte[] toByteArray() {
        return this.getLast(this.buffer.position());
    }

    public String toString(String string) {
        try {
            return new String(this.getLast(this.buffer.position()), string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JDLogger.exception(unsupportedEncodingException);
            return new String(this.getLast(this.buffer.position()));
        }
    }

    public int capacity() {
        return this.buffer.capacity();
    }

    public int limit() {
        return this.buffer.limit();
    }

    public int position() {
        return this.buffer.position();
    }

    private void checkBufferSize(int n) {
        ByteBuffer byteBuffer;
        if (this.buffer.remaining() < n) {
            byteBuffer = ByteBuffer.allocateDirect(this.buffer.capacity() * 2);
            this.buffer.flip();
            byteBuffer.put(this.buffer);
            this.buffer = byteBuffer;
        }
        if (this.buffer.remaining() < n) {
            byteBuffer = ByteBuffer.allocateDirect(this.buffer.capacity() + n);
            this.buffer.flip();
            byteBuffer.put(this.buffer);
            this.buffer = byteBuffer;
        }
    }

    public byte get() {
        return this.buffer.get();
    }

    public Buffer flip() {
        return this.buffer.flip();
    }

    public ByteBuffer compact() {
        return this.buffer.compact();
    }

    public byte[] getLast(int n) {
        int n2 = this.buffer.position();
        n = Math.min(n2, n);
        this.buffer.position(n2 - n);
        byte[] byArray = new byte[n];
        this.buffer.get(byArray);
        this.buffer.position(n2);
        return byArray;
    }

    public byte[] getSub(int n, int n2) {
        int n3 = this.buffer.position();
        this.buffer.position(n);
        byte[] byArray = new byte[n2 - n];
        this.buffer.get(byArray);
        this.buffer.position(n3);
        return byArray;
    }

    public static PrintStream PrintStreamforDynByteBuffer(int n) {
        final OutputStream outputStream = DynByteBuffer.OutputStreamforDynByteBuffer(n);
        return new PrintStream(outputStream){

            public synchronized String toString() {
                return outputStream.toString();
            }
        };
    }

    public static OutputStream OutputStreamforDynByteBuffer(int n) {
        final DynByteBuffer dynByteBuffer = new DynByteBuffer(n);
        return new OutputStream(){

            @Override
            public synchronized void write(int n) throws IOException {
                dynByteBuffer.put((byte)n);
            }

            @Override
            public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
                dynByteBuffer.put(byArray, n, n2);
            }

            public synchronized String toString() {
                return dynByteBuffer.toString();
            }
        };
    }
}

