/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.regex.Pattern;
import jd.PluginWrapper;
import jd.config.SubConfiguration;
import jd.controlling.IOPermission;
import jd.controlling.JDLogger;
import jd.controlling.JDPluginLogger;
import jd.controlling.ProgressController;
import jd.controlling.captcha.CaptchaController;
import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.linkcrawler.LinkCrawlerDistributer;
import jd.http.Browser;
import jd.nutils.encoding.Encoding;
import jd.plugins.CryptedLink;
import jd.plugins.DecrypterException;
import jd.plugins.DownloadLink;
import jd.plugins.Plugin;
import org.appwork.utils.Regex;
import org.jdownloader.plugins.controller.crawler.LazyCrawlerPlugin;

public abstract class PluginForDecrypt
extends Plugin {
    private IOPermission ioPermission = null;
    private LinkCrawlerDistributer distributer = null;
    private LazyCrawlerPlugin lazyC = null;

    public LinkCrawlerDistributer getDistributer() {
        return this.distributer;
    }

    @Override
    public SubConfiguration getPluginConfig() {
        return SubConfiguration.getConfig(this.lazyC.getDisplayName());
    }

    public void setDistributer(LinkCrawlerDistributer linkCrawlerDistributer) {
        this.distributer = linkCrawlerDistributer;
    }

    public IOPermission getIOPermission() {
        return this.ioPermission;
    }

    public void setIOPermission(IOPermission iOPermission) {
        this.ioPermission = iOPermission;
    }

    public PluginForDecrypt() {
    }

    @Override
    public Pattern getSupportedLinks() {
        return this.lazyC.getPattern();
    }

    @Override
    public String getHost() {
        return this.lazyC.getDisplayName();
    }

    @Deprecated
    public PluginForDecrypt(PluginWrapper pluginWrapper) {
        super(pluginWrapper);
        this.lazyC = (LazyCrawlerPlugin)pluginWrapper.getLazy();
    }

    public void setBrowser(Browser browser) {
        this.br = browser;
    }

    public PluginForDecrypt getNewInstance() {
        if (this.lazyC == null) {
            return null;
        }
        return this.lazyC.newInstance();
    }

    @Override
    public long getVersion() {
        return this.lazyC.getVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sleep(long l, CryptedLink cryptedLink) throws InterruptedException {
        while (l > 0L) {
            l -= 1000L;
            PluginForDecrypt pluginForDecrypt = this;
            synchronized (pluginForDecrypt) {
                this.wait(1000L);
            }
        }
    }

    protected DownloadLink createDownloadlink(String string) {
        return new DownloadLink(null, null, this.getHost(), Encoding.urlDecode(string, true), true);
    }

    public void setLogger(JDPluginLogger jDPluginLogger) {
        this.logger = jDPluginLogger;
    }

    public abstract ArrayList<DownloadLink> decryptIt(CryptedLink var1, ProgressController var2) throws Exception;

    public ArrayList<DownloadLink> decryptLink(CrawledLink crawledLink) {
        CryptedLink cryptedLink = crawledLink.getCryptedLink();
        if (cryptedLink == null) {
            return null;
        }
        ProgressController progressController = new ProgressController();
        cryptedLink.setProgressController(progressController);
        ArrayList<DownloadLink> arrayList = null;
        boolean bl = true;
        try {
            this.br.setLogger(this.logger);
            this.br.setVerbose(true);
            this.br.setDebug(true);
            arrayList = this.decryptIt(cryptedLink, progressController);
        }
        catch (DecrypterException decrypterException) {
            if (DecrypterException.CAPTCHA.equals(decrypterException.getMessage())) {
                bl = false;
            }
            if (this.logger instanceof JDPluginLogger) {
                this.logger.clear();
            }
            this.logger.log(Level.SEVERE, "DecrypterException:" + decrypterException.getMessage(), decrypterException);
        }
        catch (InterruptedException interruptedException) {
            if (this.logger instanceof JDPluginLogger) {
                this.logger.clear();
            }
            this.logger.log(Level.SEVERE, "Interrupted", interruptedException);
        }
        catch (Throwable throwable) {
            this.logger.log(Level.SEVERE, "Exception:" + throwable.getMessage(), throwable);
        }
        if (arrayList == null && bl) {
            this.logger.severe("CrawlerPlugin out of date: " + this + " :" + this.getVersion());
            if (this.logger instanceof JDPluginLogger) {
                this.logger.logInto(JDLogger.getLogger());
            }
        }
        if (this.logger instanceof JDPluginLogger) {
            this.logger.clear();
        }
        return arrayList;
    }

    protected void distribute(DownloadLink ... downloadLinkArray) {
        LinkCrawlerDistributer linkCrawlerDistributer = this.distributer;
        if (linkCrawlerDistributer == null || downloadLinkArray == null || downloadLinkArray.length == 0) {
            return;
        }
        linkCrawlerDistributer.distribute(downloadLinkArray);
    }

    protected String getCaptchaCode(String string, CryptedLink cryptedLink) throws IOException, DecrypterException {
        return this.getCaptchaCode(this.getHost(), string, cryptedLink);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getCaptchaCode(String string, String string2, CryptedLink cryptedLink) throws IOException, DecrypterException {
        if (string2 == null) {
            this.logger.severe("Captcha Adresse nicht definiert");
            throw new DecrypterException(DecrypterException.CAPTCHA);
        }
        File file = this.getLocalCaptchaFile();
        try {
            String string3;
            Browser browser = this.br.cloneBrowser();
            try {
                browser.getDownload(file, string2);
            }
            catch (Exception exception) {
                this.logger.severe("Captcha Download fehlgeschlagen: " + string2);
                throw new DecrypterException(DecrypterException.CAPTCHA);
            }
            String string4 = string3 = this.getCaptchaCode(string, file, cryptedLink);
            return string4;
        }
        finally {
            if (file != null) {
                file.delete();
            }
        }
    }

    protected String getCaptchaCode(File file, CryptedLink cryptedLink) throws DecrypterException {
        return this.getCaptchaCode(this.getHost(), file, cryptedLink);
    }

    protected String getCaptchaCode(String string, File file, CryptedLink cryptedLink) throws DecrypterException {
        return this.getCaptchaCode(string, file, 0, cryptedLink, null, null);
    }

    protected String getCaptchaCode(String string, File file, int n, CryptedLink cryptedLink, String string2, String string3) throws DecrypterException {
        String string4 = new CaptchaController(this.ioPermission, string, file, string2, string3, this).getCode(n);
        if (string4 == null) {
            throw new DecrypterException(DecrypterException.CAPTCHA);
        }
        return string4;
    }

    public ArrayList<CrawledLink> getCrawlableLinks(String string) {
        String[] stringArray = new Regex(string, this.getSupportedLinks()).setMemoryOptimized(false).getColumn(-1);
        ArrayList<CrawledLink> arrayList = null;
        arrayList = stringArray != null && stringArray.length > 0 ? new ArrayList(stringArray.length) : new ArrayList<CrawledLink>();
        if (stringArray != null && stringArray.length > 0) {
            String[] stringArray2 = stringArray;
            int n = stringArray2.length;
            for (int i = 0; i < n; ++i) {
                String string2;
                String string3 = string2 = stringArray2[i];
                string3 = string3.trim();
                while (string3.length() > 0 && string3.charAt(0) == '\"') {
                    string3 = string3.substring(1);
                }
                while (string3.length() > 0 && string3.charAt(string3.length() - 1) == '\"') {
                    string3 = string3.substring(0, string3.length() - 1);
                }
                string3 = string3.trim();
                CrawledLink crawledLink = new CrawledLink(new CryptedLink(string3));
                arrayList.add(crawledLink);
                crawledLink.setdPlugin(this);
            }
        }
        return arrayList;
    }

    protected void setBrowserExclusive() {
        if (this.br == null) {
            return;
        }
        this.br.setCookiesExclusive(true);
        this.br.clearCookies(this.getHost());
    }

    public void setLazyC(LazyCrawlerPlugin lazyCrawlerPlugin) {
        this.lazyC = lazyCrawlerPlugin;
    }

    public LazyCrawlerPlugin getLazyC() {
        return this.lazyC;
    }

    public String getCrawlerStatusString() {
        return null;
    }
}

