/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins.decrypter;

import java.util.ArrayList;
import jd.PluginWrapper;
import jd.controlling.ProgressController;
import jd.nutils.encoding.Encoding;
import jd.plugins.CryptedLink;
import jd.plugins.DecrypterPlugin;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import jd.plugins.PluginForDecrypt;
import jd.plugins.PluginForHost;
import jd.plugins.hoster.SoundcloudCom;
import jd.utils.JDUtilities;

@DecrypterPlugin(revision="$Revision$", interfaceVersion=2, names={"soundcloud.com"}, urls={"https?://(www\\.)?(soundcloud\\.com/(?!you/|tour|signup|logout|login|premium|messages|settings|imprint|community\\-guidelines|videos|terms\\-of\\-use|sounds|jobs|press|mobile|search|upload|people|dashboard)[^<>\"\\']+(\\?format=html\\&page=\\d+|\\?page=\\d+)?|snd\\.sc/[A-Za-z09]+)"}, flags={0})
public class SoundCloudComDecrypter
extends PluginForDecrypt {
    private static final String CLIENTID = "b45b1aa10f1ac2941910a7f0d10f8e28";

    public SoundCloudComDecrypter(PluginWrapper pluginWrapper) {
        super(pluginWrapper);
    }

    @Override
    public ArrayList<DownloadLink> decryptIt(CryptedLink cryptedLink, ProgressController progressController) throws Exception {
        ArrayList<DownloadLink> arrayList = new ArrayList<DownloadLink>();
        String string = cryptedLink.toString().replaceAll("(/download|\\\\)", "").replace("www.", "").replace("http://", "https://");
        if (string.matches("http://(www\\.)?snd\\.sc/[A-Za-z09]+")) {
            this.br.setFollowRedirects(false);
            this.br.getPage(string);
            String string2 = this.br.getRedirectLocation();
            if (string2 == null) {
                this.logger.warning("Decrypter failed on redirect link: " + string);
                return null;
            }
            string = string2;
        }
        this.br.setFollowRedirects(true);
        boolean bl = string.matches(".*?soundcloud\\.com/[a-z\\-_0-9]+/(tracks|favorites)(\\?page=\\d+)?");
        if (!bl) {
            boolean bl2 = bl = !string.matches(".*?soundcloud\\.com/[a-z\\-_0-9]+/[a-z\\-_0-9]+(/)?");
            if (!bl) {
                bl = string.contains("/groups/");
            }
        }
        if (bl) {
            this.br.getPage("https://api.sndcdn.com/resolve?url=" + Encoding.urlEncode(string) + "&_status_code_map%5B302%5D=200&_status_format=json&client_id=" + CLIENTID);
            if (this.br.containsHTML("\"404 \\- Not Found\"")) {
                this.logger.info("Link offline: " + string);
                return arrayList;
            }
            PluginForHost pluginForHost = JDUtilities.getPluginForHost("soundcloud.com");
            String string3 = ((SoundcloudCom)pluginForHost).getXML("username", this.br.toString());
            String string4 = this.br.getRegex("soundcloud\\.com/users/(\\d+)</uri>").getMatch(0);
            if (string4 == null) {
                this.logger.warning("Decrypter broken for link: " + string);
                return null;
            }
            this.br.getPage("https://api.sndcdn.com/e1/users/" + string4 + "/sounds?limit=10000&offset=0&linked_partitioning=1&client_id=" + CLIENTID);
            String[] stringArray = this.br.getRegex("<stream\\-item>(.*?)</stream\\-item>").getColumn(0);
            if (stringArray == null || stringArray.length == 0) {
                this.logger.warning("Decrypter broken for link: " + string);
                return null;
            }
            for (String string5 : stringArray) {
                String string6 = ((SoundcloudCom)pluginForHost).getXML("permalink", string5);
                if (string6 == null) {
                    this.logger.warning("Decrypter broken for link: " + string);
                    return null;
                }
                DownloadLink downloadLink = this.createDownloadlink(string.replace("soundcloud", "soundclouddecrypted") + "/" + string6);
                DownloadLink.AvailableStatus availableStatus = ((SoundcloudCom)pluginForHost).checkStatus(downloadLink, string5);
                downloadLink.setAvailableStatus(availableStatus);
                arrayList.add(downloadLink);
            }
            if (string3 != null) {
                FilePackage filePackage = FilePackage.getInstance();
                filePackage.setName(string3.trim());
                filePackage.addLinks(arrayList);
            }
        } else {
            arrayList.add(this.createDownloadlink(string.replace("soundcloud", "soundclouddecrypted")));
        }
        return arrayList;
    }
}

