/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins.hoster;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import jd.PluginWrapper;
import jd.config.Property;
import jd.config.SubConfiguration;
import jd.http.Browser;
import jd.nutils.encoding.Encoding;
import jd.parser.Regex;
import jd.plugins.BrowserAdapter;
import jd.plugins.DownloadLink;
import jd.plugins.HostPlugin;
import jd.plugins.PluginException;
import jd.plugins.PluginForHost;
import jd.utils.locale.JDL;
import org.appwork.utils.net.httpconnection.HTTPConnection;
import org.jaudiotagger.audio.AudioFile;
import org.jaudiotagger.audio.AudioFileIO;
import org.jaudiotagger.tag.FieldKey;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.images.Artwork;
import org.jaudiotagger.tag.images.ArtworkFactory;

@HostPlugin(revision="$Revision$", interfaceVersion=2, names={"soundcloud.com"}, urls={"https://(www\\.)?soundclouddecrypted\\.com/[a-z\\-_0-9]+/[a-z\\-_0-9]+"}, flags={0})
public class SoundcloudCom
extends PluginForHost {
    private static final String CUSTOM_DATE = "CUSTOM_DATE";
    private static final String CUSTOM_FILENAME = "CUSTOM_FILENAME";
    private static final String defaultCustomFilename = "*songtitle* - *channelname**ext*";
    private static final String defaultCustomPackagename = "*channelname* - *playlistname*";
    private static final long MAX_ACCEPTABLE_SOUNDCLOUD_FILESIZE_FOR_COVERART_FETCH = 0xA00000L;
    private String url;
    public static final String CLIENTID = "b45b1aa10f1ac2941910a7f0d10f8e28";

    public SoundcloudCom(PluginWrapper pluginWrapper) {
        super(pluginWrapper);
    }

    @Override
    public void correctDownloadLink(DownloadLink downloadLink) {
        downloadLink.setUrlDownload(downloadLink.getDownloadURL().replace("soundclouddecrypted", "soundcloud"));
    }

    @Override
    public String getAGBLink() {
        return "http://soundcloud.com/terms-of-use";
    }

    @Override
    public int getMaxSimultanFreeDownloadNum() {
        return -1;
    }

    @Override
    public void handleFree(DownloadLink downloadLink) throws Exception {
        this.requestFileInformation(downloadLink);
        this.dl = BrowserAdapter.openDownload(this.br, downloadLink, this.url, true, 0);
        if (this.dl.getConnection().getContentType().contains("html")) {
            this.logger.warning("The final dllink seems not to be a file!");
            this.br.followConnection();
            throw new PluginException(0x400000);
        }
        if (this.dl.startDownload()) {
            this.postprocess(downloadLink);
        }
    }

    @Override
    public DownloadLink.AvailableStatus requestFileInformation(DownloadLink downloadLink) throws Exception {
        this.setBrowserExclusive();
        this.br.setFollowRedirects(true);
        this.url = downloadLink.getStringProperty("directlink");
        if (this.url != null) {
            this.checkDirectLink(downloadLink, this.url);
            if (this.url != null) {
                return DownloadLink.AvailableStatus.TRUE;
            }
        }
        this.br.getPage("https://api.sndcdn.com/resolve?url=" + Encoding.urlEncode(downloadLink.getDownloadURL()) + "&_status_code_map%5B302%5D=200&_status_format=json&client_id=" + CLIENTID);
        if (this.br.containsHTML("\"404 \\- Not Found\"")) {
            throw new PluginException(32);
        }
        DownloadLink.AvailableStatus availableStatus = this.checkStatus(downloadLink, this.br.toString());
        if (availableStatus.equals((Object)DownloadLink.AvailableStatus.FALSE)) {
            throw new PluginException(32);
        }
        if (this.url == null) {
            throw new PluginException(0x400000);
        }
        this.checkDirectLink(downloadLink, this.url);
        return DownloadLink.AvailableStatus.TRUE;
    }

    public DownloadLink.AvailableStatus checkStatus(DownloadLink downloadLink, String string) throws ParseException {
        String string2;
        String string3 = this.getXML("title", string);
        if (string3 == null) {
            downloadLink.getLinkStatus().setStatusText(JDL.L("plugins.hoster.SoundCloudCom.status.pluginBroken", "The host plugin is broken!"));
            return DownloadLink.AvailableStatus.FALSE;
        }
        string3 = Encoding.htmlDecode(string3.trim().replace("\"", "'"));
        String string4 = this.getXML("original-content-size", string);
        if (string4 != null) {
            downloadLink.setDownloadSize(Long.parseLong(string4));
        }
        if ((string2 = this.getXML("description", string)) != null) {
            try {
                downloadLink.setComment(string2);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        String string5 = new Regex(string, "<created\\-at type=\"datetime\">([^<>\"]*?)</created-at>").getMatch(0);
        String string6 = this.getXML("username", string);
        String string7 = null;
        if (string7 == null) {
            string7 = "mp3";
        }
        string6 = Encoding.htmlDecode(string6.trim());
        this.url = this.getXML("download-url", string);
        if (this.url != null) {
            downloadLink.getLinkStatus().setStatusText(JDL.L("plugins.hoster.SoundCloudCom.status.downloadavailable", "Original file is downloadable"));
        } else {
            this.url = this.getXML("stream-url", string);
            downloadLink.getLinkStatus().setStatusText(JDL.L("plugins.hoster.SoundCloudCom.status.previewavailable", "Preview (Stream) is downloadable"));
        }
        if (this.url == null) {
            downloadLink.getLinkStatus().setStatusText(JDL.L("plugins.hoster.SoundCloudCom.status.pluginBroken", "The host plugin is broken!"));
            return DownloadLink.AvailableStatus.FALSE;
        }
        this.url = this.url + "?client_id=" + CLIENTID;
        downloadLink.setProperty("directlink", this.url);
        downloadLink.setProperty("channel", string6);
        downloadLink.setProperty("plainfilename", string3);
        downloadLink.setProperty("originaldate", string5);
        downloadLink.setProperty("type", string7);
        String string8 = this.getFormattedFilename(downloadLink);
        downloadLink.setFinalFileName(string8);
        return DownloadLink.AvailableStatus.TRUE;
    }

    public String getFormattedFilename(DownloadLink downloadLink) throws ParseException {
        String string;
        String string2 = downloadLink.getStringProperty("plainfilename", null);
        SubConfiguration subConfiguration = SubConfiguration.getConfig("soundcloud.com");
        String string3 = subConfiguration.getStringProperty(CUSTOM_FILENAME, defaultCustomFilename);
        if (string3 == null || string3.equals("")) {
            string3 = defaultCustomFilename;
        }
        if (!string3.contains("*songtitle*") || !string3.contains("*ext*")) {
            string3 = defaultCustomFilename;
        }
        string = (string = downloadLink.getStringProperty("type", null)) != null ? "." + string : ".mp3";
        String string4 = downloadLink.getStringProperty("originaldate", null);
        String string5 = downloadLink.getStringProperty("channel", null);
        String string6 = null;
        if (string4 != null && string3.contains("*date*")) {
            string4 = string4.replace("T", ":");
            String string7 = subConfiguration.getStringProperty(CUSTOM_DATE, "dd.MM.yyyy_HH-mm-ss");
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd:HH:mm");
            Date date = simpleDateFormat.parse(string4);
            string6 = simpleDateFormat.format(date);
            Date date2 = simpleDateFormat.parse(string6);
            if (string7 != null) {
                try {
                    simpleDateFormat = new SimpleDateFormat(string7);
                    string6 = simpleDateFormat.format(date2);
                }
                catch (Exception exception) {
                    string6 = "";
                }
            }
            string3 = string6 != null ? string3.replace("*date*", string6) : string3.replace("*date*", "");
        }
        if (string3.contains("*channelname*") && string5 != null) {
            string3 = string3.replace("*channelname*", string5);
        }
        string3 = string3.replace("*ext*", string);
        string3 = string3.replace("*songtitle*", string2);
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkDirectLink(DownloadLink downloadLink, String string) {
        HTTPConnection hTTPConnection = null;
        try {
            Browser browser = this.br.cloneBrowser();
            hTTPConnection = browser.openGetConnection(this.url);
            if (hTTPConnection.getContentType().contains("html") || hTTPConnection.getLongContentLength() == -1L || hTTPConnection.getResponseCode() == 401) {
                downloadLink.setProperty(string, Property.NULL);
                this.url = null;
                return;
            }
            downloadLink.setDownloadSize(hTTPConnection.getLongContentLength());
        }
        catch (Exception exception) {
            downloadLink.setProperty(string, Property.NULL);
            this.url = null;
        }
        finally {
            try {
                hTTPConnection.disconnect();
            }
            catch (Throwable throwable) {}
        }
    }

    private String getJson(String string) {
        return this.br.getRegex("\"" + string + "\":\"([^<>\"]*?)\"").getMatch(0);
    }

    public String getXML(String string, String string2) {
        return new Regex(string2, "<" + string + "( type=\"[^<>\"/]*?\")?>([^<>]*?)</" + string + ">").getMatch(1);
    }

    @Override
    public void reset() {
    }

    @Override
    public void resetDownloadlink(DownloadLink downloadLink) {
    }

    private void postprocess(DownloadLink downloadLink) {
        try {
            if (((Boolean)downloadLink.getProperty("setid3tag", "false")).booleanValue()) {
                String string = (String)downloadLink.getProperty("thumbnailUrl", null);
                String string2 = (String)downloadLink.getProperty("username", null);
                String string3 = (String)downloadLink.getProperty("title", null);
                String string4 = (String)downloadLink.getProperty("detailsUrl", null);
                File file = new File(downloadLink.getFileOutput());
                File file2 = new File(downloadLink.getFileOutput().replace(".mp3", "_id3.mp3"));
                this.downloadAndUpdateCoverArt(file, file2, string, string2, string3, string4);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private void downloadAndUpdateCoverArt(File file, File file2, String string, String string2, String string3, String string4) {
        byte[] byArray;
        if (file != null && file.exists() && file.length() <= 0xA00000L && (byArray = this.downloadCoverArt(string)) != null && byArray.length > 0 && !this.setAlbumArt(byArray, file.getAbsolutePath(), file2.getAbsolutePath(), string2, string3, string4) && file2.exists()) {
            file2.delete();
        }
    }

    private byte[] downloadCoverArt(String string) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            SoundcloudCom.simpleHTTP(string, byteArrayOutputStream, 3000);
            return byteArrayOutputStream.toByteArray();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private boolean setAlbumArt(byte[] byArray, String string, String string2, String string3, String string4, String string5) {
        try {
            AudioFile audioFile = AudioFileIO.read((File)new File(string));
            Tag tag = audioFile.getTagOrCreateAndSetDefault();
            tag.setField(FieldKey.ALBUM, string3 + ": " + string4 + " via SoundCloud.com");
            tag.setField(FieldKey.ARTIST, string3);
            tag.setField(FieldKey.TITLE, string4);
            tag.setField(FieldKey.URL_OFFICIAL_RELEASE_SITE, string5);
            Artwork artwork = ArtworkFactory.getNew();
            artwork.setBinaryData(byArray);
            artwork.setMimeType("image/jpg");
            tag.addField(artwork);
            audioFile.commit();
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private String cleanupFilename(String string) {
        if ((string = string.replace("&#8482;", "TM")).endsWith(".m4a")) {
            string = string.replace(".m4a", ".mp3");
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void simpleHTTP(String string, OutputStream outputStream, int n) throws Throwable {
        URL uRL = new URL(string);
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setConnectTimeout(n);
        uRLConnection.setReadTimeout(n);
        InputStream inputStream = uRLConnection.getInputStream();
        try {
            byte[] byArray = new byte[1024];
            int n2 = 0;
            while ((n2 = inputStream.read(byArray, 0, byArray.length)) != -1) {
                outputStream.write(byArray, 0, n2);
            }
        }
        finally {
            try {
                outputStream.close();
            }
            catch (Throwable throwable) {}
            try {
                inputStream.close();
            }
            catch (Throwable throwable) {}
        }
    }
}

