/*
 * Decompiled with CFR 0.152.
 */
package jd.utils;

import java.util.ArrayList;
import java.util.Calendar;
import jd.controlling.JDLogger;
import jd.controlling.reconnect.ipcheck.IPController;
import jd.nutils.Formatter;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import jd.utils.JDUtilities;
import org.appwork.utils.Application;
import org.jdownloader.translate._JDT;

public final class Replacer {
    private static ArrayList<String[]> KEYS = null;

    public static synchronized String getKey(int n) {
        if (KEYS == null) {
            Replacer.initKeys();
        }
        return n >= KEYS.size() ? null : KEYS.get(n)[0];
    }

    public static synchronized String[] getKeyList() {
        if (KEYS == null) {
            Replacer.initKeys();
        }
        int n = KEYS.size();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            String[] stringArray2 = KEYS.get(i);
            stringArray[i] = "%" + stringArray2[0] + "%   (" + stringArray2[1] + ")";
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getReplacement(String string, DownloadLink downloadLink) {
        if (string.startsWith("LAST_FINISHED_") && downloadLink == null) {
            return "";
        }
        if (string.equalsIgnoreCase("LAST_FINISHED_PACKAGE.AUTO_PASSWORD")) {
            return FilePackage.getPasswordAuto(downloadLink.getFilePackage()).toString();
        }
        Object object = downloadLink.getFilePackage();
        synchronized (object) {
            if (string.equalsIgnoreCase("LAST_FINISHED_PACKAGE.FILELIST")) {
                return downloadLink.getFilePackage().getChildren().toString();
            }
        }
        if (string.equalsIgnoreCase("LAST_FINISHED_PACKAGE.PACKAGENAME")) {
            object = downloadLink.getFilePackage().getName();
            if (object == null || ((String)object).equals("") || ((String)object).equals(_JDT._.controller_packages_defaultname())) {
                return downloadLink.getName();
            }
            return downloadLink.getFilePackage().getName();
        }
        if (string.equalsIgnoreCase("LAST_FINISHED_PACKAGE.COMMENT")) {
            object = downloadLink.getFilePackage().getComment();
            if (object == null) {
                object = "";
            }
            return object;
        }
        if (string.equalsIgnoreCase("LAST_FINISHED_PACKAGE.DOWNLOAD_DIRECTORY")) {
            return downloadLink.getFilePackage().getDownloadDirectory();
        }
        if (string.equalsIgnoreCase("LAST_FINISHED_FILE.DOWNLOAD_PATH")) {
            return downloadLink.getFileOutput();
        }
        if (string.equalsIgnoreCase("LAST_FINISHED_FILE.HOST")) {
            return downloadLink.getHost();
        }
        if (string.equalsIgnoreCase("LAST_FINISHED_FILE.NAME")) {
            return downloadLink.getName();
        }
        if (string.equalsIgnoreCase("LAST_FINISHED_FILE.FILESIZE")) {
            return downloadLink.getDownloadSize() + "";
        }
        if (string.equalsIgnoreCase("LAST_FINISHED_FILE.AVAILABLE")) {
            return downloadLink.isAvailable() ? "YES" : "NO";
        }
        if (string.equals("LAST_FINISHED_FILE.BROWSER_URL")) {
            return downloadLink.getBrowserUrl();
        }
        if (string.equals("LAST_FINISHED_FILE.DOWNLOAD_URL")) {
            return downloadLink.getLinkType() == 1 ? "[Not allowed]" : downloadLink.getDownloadURL();
        }
        if (string.equals("LAST_FINISHED_FILE.CHECKSUM")) {
            object = new StringBuilder();
            if (downloadLink.getSha1Hash() != null) {
                ((StringBuilder)object).append("SHA1: ").append(downloadLink.getSha1Hash());
            }
            if (downloadLink.getMD5Hash() != null) {
                if (((StringBuilder)object).length() > 0) {
                    ((StringBuilder)object).append(' ');
                }
                ((StringBuilder)object).append("MD5: ").append(downloadLink.getMD5Hash());
            }
            if (((StringBuilder)object).length() > 0) {
                return ((StringBuilder)object).toString();
            }
            return "[Not set]";
        }
        if (string.equalsIgnoreCase("SYSTEM.IP")) {
            return IPController.getInstance().getIP().toString();
        }
        if (string.equalsIgnoreCase("SYSTEM.DATE")) {
            object = Calendar.getInstance();
            return Formatter.fillInteger(((Calendar)object).get(5), 2, "0") + "." + Formatter.fillInteger(((Calendar)object).get(2) + 1, 2, "0") + "." + ((Calendar)object).get(1);
        }
        if (string.equalsIgnoreCase("SYSTEM.TIME")) {
            object = Calendar.getInstance();
            return Formatter.fillInteger(((Calendar)object).get(11), 2, "0") + ":" + Formatter.fillInteger(((Calendar)object).get(12), 2, "0") + ":" + Formatter.fillInteger(((Calendar)object).get(13), 2, "0");
        }
        if (string.equalsIgnoreCase("SYSTEM.JAVA_VERSION")) {
            return Application.getJavaVersion() + "";
        }
        if (string.equalsIgnoreCase("JD.REVISION")) {
            return JDUtilities.getRevision();
        }
        if (string.equalsIgnoreCase("JD.HOME_DIR")) {
            return JDUtilities.getJDHomeDirectoryFromEnvironment().getAbsolutePath();
        }
        return "";
    }

    private static void initKeys() {
        KEYS = new ArrayList();
        KEYS.add(new String[]{"LAST_FINISHED_PACKAGE.PASSWORD", _JDT._.replacer_password()});
        KEYS.add(new String[]{"LAST_FINISHED_PACKAGE.AUTO_PASSWORD", _JDT._.replacer_autopassword()});
        KEYS.add(new String[]{"LAST_FINISHED_PACKAGE.FILELIST", _JDT._.replacer_filelist()});
        KEYS.add(new String[]{"LAST_FINISHED_PACKAGE.PACKAGENAME", _JDT._.replacer_packagename()});
        KEYS.add(new String[]{"LAST_FINISHED_PACKAGE.COMMENT", _JDT._.replacer_comment()});
        KEYS.add(new String[]{"LAST_FINISHED_PACKAGE.DOWNLOAD_DIRECTORY", _JDT._.replacer_downloaddirectory()});
        KEYS.add(new String[]{"LAST_FINISHED_FILE.DOWNLOAD_PATH", _JDT._.replacer_filepath()});
        KEYS.add(new String[]{"LAST_FINISHED_FILE.HOST", _JDT._.replacer_hoster()});
        KEYS.add(new String[]{"LAST_FINISHED_FILE.NAME", _JDT._.replacer_filename()});
        KEYS.add(new String[]{"LAST_FINISHED_FILE.FILESIZE", _JDT._.replacer_filesize()});
        KEYS.add(new String[]{"LAST_FINISHED_FILE.AVAILABLE", _JDT._.replacer_available()});
        KEYS.add(new String[]{"LAST_FINISHED_FILE.BROWSER_URL", _JDT._.replacer_browserurl()});
        KEYS.add(new String[]{"LAST_FINISHED_FILE.DOWNLOAD_URL", _JDT._.replacer_downloadurl()});
        KEYS.add(new String[]{"LAST_FINISHED_FILE.CHECKSUM", _JDT._.replacer_checksum()});
        KEYS.add(new String[]{"SYSTEM.IP", _JDT._.replacer_ipaddress()});
        KEYS.add(new String[]{"SYSTEM.DATE", _JDT._.replacer_date()});
        KEYS.add(new String[]{"SYSTEM.TIME", _JDT._.replacer_time()});
        KEYS.add(new String[]{"SYSTEM.JAVA_VERSION", _JDT._.replacer_javaversion()});
        KEYS.add(new String[]{"JD.REVISION", _JDT._.replacer_jdversion()});
        KEYS.add(new String[]{"JD.HOME_DIR", _JDT._.replacer_jdhomedirectory()});
    }

    public static String insertVariables(String string, DownloadLink downloadLink) {
        String string2 = "";
        if (string != null) {
            string2 = string;
            if (KEYS == null) {
                Replacer.initKeys();
            }
            for (String[] stringArray : KEYS) {
                if (string.indexOf("%" + stringArray[0] + "%") < 0) continue;
                JDLogger.getLogger().finer("%" + stringArray[0] + "% --> *****");
                string2 = Replacer.replace(string2, "%" + stringArray[0] + "%", Replacer.getReplacement(stringArray[0], downloadLink));
            }
        }
        return string2;
    }

    private static String replace(String string, String string2, String string3) {
        if (string == null || string2 == null || string2.length() == 0) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        int n2 = 0;
        int n3 = string2.length();
        while ((n2 = string.indexOf(string2, n)) > -1) {
            stringBuilder.append(string.substring(n, n2));
            stringBuilder.append(string3);
            n = n2 + n3;
        }
        int n4 = string.length();
        if (n < n4) {
            stringBuilder.append(string.substring(n, n4));
        }
        return stringBuilder.toString();
    }

    private Replacer() {
    }
}

