/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.config;

import java.io.File;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import org.appwork.exceptions.WTFException;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.config.ConfigInterface;
import org.appwork.storage.config.handler.StorageHandler;
import org.appwork.utils.Application;

public class JsonConfig {
    private static final HashMap<String, ConfigInterface> CACHE = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends ConfigInterface> T create(Class<T> clazz) {
        ConfigInterface configInterface = CACHE.get(clazz.getName());
        if (configInterface == null) {
            Object object = JSonStorage.LOCK;
            synchronized (object) {
                configInterface = CACHE.get(clazz.getName());
                if (configInterface == null) {
                    Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, new InvocationHandler(){

                        @Override
                        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
                            return null;
                        }
                    });
                    configInterface = CACHE.get(clazz.getName());
                }
                if (configInterface == null && (configInterface = CACHE.get(clazz.getName())) == null) {
                    configInterface = (ConfigInterface)Proxy.newProxyInstance(JsonConfig.class.getClassLoader(), new Class[]{clazz}, new StorageHandler<T>(Application.getResource("cfg/" + clazz.getName()), clazz));
                    CACHE.put(clazz.getName(), configInterface);
                }
            }
        }
        return (T)configInterface;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends ConfigInterface> T create(File file, Class<T> clazz) {
        String string = file.getAbsolutePath() + clazz.getName();
        Object object = JSonStorage.LOCK;
        synchronized (object) {
            ConfigInterface configInterface = CACHE.get(string);
            if (configInterface == null) {
                configInterface = (ConfigInterface)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, new StorageHandler<T>(file, clazz));
                CACHE.put(string, configInterface);
            }
            return (T)configInterface;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends ConfigInterface> T create(String string, Class<T> clazz) {
        try {
            String string2 = string + clazz.getName();
            Object object = JSonStorage.LOCK;
            synchronized (object) {
                ConfigInterface configInterface = CACHE.get(string2);
                if (configInterface == null) {
                    configInterface = (ConfigInterface)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, new StorageHandler<T>(string, clazz));
                    CACHE.put(string2, configInterface);
                }
                return (T)configInterface;
            }
        }
        catch (Exception exception) {
            throw new WTFException(exception);
        }
    }

    public static HashMap<String, ConfigInterface> getCache() {
        return CACHE;
    }
}

