/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.config.handler;

import java.lang.annotation.Annotation;
import org.appwork.storage.config.annotations.DefaultFloatValue;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.storage.config.handler.StorageHandler;

public class FloatKeyHandler
extends KeyHandler<Float> {
    public FloatKeyHandler(StorageHandler<?> storageHandler, String string) {
        super(storageHandler, string);
    }

    @Override
    protected Class<? extends Annotation> getDefaultAnnotation() {
        return DefaultFloatValue.class;
    }

    @Override
    protected void initDefaults() throws Throwable {
        this.setDefaultValue(Float.valueOf(0.0f));
    }

    @Override
    protected void initHandler() {
        try {
            this.setDefaultValue(Float.valueOf(this.getAnnotation(DefaultFloatValue.class).value()));
        }
        catch (NullPointerException nullPointerException) {
            this.setDefaultValue(Float.valueOf(0.0f));
        }
    }

    @Override
    protected void putValue(Float f) {
        this.storageHandler.putPrimitive(this.setter.getKey(), f);
    }

    @Override
    protected void validateValue(Float f) throws Throwable {
    }
}

