/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.config.handler;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import org.appwork.storage.config.ValidationException;
import org.appwork.storage.config.annotations.DefaultIntValue;
import org.appwork.storage.config.annotations.SpinnerValidator;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.storage.config.handler.StorageHandler;

public class IntegerKeyHandler
extends KeyHandler<Integer> {
    private SpinnerValidator validator;
    private int min;
    private int max;

    public IntegerKeyHandler(StorageHandler<?> storageHandler, String string) {
        super(storageHandler, string);
    }

    @Override
    protected Class<? extends Annotation>[] getAllowedAnnotations() {
        ArrayList<Class<SpinnerValidator>> arrayList = new ArrayList<Class<SpinnerValidator>>();
        arrayList.add(SpinnerValidator.class);
        return arrayList.toArray(new Class[0]);
    }

    @Override
    protected Class<? extends Annotation> getDefaultAnnotation() {
        return DefaultIntValue.class;
    }

    @Override
    protected void initDefaults() throws Throwable {
        this.setDefaultValue(0);
    }

    @Override
    protected void initHandler() {
        this.validator = this.getAnnotation(SpinnerValidator.class);
        if (this.validator != null) {
            this.min = (int)this.validator.min();
            this.max = (int)this.validator.max();
        }
    }

    @Override
    protected void putValue(Integer n) {
        this.storageHandler.putPrimitive(this.getKey(), n);
    }

    @Override
    protected void validateValue(Integer n) throws Throwable {
        int n2;
        if (this.validator != null && ((n2 = n.intValue()) < this.min || n2 > this.max)) {
            throw new ValidationException();
        }
    }
}

