/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.config.handler;

import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Locale;
import org.appwork.exceptions.WTFException;
import org.appwork.shutdown.ShutdownController;
import org.appwork.shutdown.ShutdownEvent;
import org.appwork.storage.InvalidTypeException;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.JsonKeyValueStorage;
import org.appwork.storage.StorageException;
import org.appwork.storage.config.ConfigInterface;
import org.appwork.storage.config.InterfaceParseException;
import org.appwork.storage.config.MethodHandler;
import org.appwork.storage.config.annotations.AllowStorage;
import org.appwork.storage.config.annotations.CryptedStorage;
import org.appwork.storage.config.annotations.DefaultBooleanArrayValue;
import org.appwork.storage.config.annotations.DefaultByteArrayValue;
import org.appwork.storage.config.annotations.DefaultDoubleArrayValue;
import org.appwork.storage.config.annotations.DefaultFloatArrayValue;
import org.appwork.storage.config.annotations.DefaultIntArrayValue;
import org.appwork.storage.config.annotations.DefaultLongArrayValue;
import org.appwork.storage.config.events.ConfigEvent;
import org.appwork.storage.config.events.ConfigEventSender;
import org.appwork.storage.config.handler.BooleanKeyHandler;
import org.appwork.storage.config.handler.ByteKeyHandler;
import org.appwork.storage.config.handler.DoubleKeyHandler;
import org.appwork.storage.config.handler.EnumKeyHandler;
import org.appwork.storage.config.handler.EnumListHandler;
import org.appwork.storage.config.handler.FloatKeyHandler;
import org.appwork.storage.config.handler.IntegerKeyHandler;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.storage.config.handler.ListHandler;
import org.appwork.storage.config.handler.LongKeyHandler;
import org.appwork.storage.config.handler.ObjectKeyHandler;
import org.appwork.storage.config.handler.StringKeyHandler;
import org.appwork.storage.config.handler.StringListHandler;
import org.appwork.utils.Application;
import org.appwork.utils.logging.Log;
import org.appwork.utils.reflection.Clazz;

public class StorageHandler<T extends ConfigInterface>
implements InvocationHandler {
    private final Class<T> configInterface;
    private HashMap<Method, KeyHandler<?>> methodMap;
    private HashMap<String, KeyHandler<?>> keyHandlerMap;
    protected final JsonKeyValueStorage primitiveStorage;
    private boolean crypted;
    private byte[] key = JSonStorage.KEY;
    private File path;
    private ConfigEventSender<Object> eventSender;
    private String relativCPPath;
    public static HashMap<String, Long> PROFILER_MAP = null;
    public static HashMap<String, Long> PROFILER_CALLNUM_MAP = null;

    public StorageHandler(String string, final Class<T> clazz) throws URISyntaxException {
        CryptedStorage cryptedStorage;
        this.configInterface = clazz;
        this.eventSender = new ConfigEventSender();
        this.relativCPPath = string;
        this.path = Application.getResource(string);
        if (this.path.getName().endsWith(".json") || this.path.getName().endsWith(".ejs")) {
            Log.L.warning(string + " should not have an extension!!");
        }
        if ((cryptedStorage = clazz.getAnnotation(CryptedStorage.class)) != null) {
            this.crypted = true;
            if (cryptedStorage.key() != null) {
                this.path = new File(Application.class.getClassLoader().getResource(string + ".ejs").toURI());
                this.primitiveStorage = new JsonKeyValueStorage(Application.getResource(string + ".ejs"), Application.class.getClassLoader().getResource(string + ".ejs"), false, cryptedStorage.key());
                this.key = cryptedStorage.key();
                if (this.key.length != JSonStorage.KEY.length) {
                    throw new InterfaceParseException("Crypt key for " + clazz + " is invalid");
                }
            } else {
                this.path = new File(Application.class.getClassLoader().getResource(string + ".ejs").toURI());
                this.key = JSonStorage.KEY;
                this.primitiveStorage = new JsonKeyValueStorage(Application.getResource(string + ".ejs"), Application.class.getClassLoader().getResource(string + ".ejs"), false, JSonStorage.KEY);
            }
        } else {
            this.crypted = false;
            this.primitiveStorage = new JsonKeyValueStorage(Application.getResource(string + ".json"), Application.class.getClassLoader().getResource(string + ".json"), true, null);
        }
        try {
            this.parseInterface();
        }
        catch (Throwable throwable) {
            throw new InterfaceParseException(throwable);
        }
        Log.L.finer("Load Storage: " + this.path);
        ShutdownController.getInstance().addShutdownEvent(new ShutdownEvent(){

            @Override
            public int getHookPriority() {
                return 0;
            }

            @Override
            public void run() {
                StorageHandler.this.primitiveStorage.save();
            }

            @Override
            public String toString() {
                return "Save " + StorageHandler.this.path + "[" + clazz.getName() + "]";
            }
        });
    }

    public String getRelativCPPath() {
        return this.relativCPPath;
    }

    public StorageHandler(File file, Class<T> clazz) {
        CryptedStorage cryptedStorage;
        this.configInterface = clazz;
        this.eventSender = new ConfigEventSender();
        this.path = file;
        if (file.getName().endsWith(".json") || file.getName().endsWith(".ejs")) {
            Log.L.warning(file + " should not have an extension!!");
        }
        if ((cryptedStorage = clazz.getAnnotation(CryptedStorage.class)) != null) {
            this.crypted = true;
            if (cryptedStorage.key() != null) {
                this.primitiveStorage = new JsonKeyValueStorage(new File(this.path.getAbsolutePath() + ".ejs"), false, cryptedStorage.key());
                this.key = cryptedStorage.key();
                if (this.key.length != JSonStorage.KEY.length) {
                    throw new InterfaceParseException("Crypt key for " + clazz + " is invalid");
                }
            } else {
                this.key = JSonStorage.KEY;
                this.primitiveStorage = new JsonKeyValueStorage(new File(this.path.getAbsolutePath() + ".ejs"), false, JSonStorage.KEY);
            }
        } else {
            this.crypted = false;
            this.primitiveStorage = new JsonKeyValueStorage(new File(this.path.getAbsolutePath() + ".json"), true);
        }
        try {
            this.parseInterface();
        }
        catch (Throwable throwable) {
            throw new InterfaceParseException(throwable);
        }
        Log.L.finer("Load Storage: " + this.path);
    }

    private KeyHandler<?> createKeyHandler(String string, Type type) {
        if (Clazz.isBoolean(type)) {
            return new BooleanKeyHandler(this, string);
        }
        if (Clazz.isByte(type)) {
            return new ByteKeyHandler(this, string);
        }
        if (Clazz.isDouble(type)) {
            return new DoubleKeyHandler(this, string);
        }
        if (Clazz.isFloat(type)) {
            return new FloatKeyHandler(this, string);
        }
        if (Clazz.isInteger(type)) {
            return new IntegerKeyHandler(this, string);
        }
        if (type instanceof Class && ((Class)type).isEnum()) {
            return new EnumKeyHandler(this, string);
        }
        if (type == String.class) {
            return new StringKeyHandler(this, string);
        }
        if (Clazz.isLong(type)) {
            return new LongKeyHandler(this, string);
        }
        if (type instanceof Class && ((Class)type).isArray()) {
            Class<?> clazz = ((Class)type).getComponentType();
            boolean bl = clazz.isPrimitive();
            if (Clazz.isBoolean(clazz)) {
                if (bl) {
                    return new ListHandler<boolean[]>(this, string, type){

                        @Override
                        protected Class<? extends Annotation> getDefaultAnnotation() {
                            return DefaultBooleanArrayValue.class;
                        }
                    };
                }
                return new ListHandler<Boolean[]>(this, string, type){

                    @Override
                    protected Class<? extends Annotation> getDefaultAnnotation() {
                        return DefaultBooleanArrayValue.class;
                    }
                };
            }
            if (Clazz.isLong(clazz)) {
                if (bl) {
                    return new ListHandler<long[]>(this, string, type){

                        @Override
                        protected Class<? extends Annotation> getDefaultAnnotation() {
                            return DefaultLongArrayValue.class;
                        }
                    };
                }
                return new ListHandler<Long[]>(this, string, type){

                    @Override
                    protected Class<? extends Annotation> getDefaultAnnotation() {
                        return DefaultLongArrayValue.class;
                    }
                };
            }
            if (Clazz.isInteger(clazz)) {
                if (bl) {
                    return new ListHandler<int[]>(this, string, type){

                        @Override
                        protected Class<? extends Annotation> getDefaultAnnotation() {
                            return DefaultIntArrayValue.class;
                        }
                    };
                }
                return new ListHandler<Integer[]>(this, string, type){

                    @Override
                    protected Class<? extends Annotation> getDefaultAnnotation() {
                        return DefaultIntArrayValue.class;
                    }
                };
            }
            if (Clazz.isByte(clazz)) {
                if (bl) {
                    return new ListHandler<byte[]>(this, string, type){

                        @Override
                        protected Class<? extends Annotation> getDefaultAnnotation() {
                            return DefaultByteArrayValue.class;
                        }
                    };
                }
                return new ListHandler<Byte[]>(this, string, type){

                    @Override
                    protected Class<? extends Annotation> getDefaultAnnotation() {
                        return DefaultByteArrayValue.class;
                    }
                };
            }
            if (Clazz.isFloat(clazz)) {
                if (bl) {
                    return new ListHandler<float[]>(this, string, type){

                        @Override
                        protected Class<? extends Annotation> getDefaultAnnotation() {
                            return DefaultFloatArrayValue.class;
                        }
                    };
                }
                return new ListHandler<Float[]>(this, string, type){

                    @Override
                    protected Class<? extends Annotation> getDefaultAnnotation() {
                        return DefaultFloatArrayValue.class;
                    }
                };
            }
            if (clazz == String.class) {
                return new StringListHandler(this, string, type);
            }
            if (clazz.isEnum()) {
                return new EnumListHandler(this, string, type);
            }
            if (Clazz.isDouble(clazz)) {
                if (bl) {
                    return new ListHandler<double[]>(this, string, type){

                        @Override
                        protected Class<? extends Annotation> getDefaultAnnotation() {
                            return DefaultDoubleArrayValue.class;
                        }
                    };
                }
                return new ListHandler<Double[]>(this, string, type){

                    @Override
                    protected Class<? extends Annotation> getDefaultAnnotation() {
                        return DefaultDoubleArrayValue.class;
                    }
                };
            }
            return new ObjectKeyHandler(this, string, type);
        }
        return new ObjectKeyHandler(this, string, type);
    }

    protected void fireEvent(ConfigEvent.Types types, KeyHandler<?> keyHandler, Object object) {
        this.eventSender.fireEvent(new ConfigEvent(types, keyHandler, object));
    }

    public Class<T> getConfigInterface() {
        return this.configInterface;
    }

    protected byte[] getCryptKey() {
        return this.key;
    }

    public ConfigEventSender<Object> getEventSender() {
        return this.eventSender;
    }

    public byte[] getKey() {
        return this.key;
    }

    public KeyHandler<Object> getKeyHandler(String string) {
        return this.getKeyHandler(string, KeyHandler.class);
    }

    public <E extends KeyHandler<?>> E getKeyHandler(String string, Class<E> clazz) {
        KeyHandler<?> keyHandler = this.keyHandlerMap.get(string.toLowerCase(Locale.ENGLISH));
        if (keyHandler == null) {
            throw new NullPointerException("No KeyHandler: " + string + " in " + this.configInterface);
        }
        return (E)keyHandler;
    }

    public HashMap<Method, KeyHandler<?>> getMap() {
        return this.methodMap;
    }

    public File getPath() {
        return this.path;
    }

    public Object getPrimitive(KeyHandler<?> keyHandler) {
        if (this.primitiveStorage.hasProperty(keyHandler.getKey())) {
            if (Clazz.isBoolean(keyHandler.getRawClass())) {
                return this.getPrimitive(keyHandler.getKey(), false);
            }
            if (Clazz.isLong(keyHandler.getRawClass())) {
                return this.getPrimitive(keyHandler.getKey(), 0L);
            }
            if (Clazz.isInteger(keyHandler.getRawClass())) {
                return this.getPrimitive(keyHandler.getKey(), 0);
            }
            if (Clazz.isFloat(keyHandler.getRawClass())) {
                return this.getPrimitive(keyHandler.getKey(), Float.valueOf(0.0f));
            }
            if (Clazz.isByte(keyHandler.getRawClass())) {
                return this.getPrimitive(keyHandler.getKey(), (byte)0);
            }
            if (keyHandler.getRawClass() == String.class) {
                return this.getPrimitive(keyHandler.getKey(), null);
            }
            if (keyHandler.getRawClass().isEnum()) {
                return this.getPrimitive(keyHandler.getKey(), keyHandler.getDefaultValue());
            }
            if (keyHandler.getRawClass() == Double.class | keyHandler.getRawClass() == Double.TYPE) {
                return this.getPrimitive(keyHandler.getKey(), 0.0);
            }
            throw new StorageException("Invalid datatype: " + keyHandler.getRawClass());
        }
        if (Clazz.isBoolean(keyHandler.getRawClass())) {
            return this.getPrimitive(keyHandler.getKey(), keyHandler.getDefaultValue());
        }
        if (Clazz.isLong(keyHandler.getRawClass())) {
            return this.getPrimitive(keyHandler.getKey(), keyHandler.getDefaultValue());
        }
        if (Clazz.isInteger(keyHandler.getRawClass())) {
            return this.getPrimitive(keyHandler.getKey(), keyHandler.getDefaultValue());
        }
        if (Clazz.isFloat(keyHandler.getRawClass())) {
            return this.getPrimitive(keyHandler.getKey(), keyHandler.getDefaultValue());
        }
        if (Clazz.isByte(keyHandler.getRawClass())) {
            return this.getPrimitive(keyHandler.getKey(), keyHandler.getDefaultValue());
        }
        if (keyHandler.getRawClass() == String.class) {
            return this.getPrimitive(keyHandler.getKey(), keyHandler.getDefaultValue());
        }
        if (keyHandler.getRawClass().isEnum()) {
            return this.getPrimitive(keyHandler.getKey(), keyHandler.getDefaultValue());
        }
        if (Clazz.isDouble(keyHandler.getRawClass())) {
            return this.getPrimitive(keyHandler.getKey(), keyHandler.getDefaultValue());
        }
        throw new StorageException("Invalid datatype: " + keyHandler.getRawClass());
    }

    public <E> E getPrimitive(String string, E e) {
        return this.primitiveStorage.get(string, e);
    }

    public Object getValue(String string) {
        return this.getKeyHandler(string).getValue();
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        block28: {
            StorageHandler storageHandler;
            block29: {
                long l;
                block26: {
                    String string;
                    block27: {
                        block22: {
                            Object var7_10;
                            block25: {
                                KeyHandler<?> keyHandler;
                                block23: {
                                    Object obj;
                                    block24: {
                                        block20: {
                                            StorageHandler storageHandler2;
                                            block21: {
                                                l = PROFILER_MAP == null ? 0L : System.nanoTime();
                                                try {
                                                    if (method != null) break block20;
                                                    storageHandler2 = this;
                                                    if (PROFILER_MAP == null || method == null) break block21;
                                                }
                                                catch (Throwable throwable) {
                                                    if (PROFILER_MAP != null && method != null) {
                                                        long l2 = System.nanoTime() - l;
                                                        String string2 = method.toString();
                                                        Long l3 = PROFILER_MAP.get(string2);
                                                        if (l3 == null) {
                                                            l3 = 0L;
                                                        }
                                                        PROFILER_MAP.put(string2, l3 + l2);
                                                    }
                                                    if (PROFILER_CALLNUM_MAP != null && method != null) {
                                                        String string3;
                                                        Long l4 = PROFILER_CALLNUM_MAP.get(string3 = method.toString());
                                                        PROFILER_CALLNUM_MAP.put(string3, l4 == null ? 1L : l4 + 1L);
                                                    }
                                                    throw throwable;
                                                }
                                                long l5 = System.nanoTime() - l;
                                                String string4 = method.toString();
                                                Long l6 = PROFILER_MAP.get(string4);
                                                if (l6 == null) {
                                                    l6 = 0L;
                                                }
                                                PROFILER_MAP.put(string4, l6 + l5);
                                            }
                                            if (PROFILER_CALLNUM_MAP != null && method != null) {
                                                String string5;
                                                Long l7 = PROFILER_CALLNUM_MAP.get(string5 = method.toString());
                                                PROFILER_CALLNUM_MAP.put(string5, l7 == null ? 1L : l7 + 1L);
                                            }
                                            return storageHandler2;
                                        }
                                        keyHandler = this.methodMap.get(method);
                                        if (keyHandler == null) break block22;
                                        if (!keyHandler.isGetter(method)) break block23;
                                        obj = keyHandler.getValue();
                                        if (PROFILER_MAP == null || method == null) break block24;
                                        long l8 = System.nanoTime() - l;
                                        String string6 = method.toString();
                                        Long l9 = PROFILER_MAP.get(string6);
                                        if (l9 == null) {
                                            l9 = 0L;
                                        }
                                        PROFILER_MAP.put(string6, l9 + l8);
                                    }
                                    if (PROFILER_CALLNUM_MAP != null && method != null) {
                                        String string7;
                                        Long l10 = PROFILER_CALLNUM_MAP.get(string7 = method.toString());
                                        PROFILER_CALLNUM_MAP.put(string7, l10 == null ? 1L : l10 + 1L);
                                    }
                                    return obj;
                                }
                                keyHandler.setValue(objectArray[0]);
                                var7_10 = null;
                                if (PROFILER_MAP == null || method == null) break block25;
                                long l11 = System.nanoTime() - l;
                                String string8 = method.toString();
                                Long l12 = PROFILER_MAP.get(string8);
                                if (l12 == null) {
                                    l12 = 0L;
                                }
                                PROFILER_MAP.put(string8, l12 + l11);
                            }
                            if (PROFILER_CALLNUM_MAP != null && method != null) {
                                String string9;
                                Long l13 = PROFILER_CALLNUM_MAP.get(string9 = method.toString());
                                PROFILER_CALLNUM_MAP.put(string9, l13 == null ? 1L : l13 + 1L);
                            }
                            return var7_10;
                        }
                        if (!method.getName().equals("toString")) break block26;
                        string = this.toString();
                        if (PROFILER_MAP == null || method == null) break block27;
                        long l14 = System.nanoTime() - l;
                        String string10 = method.toString();
                        Long l15 = PROFILER_MAP.get(string10);
                        if (l15 == null) {
                            l15 = 0L;
                        }
                        PROFILER_MAP.put(string10, l15 + l14);
                    }
                    if (PROFILER_CALLNUM_MAP != null && method != null) {
                        String string11;
                        Long l16 = PROFILER_CALLNUM_MAP.get(string11 = method.toString());
                        PROFILER_CALLNUM_MAP.put(string11, l16 == null ? 1L : l16 + 1L);
                    }
                    return string;
                }
                if (!method.getName().equals("getStorageHandler")) break block28;
                storageHandler = this;
                if (PROFILER_MAP == null || method == null) break block29;
                long l17 = System.nanoTime() - l;
                String string = method.toString();
                Long l18 = PROFILER_MAP.get(string);
                if (l18 == null) {
                    l18 = 0L;
                }
                PROFILER_MAP.put(string, l18 + l17);
            }
            if (PROFILER_CALLNUM_MAP != null && method != null) {
                String string;
                Long l = PROFILER_CALLNUM_MAP.get(string = method.toString());
                PROFILER_CALLNUM_MAP.put(string, l == null ? 1L : l + 1L);
            }
            return storageHandler;
        }
        throw new WTFException(method + " ??? no keyhandler. This is not possible!");
    }

    public boolean isCrypted() {
        return this.crypted;
    }

    private void parseInterface() throws Throwable {
        this.methodMap = new HashMap();
        this.keyHandlerMap = new HashMap();
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        HashMap hashMap3 = new HashMap();
        GenericDeclaration genericDeclaration = this.configInterface;
        while (genericDeclaration != null && genericDeclaration != ConfigInterface.class) {
            for (Method method : genericDeclaration.getDeclaredMethods()) {
                KeyHandler<?> keyHandler;
                boolean bl;
                Object object;
                String string;
                if (method.getName().startsWith("get")) {
                    block26: {
                        string = method.getName().substring(3).toLowerCase(Locale.ENGLISH);
                        if (hashMap.containsKey(string)) {
                            throw new InterfaceParseException("Key " + string + " Dupe found! " + hashMap.containsKey(string) + "<-->" + method);
                        }
                        if (method.getParameterTypes().length > 0) {
                            throw new InterfaceParseException("Getter " + method + " has parameters.");
                        }
                        try {
                            JSonStorage.canStore(method.getGenericReturnType());
                        }
                        catch (InvalidTypeException invalidTypeException) {
                            object = method.getAnnotation(AllowStorage.class);
                            bl = false;
                            if (object != null) {
                                for (Class<?> clazz : object.value()) {
                                    if (invalidTypeException.getType() != clazz) continue;
                                    bl = true;
                                    break;
                                }
                            }
                            if (bl) break block26;
                            throw new InterfaceParseException(invalidTypeException);
                        }
                    }
                    keyHandler = (KeyHandler<?>)hashMap3.get(string);
                    if (keyHandler == null) {
                        keyHandler = this.createKeyHandler(string, method.getGenericReturnType());
                        hashMap3.put(string, keyHandler);
                    }
                    object = new MethodHandler(this, MethodHandler.Type.GETTER, string, method);
                    keyHandler.setGetter((MethodHandler)object);
                    this.methodMap.put(method, keyHandler);
                    this.keyHandlerMap.put(string, keyHandler);
                    continue;
                }
                if (method.getName().startsWith("is")) {
                    string = method.getName().substring(2).toLowerCase(Locale.ENGLISH);
                    if (hashMap.containsKey(string)) {
                        throw new InterfaceParseException("Key " + string + " Dupe found! " + hashMap.containsKey(string) + "<-->" + method);
                    }
                    if (method.getParameterTypes().length > 0) {
                        throw new InterfaceParseException("Getter " + method + " has parameters.");
                    }
                    try {
                        JSonStorage.canStore(method.getGenericReturnType());
                    }
                    catch (InvalidTypeException invalidTypeException) {
                        throw new InterfaceParseException(invalidTypeException);
                    }
                    keyHandler = (KeyHandler)hashMap3.get(string);
                    if (keyHandler == null) {
                        keyHandler = this.createKeyHandler(string, method.getGenericReturnType());
                        hashMap3.put(string, keyHandler);
                    }
                    object = new MethodHandler(this, MethodHandler.Type.GETTER, string, method);
                    keyHandler.setGetter((MethodHandler)object);
                    this.keyHandlerMap.put(string, keyHandler);
                    this.methodMap.put(method, keyHandler);
                    continue;
                }
                if (method.getName().startsWith("set")) {
                    block27: {
                        string = method.getName().substring(3).toLowerCase(Locale.ENGLISH);
                        if (hashMap2.containsKey(string)) {
                            throw new InterfaceParseException("Key " + string + " Dupe found! " + hashMap2.containsKey(string) + "<-->" + method);
                        }
                        if (method.getParameterTypes().length != 1) {
                            throw new InterfaceParseException("Setter " + method + " has !=1 parameters.");
                        }
                        if (method.getReturnType() != Void.TYPE) {
                            throw new InterfaceParseException("Setter " + method + " has a returntype != void");
                        }
                        try {
                            JSonStorage.canStore(method.getGenericParameterTypes()[0]);
                        }
                        catch (InvalidTypeException invalidTypeException) {
                            object = method.getAnnotation(AllowStorage.class);
                            bl = false;
                            if (object != null) {
                                for (Class<?> clazz : object.value()) {
                                    if (invalidTypeException.getType() != clazz) continue;
                                    bl = true;
                                    break;
                                }
                            }
                            if (bl) break block27;
                            throw new InterfaceParseException(invalidTypeException);
                        }
                    }
                    keyHandler = (KeyHandler<?>)hashMap3.get(string);
                    if (keyHandler == null) {
                        keyHandler = this.createKeyHandler(string, method.getGenericParameterTypes()[0]);
                        hashMap3.put(string, keyHandler);
                    }
                    object = new MethodHandler(this, MethodHandler.Type.SETTER, string, method);
                    keyHandler.setSetter((MethodHandler)object);
                    this.keyHandlerMap.put(string, keyHandler);
                    this.methodMap.put(method, keyHandler);
                    continue;
                }
                throw new InterfaceParseException("Only getter and setter allowed:" + method);
            }
            GenericDeclaration[] genericDeclarationArray = genericDeclaration.getInterfaces();
            genericDeclaration = genericDeclarationArray[0];
        }
        for (KeyHandler keyHandler : this.methodMap.values()) {
            keyHandler.init();
        }
    }

    protected void putPrimitive(String string, Boolean bl) {
        this.primitiveStorage.put(string, bl);
    }

    protected void putPrimitive(String string, Byte by) {
        this.primitiveStorage.put(string, by);
    }

    protected void putPrimitive(String string, Double d) {
        this.primitiveStorage.put(string, d);
    }

    protected void putPrimitive(String string, Enum<?> enum_) {
        this.primitiveStorage.put(string, enum_);
    }

    protected void putPrimitive(String string, Float f) {
        this.primitiveStorage.put(string, f);
    }

    protected void putPrimitive(String string, Integer n) {
        this.primitiveStorage.put(string, n);
    }

    protected void putPrimitive(String string, Long l) {
        this.primitiveStorage.put(string, l);
    }

    protected void putPrimitive(String string, String string2) {
        this.primitiveStorage.put(string, string2);
    }

    public String toString() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (KeyHandler<?> keyHandler : this.methodMap.values()) {
            try {
                hashMap.put(keyHandler.getGetter().getKey(), this.invoke(null, keyHandler.getGetter().getMethod(), new Object[0]));
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                hashMap.put(keyHandler.getKey(), throwable.getMessage());
            }
        }
        return JSonStorage.toString(hashMap);
    }
}

