/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.simplejson;

import org.appwork.storage.simplejson.JSonArray;
import org.appwork.storage.simplejson.JSonNode;
import org.appwork.storage.simplejson.JSonObject;
import org.appwork.storage.simplejson.JSonValue;
import org.appwork.storage.simplejson.NoNumberException;
import org.appwork.storage.simplejson.ParserException;

public class JSonFactory {
    public static boolean DEBUG = false;
    private int global = 0;
    private char c;
    private final String str;
    final StringBuilder sb;
    private final StringBuilder sb2;
    private int counter;
    private String debug;

    public JSonFactory(String string) {
        this.str = string;
        this.sb = new StringBuilder();
        this.sb2 = new StringBuilder();
        this.counter = 0;
    }

    private ParserException bam(String string) {
        String string2 = this.str.substring(Math.max(this.global - 20, 0), this.global);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        stringBuilder.append("\r\n\t");
        stringBuilder.append(string2);
        stringBuilder.append(this.str.substring(this.global, Math.min(this.str.length(), this.global + 20)));
        stringBuilder.append("\r\n\t");
        for (int i = 1; i < string2.length(); ++i) {
            stringBuilder.append("-");
        }
        stringBuilder.append('\u2934');
        return new ParserException(stringBuilder.toString());
    }

    private String findString() throws ParserException {
        try {
            this.sb.delete(0, this.sb.length());
            this.c = this.str.charAt(this.global++);
            if (this.c != '\"') {
                throw this.bam("'\"' expected");
            }
            boolean bl = false;
            block15: while (true) {
                this.c = this.str.charAt(this.global++);
                switch (this.c) {
                    case '\"': {
                        return this.sb.toString();
                    }
                    case '\\': {
                        bl = true;
                        while ((this.c = this.str.charAt(this.global++)) == '\\') {
                            if (bl = !bl) continue;
                            this.sb.append("\\");
                        }
                        if (bl) {
                            switch (this.c) {
                                case '\"': {
                                    this.sb.append('\"');
                                    continue block15;
                                }
                                case 'r': {
                                    this.sb.append('\r');
                                    continue block15;
                                }
                                case 'n': {
                                    this.sb.append('\n');
                                    continue block15;
                                }
                                case 't': {
                                    this.sb.append('\t');
                                    continue block15;
                                }
                                case 'f': {
                                    this.sb.append('\f');
                                    continue block15;
                                }
                                case 'b': {
                                    this.sb.append('\b');
                                    continue block15;
                                }
                                case 'u': {
                                    this.sb2.delete(0, this.sb2.length());
                                    ++this.global;
                                    this.counter = this.global + 4;
                                    while (this.global < this.counter) {
                                        this.c = this.getChar();
                                        if (this.sb2.length() > 0 || this.c != '0') {
                                            this.sb2.append(this.c);
                                        }
                                        ++this.global;
                                    }
                                    --this.global;
                                    this.sb.append((char)Short.parseShort(this.sb2.toString(), 16));
                                    continue block15;
                                }
                            }
                            throw this.bam("illegal escape char");
                        }
                        --this.global;
                        continue block15;
                    }
                }
                this.sb.append(this.c);
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            --this.global;
            throw this.bam("Unexpected End of String \"" + this.sb.toString());
        }
    }

    private char getChar() {
        if (DEBUG) {
            String string = this.str.substring(0, this.global);
            this.debug = string + this.str.substring(this.global) + "\r\n";
            for (int i = 0; i < string.length(); ++i) {
                this.debug = this.debug + "-";
            }
            this.debug = this.debug + '\u2934';
            System.err.println(this.debug);
        }
        return this.str.charAt(this.global);
    }

    public JSonNode parse() throws ParserException {
        JSonNode jSonNode = this.parseValue();
        this.skipWhiteSpace();
        if (this.global != this.str.length()) {
            ++this.global;
            throw this.bam("Unexpected End of JSonString");
        }
        return jSonNode;
    }

    private JSonArray parseArray() throws ParserException {
        ++this.global;
        JSonArray jSonArray = new JSonArray();
        block8: while (true) {
            this.skipWhiteSpace();
            this.c = this.getChar();
            switch (this.c) {
                case ']': {
                    ++this.global;
                    return jSonArray;
                }
                case ',': {
                    throw this.bam("Value missing");
                }
            }
            jSonArray.add(this.parseValue());
            this.skipWhiteSpace();
            this.c = this.getChar();
            switch (this.c) {
                case ',': {
                    ++this.global;
                    continue block8;
                }
                case ']': {
                    ++this.global;
                    return jSonArray;
                }
            }
            break;
        }
        throw this.bam("']' or ',' expected");
    }

    private JSonValue parseNumber() throws ParserException, NoNumberException {
        this.sb.delete(0, this.sb.length());
        boolean bl = false;
        boolean bl2 = false;
        this.c = this.getChar();
        if (this.c == '+' || this.c == '-' || Character.isDigit(this.c)) {
            this.sb.append(this.c);
            while (this.global + 1 < this.str.length()) {
                ++this.global;
                this.c = this.getChar();
                if (Character.isDigit(this.c) || !bl && this.c == '.' || bl && this.c == 'e' || bl && this.c == 'E' || bl2 && this.c == '+' || bl2 && this.c == '-') {
                    if (this.c == '.') {
                        bl = true;
                    } else if (bl && (this.c == 'e' || this.c == 'E')) {
                        bl2 = true;
                    }
                    this.sb.append(this.c);
                    continue;
                }
                --this.global;
                break;
            }
            ++this.global;
            if (bl) {
                return new JSonValue(Double.parseDouble(this.sb.toString()));
            }
            return new JSonValue(Long.parseLong(this.sb.toString()));
        }
        throw new NoNumberException();
    }

    private JSonObject parseObject() throws ParserException {
        ++this.global;
        JSonObject jSonObject = new JSonObject();
        block8: while (true) {
            this.skipWhiteSpace();
            this.c = this.getChar();
            switch (this.c) {
                case '}': {
                    ++this.global;
                    return jSonObject;
                }
                case '\"': {
                    String string = this.findString();
                    this.skipWhiteSpace();
                    this.c = this.getChar();
                    if (this.c != ':') {
                        throw this.bam("':' expected");
                    }
                    ++this.global;
                    this.skipWhiteSpace();
                    jSonObject.put(string, this.parseValue());
                    this.skipWhiteSpace();
                    this.c = this.getChar();
                    switch (this.c) {
                        case ',': {
                            ++this.global;
                            continue block8;
                        }
                        case '}': {
                            ++this.global;
                            return jSonObject;
                        }
                    }
                    throw this.bam("', or }' expected");
                }
            }
            break;
        }
        throw this.bam("\", or }' expected");
    }

    private JSonValue parseString() throws ParserException {
        return new JSonValue(this.findString());
    }

    private JSonNode parseValue() throws ParserException {
        this.global = this.skipWhiteSpace();
        switch (this.getChar()) {
            case '{': {
                return this.parseObject();
            }
            case '[': {
                return this.parseArray();
            }
            case 'n': {
                this.global += 4;
                return new JSonValue(null);
            }
            case 't': {
                this.global += 4;
                return new JSonValue(true);
            }
            case 'f': {
                this.global += 5;
                return new JSonValue(false);
            }
            case '\"': {
                return this.parseString();
            }
        }
        try {
            return this.parseNumber();
        }
        catch (NoNumberException noNumberException) {
            ++this.global;
            throw this.bam("Illegal Char");
        }
    }

    private int skipWhiteSpace() {
        while (this.global < this.str.length()) {
            if (Character.isWhitespace(this.str.charAt(this.global++))) continue;
            --this.global;
            break;
        }
        return this.global;
    }
}

