/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.simplejson;

import org.appwork.storage.simplejson.JSonNode;
import org.appwork.storage.simplejson.JSonUtils;
import org.appwork.storage.simplejson.Type;

public class JSonValue
implements JSonNode {
    private final Object value;
    private final Type type;

    public JSonValue(boolean bl) {
        this.value = bl;
        this.type = Type.BOOLEAN;
    }

    public JSonValue(double d) {
        this.value = d;
        this.type = Type.DOUBLE;
    }

    public JSonValue(long l) {
        this.value = l;
        this.type = Type.LONG;
    }

    public JSonValue(String string) {
        if (string == null) {
            this.value = null;
            this.type = Type.NULL;
        } else {
            this.value = string;
            this.type = Type.STRING;
        }
    }

    public Type getType() {
        return this.type;
    }

    public Object getValue() {
        return this.value;
    }

    public String toString() {
        switch (this.type) {
            case BOOLEAN: 
            case DOUBLE: 
            case LONG: {
                return this.value.toString();
            }
            case STRING: {
                return "\"" + JSonUtils.escape(this.value.toString()) + "\"";
            }
            case NULL: {
                return "null";
            }
        }
        return null;
    }
}

