/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.simplejson.mapper;

import java.io.File;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.appwork.storage.TypeRef;
import org.appwork.storage.simplejson.JSonArray;
import org.appwork.storage.simplejson.JSonNode;
import org.appwork.storage.simplejson.JSonObject;
import org.appwork.storage.simplejson.JSonValue;
import org.appwork.storage.simplejson.mapper.ClassCache;
import org.appwork.storage.simplejson.mapper.ClassMapper;
import org.appwork.storage.simplejson.mapper.DateMapper;
import org.appwork.storage.simplejson.mapper.FileMapper;
import org.appwork.storage.simplejson.mapper.Getter;
import org.appwork.storage.simplejson.mapper.MapperException;
import org.appwork.storage.simplejson.mapper.Setter;
import org.appwork.storage.simplejson.mapper.TypeMapper;
import org.appwork.storage.simplejson.mapper.URLMapper;
import sun.reflect.generics.reflectiveObjects.ParameterizedTypeImpl;

public class JSonMapper {
    private boolean ignorePrimitiveNullMapping = false;
    private boolean ignoreIllegalArgumentMappings = false;
    private boolean ignoreIllegalEnumMappings = false;
    private HashMap<Class<?>, TypeMapper<?>> typeMapper = new HashMap();

    public static Object cast(Object object, Class<?> clazz) {
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                object = (boolean)((Boolean)object);
            } else if (clazz == Character.TYPE) {
                object = Character.valueOf((char)((Long)object).byteValue());
            } else if (clazz == Byte.TYPE) {
                object = ((Long)object).byteValue();
            } else if (clazz == Short.TYPE) {
                object = ((Long)object).shortValue();
            } else if (clazz == Integer.TYPE) {
                object = ((Long)object).intValue();
            } else if (clazz == Long.TYPE) {
                object = (long)((Long)object);
            } else if (clazz == Float.TYPE) {
                object = Float.valueOf(((Double)object).floatValue());
            } else if (clazz == Double.TYPE) {
                object = (double)((Double)object);
            }
        } else if (clazz == Boolean.class) {
            object = (boolean)((Boolean)object);
        } else if (clazz == Character.class) {
            object = Character.valueOf((char)((Long)object).byteValue());
        } else if (clazz == Byte.class) {
            object = ((Long)object).byteValue();
        } else if (clazz == Short.class) {
            object = ((Long)object).shortValue();
        } else if (clazz == Integer.class) {
            object = ((Long)object).intValue();
        } else if (clazz == Long.class) {
            object = (long)((Long)object);
        } else if (clazz == Float.class) {
            object = Float.valueOf(((Double)object).floatValue());
        } else if (clazz == Double.class) {
            object = (double)((Double)object);
        }
        return object;
    }

    public JSonMapper() {
        this.addMapper(File.class, new FileMapper());
        this.addMapper(Class.class, new ClassMapper());
        this.addMapper(URL.class, new URLMapper());
        this.addMapper(Date.class, new DateMapper());
    }

    public <T> void addMapper(Class<T> clazz, TypeMapper<T> typeMapper) {
        this.typeMapper.put(clazz, typeMapper);
    }

    public JSonNode create(Object object) throws MapperException {
        block36: {
            try {
                if (object == null) {
                    return new JSonValue(null);
                }
                Class<?> clazz = object.getClass();
                if (clazz.isPrimitive()) {
                    if (clazz == Boolean.TYPE) {
                        return new JSonValue((Boolean)object);
                    }
                    if (clazz == Character.TYPE) {
                        return new JSonValue('\u0000' + ((Character)object).charValue());
                    }
                    if (clazz == Byte.TYPE) {
                        return new JSonValue(((Byte)object).longValue());
                    }
                    if (clazz == Short.TYPE) {
                        return new JSonValue(((Short)object).longValue());
                    }
                    if (clazz == Integer.TYPE) {
                        return new JSonValue(((Integer)object).longValue());
                    }
                    if (clazz == Long.TYPE) {
                        return new JSonValue((Long)object);
                    }
                    if (clazz == Float.TYPE) {
                        return new JSonValue(((Float)object).doubleValue());
                    }
                    if (clazz == Double.TYPE) {
                        return new JSonValue((Double)object);
                    }
                    break block36;
                }
                if (clazz.isEnum()) {
                    return new JSonValue(object + "");
                }
                if (object instanceof Boolean) {
                    return new JSonValue((Boolean)object);
                }
                if (object instanceof Character) {
                    return new JSonValue('\u0000' + ((Character)object).charValue());
                }
                if (object instanceof Byte) {
                    return new JSonValue(((Byte)object).longValue());
                }
                if (object instanceof Short) {
                    return new JSonValue(((Short)object).longValue());
                }
                if (object instanceof Integer) {
                    return new JSonValue(((Integer)object).longValue());
                }
                if (object instanceof Long) {
                    return new JSonValue((Long)object);
                }
                if (object instanceof Float) {
                    return new JSonValue(((Float)object).doubleValue());
                }
                if (object instanceof Double) {
                    return new JSonValue((Double)object);
                }
                if (object instanceof String) {
                    return new JSonValue((String)object);
                }
                if (object instanceof Map) {
                    JSonObject jSonObject = new JSonObject();
                    for (Map.Entry entry : ((Map)object).entrySet()) {
                        if (!(entry.getKey() instanceof String)) {
                            throw new MapperException("Map keys have to be Strings: " + clazz);
                        }
                        jSonObject.put(entry.getKey().toString(), this.create(entry.getValue()));
                    }
                    return jSonObject;
                }
                if (object instanceof List) {
                    JSonArray jSonArray = new JSonArray();
                    for (Object e : (List)object) {
                        jSonArray.add(this.create(e));
                    }
                    return jSonArray;
                }
                if (clazz.isArray()) {
                    JSonArray jSonArray = new JSonArray();
                    for (int i = 0; i < Array.getLength(object); ++i) {
                        jSonArray.add(this.create(Array.get(object, i)));
                    }
                    return jSonArray;
                }
                if (object instanceof Class) {
                    return new JSonValue(((Class)object).getName());
                }
                TypeMapper<?> typeMapper = this.typeMapper.get(clazz);
                if (typeMapper != null) {
                    return typeMapper.map(object);
                }
                ClassCache classCache = ClassCache.getClassCache(clazz);
                JSonObject jSonObject = new JSonObject();
                for (Getter getter : classCache.getGetter()) {
                    jSonObject.put(getter.getKey(), this.create(getter.getValue(object)));
                }
                return jSonObject;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
            catch (SecurityException securityException) {
                securityException.printStackTrace();
            }
            catch (NoSuchMethodException noSuchMethodException) {
                noSuchMethodException.printStackTrace();
            }
        }
        return null;
    }

    public boolean isIgnoreIllegalArgumentMappings() {
        return this.ignoreIllegalArgumentMappings;
    }

    public boolean isIgnoreIllegalEnumMappings() {
        return this.ignoreIllegalEnumMappings;
    }

    public boolean isIgnorePrimitiveNullMapping() {
        return this.ignorePrimitiveNullMapping;
    }

    public Object jsonToObject(JSonNode jSonNode, Type type) {
        try {
            Type type2 = null;
            if (type instanceof ParameterizedTypeImpl) {
                type2 = ((ParameterizedTypeImpl)type).getRawType();
            } else if (type instanceof Class) {
                type2 = (Class)type;
            }
            TypeMapper<?> typeMapper = this.typeMapper.get(type2);
            if (typeMapper != null) {
                return typeMapper.reverseMap(jSonNode);
            }
            if (jSonNode instanceof JSonValue) {
                switch (((JSonValue)jSonNode).getType()) {
                    case BOOLEAN: 
                    case DOUBLE: 
                    case LONG: {
                        if (type instanceof Class) {
                            return JSonMapper.cast(((JSonValue)jSonNode).getValue(), (Class)type);
                        }
                        return ((JSonValue)jSonNode).getValue();
                    }
                    case STRING: {
                        if (type instanceof Class && ((Class)type).isEnum()) {
                            try {
                                return Enum.valueOf((Class)type, ((JSonValue)jSonNode).getValue() + "");
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                if (this.isIgnoreIllegalArgumentMappings() || this.isIgnoreIllegalEnumMappings()) {
                                    return null;
                                }
                                throw illegalArgumentException;
                            }
                        }
                        return ((JSonValue)jSonNode).getValue();
                    }
                    case NULL: {
                        return null;
                    }
                }
            }
            if (type instanceof Class) {
                type2 = (Class)type;
                if (List.class.isAssignableFrom((Class<?>)type2)) {
                    List list = (List)((Class)type2).newInstance();
                    JSonArray jSonArray = (JSonArray)jSonNode;
                    Type type3 = ((Class)type2).getGenericSuperclass();
                    Type type4 = type3 instanceof ParameterizedTypeImpl ? ((ParameterizedTypeImpl)type3).getActualTypeArguments()[0] : Void.TYPE;
                    for (JSonNode jSonNode2 : jSonArray) {
                        list.add(this.jsonToObject(jSonNode2, type4));
                    }
                    return list;
                }
                if (Map.class.isAssignableFrom((Class<?>)type2)) {
                    Map map = (Map)((Class)type2).newInstance();
                    JSonObject jSonObject = (JSonObject)jSonNode;
                    Type type5 = ((Class)type2).getGenericSuperclass();
                    Type type6 = type5 instanceof ParameterizedTypeImpl ? ((ParameterizedTypeImpl)type5).getActualTypeArguments()[1] : Void.TYPE;
                    for (Map.Entry entry : jSonObject.entrySet()) {
                        map.put(entry.getKey(), this.jsonToObject((JSonNode)entry.getValue(), type6));
                    }
                    return map;
                }
                if (((Class)type2).isArray()) {
                    JSonArray jSonArray = (JSonArray)jSonNode;
                    Object object = Array.newInstance(((Class)type2).getComponentType(), jSonArray.size());
                    for (int i = 0; i < jSonArray.size(); ++i) {
                        Object object2 = this.jsonToObject((JSonNode)jSonArray.get(i), ((Class)type2).getComponentType());
                        Array.set(object, i, object2);
                    }
                    return object;
                }
                if (jSonNode instanceof JSonArray) {
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    JSonArray jSonArray = (JSonArray)jSonNode;
                    Type type7 = ((Class)type2).getGenericSuperclass();
                    Type type8 = type7 instanceof ParameterizedTypeImpl ? ((ParameterizedTypeImpl)type7).getActualTypeArguments()[0] : Void.TYPE;
                    for (JSonNode jSonNode3 : jSonArray) {
                        arrayList.add(this.jsonToObject(jSonNode3, type8));
                    }
                    return arrayList;
                }
                JSonObject jSonObject = (JSonObject)jSonNode;
                ClassCache classCache = ClassCache.getClassCache((Class<? extends Object>)type2);
                Object object = classCache.getInstance();
                for (Setter setter : classCache.getSetter()) {
                    JSonNode jSonNode4 = (JSonNode)jSonObject.get(setter.getKey());
                    if (jSonNode4 == null) continue;
                    Object object3 = this.jsonToObject(jSonNode4, setter.getType());
                    try {
                        setter.setValue(object, object3);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        if (this.isIgnoreIllegalArgumentMappings() || object3 == null && this.isIgnorePrimitiveNullMapping()) continue;
                        throw illegalArgumentException;
                    }
                }
                return object;
            }
            if (type instanceof ParameterizedTypeImpl) {
                ParameterizedTypeImpl parameterizedTypeImpl = (ParameterizedTypeImpl)type;
                if (List.class.isAssignableFrom((Class<?>)parameterizedTypeImpl.getRawType())) {
                    List list = (List)((Class)parameterizedTypeImpl.getRawType()).newInstance();
                    JSonArray jSonArray = (JSonArray)jSonNode;
                    for (JSonNode jSonNode5 : jSonArray) {
                        list.add(this.jsonToObject(jSonNode5, parameterizedTypeImpl.getActualTypeArguments()[0]));
                    }
                    return list;
                }
                if (Map.class.isAssignableFrom((Class<?>)parameterizedTypeImpl.getRawType())) {
                    Map map = (Map)((Class)parameterizedTypeImpl.getRawType()).newInstance();
                    JSonObject jSonObject = (JSonObject)jSonNode;
                    for (Map.Entry entry : jSonObject.entrySet()) {
                        map.put(entry.getKey(), this.jsonToObject((JSonNode)entry.getValue(), parameterizedTypeImpl.getActualTypeArguments()[1]));
                    }
                    return map;
                }
                System.err.println("TYPE?!");
            } else {
                System.err.println("TYPE?!");
            }
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        return null;
    }

    public <T> T jsonToObject(JSonNode jSonNode, TypeRef<T> typeRef) {
        return (T)this.jsonToObject(jSonNode, typeRef.getType());
    }

    public void setIgnoreIllegalArgumentMappings(boolean bl) {
        this.ignoreIllegalArgumentMappings = bl;
    }

    public void setIgnoreIllegalEnumMappings(boolean bl) {
        this.ignoreIllegalEnumMappings = bl;
    }

    public void setIgnorePrimitiveNullMapping(boolean bl) {
        this.ignorePrimitiveNullMapping = bl;
    }
}

