/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.FileNameMap;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.LinkedList;
import org.appwork.utils.os.CrossSystem;

public class Files {
    public static void deleteRecursiv(File ... fileArray) throws IOException {
        File file;
        int n;
        ArrayList<File> arrayList = Files.getFiles(true, true, fileArray);
        for (n = arrayList.size() - 1; n >= 0; --n) {
            file = arrayList.get(n);
            if (!file.exists() || file.isFile()) {
                arrayList.remove(n);
            }
            if (!file.exists() || !file.isFile() || file.delete()) continue;
            throw new IOException("could not delete " + file);
        }
        for (n = arrayList.size() - 1; n >= 0; --n) {
            file = arrayList.get(n);
            if (file.isDirectory()) {
                arrayList.remove(n);
            }
            if (!file.exists() || !file.isDirectory() || file.delete()) continue;
            throw new IOException("could not delete " + file);
        }
    }

    public static LinkedList<String> getDirectories_NonRecursive(File file, boolean bl) throws IOException {
        LinkedList<String> linkedList = new LinkedList<String>();
        File file2 = null;
        File[] fileArray = null;
        ArrayList<File> arrayList = new ArrayList<File>();
        arrayList.add(file);
        while (arrayList.size() > 0) {
            file2 = (File)arrayList.remove(0);
            fileArray = file2.listFiles();
            linkedList.add(file2.getCanonicalPath());
            if (fileArray == null) continue;
            for (int i = fileArray.length - 1; i >= 0; --i) {
                String string;
                if (!fileArray[i].isDirectory() || linkedList.contains(string = fileArray[i].getCanonicalPath())) continue;
                arrayList.add(fileArray[i]);
            }
        }
        if (!bl && linkedList.size() > 0) {
            linkedList.remove(0);
        }
        return linkedList;
    }

    public static File getExistingFile(File file, boolean bl) {
        File[] fileArray;
        if (file == null) {
            return null;
        }
        if (bl) {
            if (file.exists()) {
                return file;
            }
            return null;
        }
        String string = file.getName().toLowerCase();
        File file2 = file.getParentFile();
        if (file2 != null && (fileArray = file2.listFiles()) != null) {
            for (File file3 : fileArray) {
                if (!file3.getName().equalsIgnoreCase(string)) continue;
                return file3;
            }
        }
        return null;
    }

    public static String getExtension(String string) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(".");
        if (n < 0) {
            return null;
        }
        return string.substring(n + 1).toLowerCase();
    }

    public static ArrayList<File> getFiles(final boolean bl, final boolean bl2, File ... fileArray) {
        return Files.getFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (bl && file.isDirectory()) {
                    return true;
                }
                return bl2 && file.isFile();
            }
        }, fileArray);
    }

    public static String getMimeType(String string) {
        if (string == null) {
            return null;
        }
        FileNameMap fileNameMap = URLConnection.getFileNameMap();
        String string2 = fileNameMap.getContentTypeFor(string);
        if (string2 == null) {
            string2 = "unknown/" + Files.getExtension(string);
        }
        return string2;
    }

    public static String getRelativePath(File file, File file2) {
        String string;
        String string2;
        if (CrossSystem.isWindows()) {
            string2 = file.getAbsolutePath().toLowerCase();
            string = file2.getAbsolutePath().toLowerCase();
        } else {
            string2 = file.getAbsolutePath();
            string = file2.getAbsolutePath();
        }
        if (!string.startsWith(string2)) {
            return null;
        }
        if (string2.equals(string)) {
            return "/";
        }
        return file2.getAbsolutePath().substring(string2.length() + 1);
    }

    public static void main(String[] stringArray) {
        System.out.println(Files.getRelativePath(new File("C:/Test/"), new File("c:/test/eins/zwei/drei.vier")));
    }

    public static ArrayList<File> getFiles(FileFilter fileFilter, File ... fileArray) {
        ArrayList<File> arrayList = new ArrayList<File>();
        if (fileArray != null) {
            for (File file : fileArray) {
                if (!file.exists()) continue;
                if (fileFilter == null || fileFilter.accept(file)) {
                    arrayList.add(file);
                }
                if (!file.isDirectory()) continue;
                arrayList.addAll(Files.getFiles(fileFilter, file.listFiles()));
            }
        }
        return arrayList;
    }

    public static String getFileNameWithoutExtension(String string) {
        int n = string.lastIndexOf(".");
        if (n < 0) {
            return string;
        }
        return string.substring(0, n);
    }
}

