/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.logging;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.appwork.utils.Application;
import org.appwork.utils.logging.Log;

public class LogToFileHandler
extends Handler {
    private File file;
    private BufferedWriter writer;
    private OutputStreamWriter osw = null;
    private FileOutputStream fos = null;

    public LogToFileHandler() throws IOException {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(new Date().getTime());
        this.file = Application.getResource("logs/" + calendar.get(1) + "-" + (1 + calendar.get(2)) + "-" + calendar.get(5) + ".log");
        this.file.getParentFile().mkdirs();
        this.file.deleteOnExit();
        if (!this.file.isFile()) {
            this.file.createNewFile();
        }
        try {
            this.fos = new FileOutputStream(this.file, true);
            this.osw = new OutputStreamWriter((OutputStream)this.fos, "UTF8");
            this.writer = new BufferedWriter(this.osw);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            this.close();
        }
    }

    @Override
    public void close() {
        try {
            this.writer.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.osw.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.fos.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void flush() {
        try {
            this.writer.flush();
        }
        catch (IOException iOException) {
            Log.exception(iOException);
        }
    }

    @Override
    public void publish(LogRecord logRecord) {
        if (logRecord.getLevel() == Level.INFO) {
            try {
                this.writer.write(this.getFormatter().format(logRecord));
            }
            catch (IOException iOException) {
                if (iOException.getMessage().contains("not enough")) {
                    Log.L.severe("Cannot write log, Disk is full!");
                }
                Log.exception(iOException);
            }
        }
    }
}

