/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net.httpconnection;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.List;
import java.util.Map;

public interface HTTPConnection {
    public void connect() throws IOException;

    public void disconnect();

    public void finalizeConnect() throws IOException;

    public int[] getAllowedResponseCodes();

    public String getCharset();

    public long getCompleteContentLength();

    public long getContentLength();

    public String getContentType();

    public String getHeaderField(String var1);

    public Map<String, List<String>> getHeaderFields();

    public List<String> getHeaderFields(String var1);

    public InputStream getInputStream() throws IOException;

    public OutputStream getOutputStream() throws IOException;

    public long[] getRange();

    public RequestMethod getRequestMethod();

    public Map<String, String> getRequestProperties();

    public String getRequestProperty(String var1);

    public long getRequestTime();

    public int getResponseCode();

    public String getResponseMessage();

    public URL getURL();

    public boolean isConnected();

    public boolean isContentDecoded();

    public boolean isContentDisposition();

    public boolean isOK();

    public void setAllowedResponseCodes(int[] var1);

    public void setCharset(String var1);

    public void setConnectTimeout(int var1);

    public void setContentDecoded(boolean var1);

    public void setReadTimeout(int var1);

    public void setRequestMethod(RequestMethod var1);

    public void setRequestProperty(String var1, String var2);

    public static enum RequestMethod {
        GET,
        POST,
        HEAD;

    }
}

