/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net.httpconnection;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.DeflaterInputStream;
import java.util.zip.GZIPInputStream;
import org.appwork.utils.LowerCaseHashMap;
import org.appwork.utils.Regex;
import org.appwork.utils.net.Base64InputStream;
import org.appwork.utils.net.ChunkedInputStream;
import org.appwork.utils.net.CountingOutputStream;
import org.appwork.utils.net.httpconnection.HTTPConnection;
import org.appwork.utils.net.httpconnection.HTTPConnectionUtils;
import org.appwork.utils.net.httpconnection.HTTPProxy;
import org.appwork.utils.net.httpconnection.ProxyConnectException;
import org.appwork.utils.net.httpconnection.TrustALLSSLFactory;

public class HTTPConnectionImpl
implements HTTPConnection {
    protected LinkedHashMap<String, String> requestProperties = null;
    protected long[] ranges;
    protected String customcharset = null;
    protected Socket httpSocket = null;
    protected URL httpURL = null;
    protected HTTPProxy proxy = null;
    protected String httpPath = null;
    protected HTTPConnection.RequestMethod httpMethod = HTTPConnection.RequestMethod.GET;
    protected LowerCaseHashMap<List<String>> headers = null;
    protected int httpResponseCode = -1;
    protected String httpResponseMessage = "";
    protected int readTimeout = 30000;
    protected int connectTimeout = 30000;
    protected long requestTime = -1L;
    protected OutputStream outputStream = null;
    protected InputStream inputStream = null;
    protected InputStream convertedInputStream = null;
    protected boolean inputStreamConnected = false;
    protected String httpHeader = null;
    protected boolean outputClosed = false;
    private boolean contentDecoded = true;
    protected long postTodoLength = -1L;
    private int[] allowedResponseCodes = new int[0];
    private InetSocketAddress proxyInetSocketAddress = null;
    protected InetSocketAddress connectedInetSocketAddress = null;

    public HTTPConnectionImpl(URL uRL) {
        this(uRL, null);
    }

    public HTTPConnectionImpl(URL uRL, HTTPProxy hTTPProxy) {
        this.httpURL = uRL;
        this.proxy = hTTPProxy;
        this.requestProperties = new LinkedHashMap();
        this.headers = new LowerCaseHashMap();
    }

    protected void addHostHeader() {
        int n = this.httpURL.getDefaultPort();
        int n2 = this.httpURL.getPort();
        String string = "";
        if (n2 != -1 && n != -1 && n2 != n) {
            string = ":" + n2;
        }
        this.requestProperties.put("Host", this.httpURL.getHost() + string);
    }

    @Override
    public void connect() throws IOException {
        if (this.isConnected()) {
            return;
        }
        InetAddress[] inetAddressArray = null;
        inetAddressArray = InetAddress.getAllByName(this.httpURL.getHost());
        IOException iOException = null;
        for (InetAddress inetAddress : inetAddressArray) {
            this.httpSocket = this.httpURL.getProtocol().startsWith("https") ? TrustALLSSLFactory.getSSLFactoryTrustALL().createSocket() : new Socket();
            this.httpSocket.setSoTimeout(this.readTimeout);
            this.httpResponseCode = -1;
            int n = this.httpURL.getPort();
            if (n == -1) {
                n = this.httpURL.getDefaultPort();
            }
            long l = System.currentTimeMillis();
            if (this.proxy != null && this.proxy.isDirect()) {
                try {
                    if (this.proxy.getLocalIP() == null) {
                        throw new IOException("Invalid localIP");
                    }
                    this.proxyInetSocketAddress = new InetSocketAddress(this.proxy.getLocalIP(), 0);
                    this.httpSocket.bind(this.proxyInetSocketAddress);
                }
                catch (IOException iOException2) {
                    this.proxyInetSocketAddress = null;
                    throw new ProxyConnectException(iOException2, this.proxy);
                }
            } else if (!(this.proxy != null && this.proxy.isNone() || this.proxy == null)) {
                throw new RuntimeException("Invalid Direct Proxy");
            }
            try {
                this.connectedInetSocketAddress = new InetSocketAddress(inetAddress, n);
                this.httpSocket.connect(this.connectedInetSocketAddress, this.connectTimeout);
                this.requestTime = System.currentTimeMillis() - l;
                iOException = null;
                break;
            }
            catch (IOException iOException3) {
                this.connectedInetSocketAddress = null;
                try {
                    this.httpSocket.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                iOException = iOException3;
            }
        }
        if (iOException != null) {
            throw iOException;
        }
        this.httpPath = new Regex(this.httpURL.toString(), "https?://.*?(/.+)").getMatch(0);
        if (this.httpPath == null) {
            this.httpPath = "/";
        }
        this.sendRequest();
    }

    protected synchronized void connectInputStream() throws IOException {
        String string;
        long l;
        if (this.httpMethod == HTTPConnection.RequestMethod.POST && (l = ((CountingOutputStream)this.outputStream).transferedBytes()) != this.postTodoLength) {
            throw new IOException("Content-Length" + this.postTodoLength + " does not match send " + l + " bytes");
        }
        if (this.inputStreamConnected) {
            return;
        }
        if (this.httpMethod == HTTPConnection.RequestMethod.POST) {
            this.outputStream.flush();
        }
        this.inputStreamConnected = true;
        ByteBuffer byteBuffer = HTTPConnectionUtils.readheader(this.httpSocket.getInputStream(), true);
        byte[] byArray = new byte[byteBuffer.limit()];
        byteBuffer.get(byArray);
        this.httpHeader = new String(byArray, "ISO-8859-1").trim();
        if (this.httpHeader.startsWith("HTTP")) {
            string = new Regex(this.httpHeader, "HTTP.*? (\\d+)").getMatch(0);
            if (string != null) {
                this.httpResponseCode = Integer.parseInt(string);
            }
            this.httpResponseMessage = new Regex(this.httpHeader, "HTTP.*? \\d+ (.+)").getMatch(0);
            if (this.httpResponseMessage == null) {
                this.httpResponseMessage = "";
            }
        } else {
            this.httpHeader = "unknown HTTP response";
            this.httpResponseCode = 200;
            this.httpResponseMessage = "unknown HTTP response";
            if (byArray.length > 0) {
                this.inputStream = new PushbackInputStream(this.httpSocket.getInputStream(), byArray.length);
                ((PushbackInputStream)this.inputStream).unread(byArray);
            } else {
                this.inputStream = this.httpSocket.getInputStream();
            }
            return;
        }
        byteBuffer = HTTPConnectionUtils.readheader(this.httpSocket.getInputStream(), false);
        byArray = new byte[byteBuffer.limit()];
        byteBuffer.get(byArray);
        string = new String(byArray, "UTF-8");
        String[] stringArray = string.split("(\r\n)|(\n)");
        string = null;
        for (String string2 : stringArray) {
            String string3 = null;
            String string4 = null;
            int n = 0;
            n = string2.indexOf(": ");
            if (n > 0) {
                string3 = string2.substring(0, n);
                string4 = string2.substring(n + 2);
            } else {
                n = string2.indexOf(":");
                if (n > 0) {
                    string3 = string2.substring(0, n);
                    string4 = string2.substring(n + 1);
                } else {
                    string3 = null;
                    string4 = string2;
                }
            }
            List<String> list = this.headers.get(string3);
            if (list == null) {
                list = new ArrayList<String>();
                this.headers.put(string3, list);
            }
            list.add(string4);
        }
        stringArray = null;
        List<String> list = this.headers.get("Transfer-Encoding");
        this.inputStream = list != null && list.size() > 0 && "chunked".equalsIgnoreCase((String)list.get(0)) ? new ChunkedInputStream(this.httpSocket.getInputStream()) : this.httpSocket.getInputStream();
    }

    @Override
    public void disconnect() {
        if (this.isConnected()) {
            try {
                this.httpSocket.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public void finalizeConnect() throws IOException {
        this.connect();
        this.connectInputStream();
    }

    @Override
    public int[] getAllowedResponseCodes() {
        return this.allowedResponseCodes;
    }

    @Override
    public String getCharset() {
        int n;
        if (this.customcharset != null) {
            return this.customcharset;
        }
        return this.getContentType() != null && (n = this.getContentType().toLowerCase().indexOf("charset=")) > 0 ? this.getContentType().substring(n + 8).trim() : null;
    }

    @Override
    public long getCompleteContentLength() {
        this.getRange();
        if (this.ranges != null) {
            return this.ranges[2];
        }
        return this.getContentLength();
    }

    @Override
    public long getContentLength() {
        String string = this.getHeaderField("Content-Length");
        if (string != null) {
            return Long.parseLong(string);
        }
        return -1L;
    }

    @Override
    public String getContentType() {
        String string = this.getHeaderField("Content-Type");
        if (string == null) {
            return "unknown";
        }
        return string;
    }

    @Override
    public String getHeaderField(String string) {
        List<String> list = this.headers.get(string);
        if (list == null || list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    @Override
    public Map<String, List<String>> getHeaderFields() {
        return this.headers;
    }

    @Override
    public List<String> getHeaderFields(String string) {
        List<String> list = this.headers.get(string);
        if (list == null || list.size() == 0) {
            return null;
        }
        return list;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public InputStream getInputStream() throws IOException {
        this.connect();
        this.connectInputStream();
        int n = this.getResponseCode();
        if ((n < 200 || n > 400) && n != 404 && n != 403 && n != 416 && !this.isResponseCodeAllowed(n)) throw new IOException(this.getResponseCode() + " " + this.getResponseMessage());
        if (this.convertedInputStream != null) {
            return this.convertedInputStream;
        }
        if (this.contentDecoded) {
            String string;
            String string2 = this.getHeaderField("Content-Transfer-Encoding");
            if ("base64".equalsIgnoreCase(string2)) {
                this.inputStream = new Base64InputStream(this.inputStream);
            }
            if ((string = this.getHeaderField("Content-Encoding")) == null || string.length() == 0 || "none".equalsIgnoreCase(string)) {
                this.convertedInputStream = this.inputStream;
                return this.convertedInputStream;
            } else if ("gzip".equalsIgnoreCase(string)) {
                this.convertedInputStream = new GZIPInputStream(this.inputStream);
                return this.convertedInputStream;
            } else {
                if (!"deflate".equalsIgnoreCase(string)) throw new UnsupportedOperationException("Encoding " + string + " not supported!");
                this.convertedInputStream = new DeflaterInputStream(this.inputStream);
            }
            return this.convertedInputStream;
        } else {
            this.convertedInputStream = this.inputStream;
        }
        return this.convertedInputStream;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        this.connect();
        if (this.outputClosed) {
            throw new IOException("OutputStream no longer available");
        }
        return this.outputStream;
    }

    @Override
    public long[] getRange() {
        if (this.ranges != null) {
            return this.ranges;
        }
        String string = this.getHeaderField("Content-Range");
        if (string == null) {
            return null;
        }
        String[] stringArray = new Regex(string, ".*?(\\d+).*?-.*?(\\d+).*?/.*?(\\d+)").getRow(0);
        if (stringArray == null) {
            System.err.print(this + "");
            return null;
        }
        this.ranges = new long[]{Long.parseLong(stringArray[0]), Long.parseLong(stringArray[1]), Long.parseLong(stringArray[2])};
        return this.ranges;
    }

    protected String getRequestInfo() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("-->Host:").append(this.getURL().getHost()).append("\r\n");
        if (this.connectedInetSocketAddress != null && this.connectedInetSocketAddress.getAddress() != null) {
            stringBuilder.append("-->HostIP:").append(this.connectedInetSocketAddress.getAddress().getHostAddress()).append("\r\n");
        }
        if (this.proxyInetSocketAddress != null && this.proxyInetSocketAddress.getAddress() != null) {
            stringBuilder.append("-->LocalIP:").append(this.proxyInetSocketAddress.getAddress().getHostAddress()).append("\r\n");
        }
        stringBuilder.append("----------------Request-------------------------\r\n");
        stringBuilder.append(this.httpMethod.toString()).append(' ').append(this.httpPath).append(" HTTP/1.1\r\n");
        for (String string : this.getRequestProperties().keySet()) {
            String string2 = this.getRequestProperties().get(string);
            if (string2 == null) continue;
            stringBuilder.append(string);
            stringBuilder.append(": ");
            stringBuilder.append(string2);
            stringBuilder.append("\r\n");
        }
        return stringBuilder.toString();
    }

    @Override
    public HTTPConnection.RequestMethod getRequestMethod() {
        return this.httpMethod;
    }

    @Override
    public Map<String, String> getRequestProperties() {
        return this.requestProperties;
    }

    @Override
    public String getRequestProperty(String string) {
        return this.requestProperties.get(string);
    }

    @Override
    public long getRequestTime() {
        return this.requestTime;
    }

    @Override
    public int getResponseCode() {
        return this.httpResponseCode;
    }

    protected String getResponseInfo() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("----------------Response------------------------\r\n");
        try {
            if (this.isConnected()) {
                this.connectInputStream();
                stringBuilder.append(this.httpHeader).append("\r\n");
                for (Map.Entry<String, List<String>> entry : this.getHeaderFields().entrySet()) {
                    for (int i = entry.getValue().size() - 1; i >= 0; --i) {
                        if (entry.getKey() == null) {
                            stringBuilder.append(entry.getValue().get(i));
                            stringBuilder.append("\r\n");
                            continue;
                        }
                        stringBuilder.append(entry.getKey());
                        stringBuilder.append(": ");
                        stringBuilder.append(entry.getValue().get(i));
                        stringBuilder.append("\r\n");
                    }
                }
                stringBuilder.append("------------------------------------------------\r\n");
            } else {
                stringBuilder.append("-------------not connected yet------------------");
            }
        }
        catch (IOException iOException) {
            stringBuilder.append("----------no InputStream available--------------");
        }
        stringBuilder.append("\r\n");
        return stringBuilder.toString();
    }

    @Override
    public String getResponseMessage() {
        return this.httpResponseMessage;
    }

    @Override
    public URL getURL() {
        return this.httpURL;
    }

    @Override
    public boolean isConnected() {
        return this.httpSocket != null && this.httpSocket.isConnected();
    }

    @Override
    public boolean isContentDecoded() {
        return this.contentDecoded;
    }

    @Override
    public boolean isContentDisposition() {
        return this.getHeaderField("Content-Disposition") != null;
    }

    @Override
    public boolean isOK() {
        return this.getResponseCode() > -2 && this.getResponseCode() < 400;
    }

    protected boolean isResponseCodeAllowed(int n) {
        for (int n2 : this.allowedResponseCodes) {
            if (n2 != n) continue;
            return true;
        }
        return false;
    }

    protected void sendRequest() throws UnsupportedEncodingException, IOException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.httpMethod.name()).append(' ').append(this.httpPath).append(" HTTP/1.1\r\n");
        boolean bl = false;
        for (String string : this.requestProperties.keySet()) {
            if (!"Host".equalsIgnoreCase(string)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            this.addHostHeader();
        }
        for (String string : this.requestProperties.keySet()) {
            if (this.requestProperties.get(string) == null) continue;
            if ("Content-Length".equalsIgnoreCase(string)) {
                this.postTodoLength = Long.parseLong(this.requestProperties.get(string));
            }
            stringBuilder.append(string).append(": ").append(this.requestProperties.get(string)).append("\r\n");
        }
        stringBuilder.append("\r\n");
        this.httpSocket.getOutputStream().write(stringBuilder.toString().getBytes("ISO-8859-1"));
        this.httpSocket.getOutputStream().flush();
        if (this.httpMethod != HTTPConnection.RequestMethod.POST) {
            this.outputStream = this.httpSocket.getOutputStream();
            this.outputClosed = true;
            this.connectInputStream();
        } else {
            this.outputStream = new CountingOutputStream(this.httpSocket.getOutputStream());
        }
    }

    @Override
    public void setAllowedResponseCodes(int[] nArray) {
        if (nArray == null) {
            throw new IllegalArgumentException("codes==null");
        }
        this.allowedResponseCodes = nArray;
    }

    @Override
    public void setCharset(String string) {
        this.customcharset = string;
    }

    @Override
    public void setConnectTimeout(int n) {
        this.connectTimeout = n;
    }

    @Override
    public void setContentDecoded(boolean bl) {
        if (this.convertedInputStream != null) {
            throw new IllegalStateException("InputStream already in use!");
        }
        this.contentDecoded = bl;
    }

    @Override
    public void setReadTimeout(int n) {
        try {
            if (this.isConnected()) {
                this.httpSocket.setSoTimeout(n);
            }
            this.readTimeout = n;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    @Override
    public void setRequestMethod(HTTPConnection.RequestMethod requestMethod) {
        this.httpMethod = requestMethod;
    }

    @Override
    public void setRequestProperty(String string, String string2) {
        this.requestProperties.put(string, string2);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getRequestInfo());
        stringBuilder.append(this.getResponseInfo());
        return stringBuilder.toString();
    }
}

