/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net.throttledconnection;

import java.io.OutputStream;
import org.appwork.utils.net.throttledconnection.ThrottledOutputStream;
import org.appwork.utils.speedmeter.SpeedMeterInterface;

public class MeteredThrottledOutputStream
extends ThrottledOutputStream
implements SpeedMeterInterface {
    private SpeedMeterInterface speedmeter = null;
    private long time = 0L;
    private long speed = 0L;
    private long lastTime;
    private long lastTrans;
    private long transferedCounter3;
    private final Object LOCK = new Object();

    public MeteredThrottledOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    public MeteredThrottledOutputStream(OutputStream outputStream, SpeedMeterInterface speedMeterInterface) {
        super(outputStream);
        this.speedmeter = speedMeterInterface;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getSpeedMeter() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.time == 0L) {
                this.time = System.currentTimeMillis();
                this.transferedCounter3 = this.transferedCounter;
                return 0L;
            }
            if (System.currentTimeMillis() - this.time < 1000L) {
                if (this.speedmeter != null) {
                    return this.speedmeter.getSpeedMeter();
                }
                return this.speed;
            }
            this.lastTime = System.currentTimeMillis() - this.time;
            this.time = System.currentTimeMillis();
            this.lastTrans = this.transferedCounter - this.transferedCounter3;
            this.transferedCounter3 = this.transferedCounter;
            if (this.speedmeter != null) {
                this.speedmeter.putSpeedMeter(this.lastTrans, this.lastTime);
                this.speed = this.speedmeter.getSpeedMeter();
                return this.speed;
            }
            this.speed = this.lastTrans / this.lastTime * 1000L;
            return this.speed;
        }
    }

    @Override
    public void putSpeedMeter(long l, long l2) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetSpeedMeter() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.speedmeter != null) {
                this.speedmeter.resetSpeedMeter();
            }
            this.time = System.currentTimeMillis();
            this.speed = 0L;
            this.transferedCounter3 = this.transferedCounter;
        }
    }
}

