/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net.throttledconnection;

import java.io.IOException;
import java.io.InputStream;
import org.appwork.utils.net.throttledconnection.ThrottledConnection;
import org.appwork.utils.net.throttledconnection.ThrottledConnectionHandler;

public class ThrottledInputStream
extends InputStream
implements ThrottledConnection {
    private ThrottledConnectionHandler handler;
    private final InputStream in;
    protected volatile long transferedCounter = 0L;
    protected volatile long transferedCounter2 = 0L;
    private volatile int limitCurrent = 0;
    private int limitCounter = 0;
    private int lastRead2;
    private long slotTimeLeft = 0L;
    private long lastTimeRead = 0L;

    public ThrottledInputStream(InputStream inputStream) {
        this.in = inputStream;
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.handler != null) {
            this.handler.removeThrottledConnection(this);
            this.handler = null;
        }
        ThrottledInputStream throttledInputStream = this;
        synchronized (throttledInputStream) {
            this.notify();
        }
        this.in.close();
    }

    @Override
    public ThrottledConnectionHandler getHandler() {
        return this.handler;
    }

    @Override
    public int getLimit() {
        return this.limitCurrent;
    }

    @Override
    public synchronized void mark(int n) {
        this.in.mark(n);
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        this.lastRead2 = this.in.read();
        if (this.lastRead2 == -1) {
            return -1;
        }
        ++this.transferedCounter;
        if (this.limitCurrent != 0) {
            --this.limitCounter;
            this.slotTimeLeft = 0L;
            if (this.limitCounter <= 0 && (this.slotTimeLeft = System.currentTimeMillis() - this.lastTimeRead) < 1000L) {
                ThrottledInputStream throttledInputStream = this;
                synchronized (throttledInputStream) {
                    try {
                        this.wait(1000L - this.slotTimeLeft);
                    }
                    catch (InterruptedException interruptedException) {
                        throw new IOException("throttle interrupted", interruptedException);
                    }
                }
                this.limitCounter = this.limitCurrent;
            } else if (this.slotTimeLeft > 1000L) {
                this.limitCounter = this.limitCurrent;
            }
            this.lastTimeRead = System.currentTimeMillis();
        }
        return this.lastRead2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.limitCurrent == 0) {
            this.lastRead2 = this.in.read(byArray, n, n2);
            if (this.lastRead2 == -1) {
                return -1;
            }
            this.transferedCounter += (long)this.lastRead2;
        } else {
            this.slotTimeLeft = 0L;
            if (this.limitCounter <= 0 && (this.slotTimeLeft = System.currentTimeMillis() - this.lastTimeRead) < 1000L) {
                ThrottledInputStream throttledInputStream = this;
                synchronized (throttledInputStream) {
                    try {
                        this.wait(1000L - this.slotTimeLeft);
                    }
                    catch (InterruptedException interruptedException) {
                        throw new IOException("throttle interrupted", interruptedException);
                    }
                }
                this.limitCounter = this.limitCurrent;
                if (this.limitCounter <= 0) {
                    this.limitCounter = n2;
                }
            } else if (this.slotTimeLeft > 1000L) {
                this.limitCounter = this.limitCurrent;
                if (this.limitCounter <= 0) {
                    this.limitCounter = n2;
                }
            }
            this.lastRead2 = this.in.read(byArray, n, Math.min(this.limitCounter, n2));
            if (this.lastRead2 == -1) {
                return -1;
            }
            this.transferedCounter += (long)this.lastRead2;
            this.limitCounter -= this.lastRead2;
            this.lastTimeRead = System.currentTimeMillis();
        }
        return this.lastRead2;
    }

    @Override
    public synchronized void reset() throws IOException {
        this.in.reset();
    }

    @Override
    public void setHandler(ThrottledConnectionHandler throttledConnectionHandler) {
        if (this.handler != null && this.handler != throttledConnectionHandler) {
            this.handler.removeThrottledConnection(this);
        }
        this.handler = throttledConnectionHandler;
        if (this.handler != null) {
            this.handler.addThrottledConnection(this);
        }
    }

    @Override
    public void setLimit(int n) {
        if (n == this.limitCurrent) {
            return;
        }
        this.limitCurrent = Math.max(0, n);
    }

    @Override
    public long skip(long l) throws IOException {
        return this.in.skip(l);
    }

    @Override
    public long transfered() {
        return this.transferedCounter;
    }
}

