/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.speedmeter;

import org.appwork.utils.speedmeter.SpeedMeterInterface;

public class AverageSpeedMeter
implements SpeedMeterInterface {
    private final long[] bytes;
    private final long[] times;
    private final int size;
    private int index;
    private boolean changed = false;
    private long speed = 0L;
    private final Object LOCK = new Object();
    private long stalled = 0L;
    private long timeout = -1L;

    public AverageSpeedMeter() {
        this(5);
    }

    public AverageSpeedMeter(int n) {
        this.size = n;
        this.bytes = new long[this.size];
        this.times = new long[this.size];
        this.index = 0;
        this.resetSpeedMeter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getSpeedMeter() {
        Object object = this.LOCK;
        synchronized (object) {
            if (!this.changed) {
                return this.speed;
            }
            long l = 0L;
            long l2 = this.stalled;
            for (int i = 0; i < this.size; ++i) {
                if (this.bytes[i] < 0L) continue;
                l += this.bytes[i];
                l2 += this.times[i];
            }
            if (l2 >= 1000L) {
                this.speed = l * 1000L / l2;
            }
            this.changed = false;
            return this.speed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putSpeedMeter(long l, long l2) {
        Object object = this.LOCK;
        synchronized (object) {
            long l3 = Math.max(0L, l);
            if (l3 == 0L) {
                this.stalled += Math.max(0L, l2);
                if (this.timeout > 0L && this.stalled > this.timeout) {
                    this.resetSpeedMeter();
                }
            } else {
                this.bytes[this.index] = l3;
                this.times[this.index] = Math.max(0L, l2) + this.stalled;
                this.stalled = 0L;
                ++this.index;
                if (this.index == this.size) {
                    this.index = 0;
                }
            }
            this.changed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetSpeedMeter() {
        Object object = this.LOCK;
        synchronized (object) {
            this.index = 0;
            while (this.index < this.size) {
                this.bytes[this.index] = -1L;
                this.times[this.index] = 0L;
                ++this.index;
            }
            this.index = 0;
            this.speed = 0L;
            this.changed = true;
        }
    }

    public void setStallTimeout(long l) {
        this.timeout = l <= 0L ? -1L : l;
    }
}

