/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.controller;

import java.lang.reflect.Constructor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jd.PluginWrapper;
import jd.plugins.Plugin;
import org.appwork.exceptions.WTFException;
import org.jdownloader.plugins.controller.PluginClassLoader;

public abstract class LazyPlugin<T extends Plugin> {
    private static final Object[] EMPTY = new Object[0];
    private long version;
    private Pattern pattern;
    private String classname;
    private String displayName;
    protected Class<T> pluginClass;
    private Constructor<T> constructor;
    private Object[] constructorParameters;
    protected T prototypeInstance;
    private final PluginClassLoader.PluginClassLoaderChild classLoader;

    public LazyPlugin(String string, String string2, String string3, long l, Class<T> clazz, PluginClassLoader.PluginClassLoaderChild pluginClassLoaderChild) {
        this.pattern = Pattern.compile(string, 2);
        this.pluginClass = clazz;
        this.classname = string2;
        this.displayName = string3;
        this.version = l;
        this.classLoader = pluginClassLoaderChild;
    }

    public long getVersion() {
        return this.version;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getClassname() {
        return this.classname;
    }

    public boolean canHandle(String string) {
        Pattern pattern = this.getPattern();
        if (pattern != null) {
            Matcher matcher = pattern.matcher(string);
            return matcher.find();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getPrototype() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null && classLoader != this.classLoader && classLoader instanceof PluginClassLoader.PluginClassLoaderChild) {
            return this.newInstance();
        }
        if (this.prototypeInstance != null) {
            return this.prototypeInstance;
        }
        LazyPlugin lazyPlugin = this;
        synchronized (lazyPlugin) {
            if (this.prototypeInstance != null) {
                return this.prototypeInstance;
            }
            this.prototypeInstance = this.newInstance();
        }
        return this.prototypeInstance;
    }

    public T newInstance() {
        try {
            Constructor<T> constructor = this.getConstructor(this.getPluginClass());
            return (T)((Plugin)constructor.newInstance(this.constructorParameters));
        }
        catch (Throwable throwable) {
            throw new WTFException(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Constructor<T> getConstructor(Class<T> clazz) {
        if (clazz != this.pluginClass) {
            try {
                Constructor<T> constructor = clazz.getConstructor(new Class[0]);
                this.constructorParameters = EMPTY;
                return constructor;
            }
            catch (Throwable throwable) {
                try {
                    Constructor<T> constructor = clazz.getConstructor(PluginWrapper.class);
                    this.constructorParameters = new Object[]{new PluginWrapper(this){}};
                    return constructor;
                }
                catch (Throwable throwable2) {
                    throw new WTFException(throwable2);
                }
            }
        }
        if (this.constructor != null) {
            return this.constructor;
        }
        LazyPlugin lazyPlugin = this;
        synchronized (lazyPlugin) {
            if (this.constructor != null) {
                return this.constructor;
            }
            try {
                this.constructor = clazz.getConstructor(new Class[0]);
                this.constructorParameters = EMPTY;
            }
            catch (Throwable throwable) {
                try {
                    this.constructor = clazz.getConstructor(PluginWrapper.class);
                    this.constructorParameters = new Object[]{new PluginWrapper(this){}};
                }
                catch (Throwable throwable3) {
                    throw new WTFException(throwable3);
                }
            }
            return this.constructor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class<T> getPluginClass() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null && classLoader != this.classLoader && classLoader instanceof PluginClassLoader.PluginClassLoaderChild) {
            try {
                return classLoader.loadClass(this.classname);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                throw new WTFException(throwable);
            }
        }
        if (this.pluginClass != null) {
            return this.pluginClass;
        }
        LazyPlugin lazyPlugin = this;
        synchronized (lazyPlugin) {
            if (this.pluginClass != null) {
                return this.pluginClass;
            }
            try {
                this.pluginClass = this.classLoader.loadClass(this.classname);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                throw new WTFException(throwable);
            }
            return this.pluginClass;
        }
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public PluginClassLoader.PluginClassLoaderChild getClassLoader() {
        return this.classLoader;
    }
}

