/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.controller.container;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jd.plugins.PluginsC;
import org.appwork.utils.Regex;
import org.appwork.utils.logging.Log;
import org.jdownloader.container.AMZ;
import org.jdownloader.container.C;
import org.jdownloader.container.R;

public class ContainerPluginController {
    private static final ContainerPluginController INSTANCE = new ContainerPluginController();
    private List<PluginsC> list = null;

    public static ContainerPluginController getInstance() {
        return INSTANCE;
    }

    private ContainerPluginController() {
    }

    public void init() {
        ArrayList<PluginsC> arrayList = new ArrayList<PluginsC>();
        try {
            arrayList.add(new AMZ());
            arrayList.add(new C());
            arrayList.add(new R());
        }
        catch (Throwable throwable) {
            Log.exception(throwable);
        }
        this.list = Collections.unmodifiableList(arrayList);
    }

    public List<PluginsC> list() {
        this.lazyInit();
        return this.list;
    }

    public void setList(List<PluginsC> list) {
        if (list == null) {
            return;
        }
        this.list = list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lazyInit() {
        if (this.list != null) {
            return;
        }
        ContainerPluginController containerPluginController = this;
        synchronized (containerPluginController) {
            if (this.list != null) {
                return;
            }
            this.init();
        }
    }

    public PluginsC get(String string) {
        this.lazyInit();
        for (PluginsC pluginsC : this.list) {
            if (!pluginsC.getName().equalsIgnoreCase(string)) continue;
            return pluginsC;
        }
        return null;
    }

    public String getContainerExtensions(String string) {
        this.lazyInit();
        StringBuilder stringBuilder = new StringBuilder("");
        for (PluginsC pluginsC : this.list) {
            String[] stringArray;
            if (string != null && !new Regex(pluginsC.getName(), string).matches()) continue;
            for (String string2 : stringArray = new Regex(pluginsC.getSupportedLinks().pattern(), "\\.([a-zA-Z0-9]+)").getColumn(0)) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append("|");
                }
                stringBuilder.append(".").append(string2);
            }
        }
        return stringBuilder.toString();
    }
}

