/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.controller.host;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import jd.JDInitFlags;
import jd.nutils.Formatter;
import jd.nutils.encoding.Encoding;
import jd.plugins.HostPlugin;
import jd.plugins.PluginForHost;
import org.appwork.exceptions.WTFException;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.TypeRef;
import org.appwork.utils.Application;
import org.appwork.utils.logging.Log;
import org.jdownloader.plugins.controller.PluginClassLoader;
import org.jdownloader.plugins.controller.PluginController;
import org.jdownloader.plugins.controller.PluginInfo;
import org.jdownloader.plugins.controller.host.AbstractHostPlugin;
import org.jdownloader.plugins.controller.host.LazyHostPlugin;

public class HostPluginController
extends PluginController<PluginForHost> {
    private static final String HTTP_JDOWNLOADER_ORG_R_PHP_U = "http://jdownloader.org/r.php?u=";
    private static final HostPluginController INSTANCE = new HostPluginController();
    private List<LazyHostPlugin> list = null;

    public static HostPluginController getInstance() {
        return INSTANCE;
    }

    private String getCache() {
        return "tmp/hosts.json";
    }

    private HostPluginController() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(boolean bl) {
        List<Object> list;
        block14: {
            list = new ArrayList();
            long l = System.currentTimeMillis();
            try {
                if (bl) {
                    try {
                        list = this.update();
                    }
                    catch (Throwable throwable) {
                        Log.L.severe("@HostPluginController: update failed!");
                        Log.exception(throwable);
                    }
                    break block14;
                }
                try {
                    list = this.loadFromCache();
                }
                catch (Throwable throwable) {
                    Log.L.severe("@HostPluginController: cache failed!");
                    Log.exception(throwable);
                }
                if (list.size() == 0) {
                    try {
                        list = this.update();
                    }
                    catch (Throwable throwable) {
                        Log.L.severe("@HostPluginController: update failed!");
                        Log.exception(throwable);
                    }
                }
            }
            finally {
                Log.L.info("@HostPluginController: init " + (System.currentTimeMillis() - l) + " :" + list.size());
            }
        }
        if (list.size() == 0) {
            Log.L.severe("@HostPluginController: WTF, no plugins!");
        }
        try {
            Collections.sort(list, new Comparator<LazyHostPlugin>(){

                @Override
                public int compare(LazyHostPlugin lazyHostPlugin, LazyHostPlugin lazyHostPlugin2) {
                    return lazyHostPlugin.getDisplayName().compareTo(lazyHostPlugin2.getDisplayName());
                }
            });
        }
        catch (Throwable throwable) {
            Log.exception(throwable);
        }
        this.list = list;
        System.gc();
    }

    private List<LazyHostPlugin> loadFromCache() {
        ArrayList<AbstractHostPlugin> arrayList = JSonStorage.restoreFrom(Application.getResource(this.getCache()), true, null, new TypeRef<ArrayList<AbstractHostPlugin>>(){}, new ArrayList());
        ArrayList<LazyHostPlugin> arrayList2 = new ArrayList<LazyHostPlugin>(arrayList.size());
        PluginClassLoader.PluginClassLoaderChild pluginClassLoaderChild = PluginClassLoader.getInstance().getChild();
        for (AbstractHostPlugin abstractHostPlugin : arrayList) {
            arrayList2.add(new LazyHostPlugin(abstractHostPlugin, null, pluginClassLoaderChild));
        }
        return arrayList2;
    }

    private List<LazyHostPlugin> update() throws MalformedURLException {
        ArrayList<LazyHostPlugin> arrayList = new ArrayList<LazyHostPlugin>();
        ArrayList<AbstractHostPlugin> arrayList2 = new ArrayList<AbstractHostPlugin>();
        PluginClassLoader.PluginClassLoaderChild pluginClassLoaderChild = PluginClassLoader.getInstance().getChild();
        for (PluginInfo pluginInfo : this.scan("jd/plugins/hoster")) {
            String string = pluginInfo.getClazz().getSimpleName();
            HostPlugin hostPlugin = pluginInfo.getClazz().getAnnotation(HostPlugin.class);
            if (hostPlugin != null) {
                try {
                    long l = Formatter.getRevision(hostPlugin.revision());
                    String[] stringArray = hostPlugin.names();
                    String[] stringArray2 = hostPlugin.urls();
                    if (stringArray.length == 0) {
                        stringArray2 = (String[])pluginInfo.getClazz().getDeclaredMethod("getAnnotationUrls", new Class[0]).invoke(null, new Object[0]);
                        stringArray = (String[])pluginInfo.getClazz().getDeclaredMethod("getAnnotationNames", new Class[0]).invoke(null, new Object[0]);
                    }
                    if (stringArray2.length != stringArray.length) {
                        throw new WTFException("names.length != patterns.length");
                    }
                    if (stringArray.length == 0) {
                        throw new WTFException("names.length=0");
                    }
                    for (int i = 0; i < stringArray.length; ++i) {
                        try {
                            AbstractHostPlugin abstractHostPlugin = new AbstractHostPlugin(new String(pluginInfo.getClazz().getSimpleName()));
                            abstractHostPlugin.setDisplayName(new String(stringArray[i]));
                            abstractHostPlugin.setPattern(new String(stringArray2[i]));
                            abstractHostPlugin.setVersion(l);
                            LazyHostPlugin lazyHostPlugin = new LazyHostPlugin(abstractHostPlugin, null, pluginClassLoaderChild);
                            PluginForHost pluginForHost = lazyHostPlugin.newInstance();
                            abstractHostPlugin.setPremium(pluginForHost.isPremiumEnabled());
                            String string2 = pluginForHost.getBuyPremiumUrl();
                            if (string2 != null) {
                                string2 = new String(string2);
                            }
                            if (string2 != null && string2.startsWith(HTTP_JDOWNLOADER_ORG_R_PHP_U)) {
                                string2 = Encoding.urlDecode(string2.substring(HTTP_JDOWNLOADER_ORG_R_PHP_U.length()), false);
                            }
                            abstractHostPlugin.setPremiumUrl(string2);
                            abstractHostPlugin.setHasConfig(pluginForHost.hasConfig());
                            lazyHostPlugin.setHasConfig(pluginForHost.hasConfig());
                            lazyHostPlugin.setPremium(abstractHostPlugin.isPremium());
                            lazyHostPlugin.setPremiumUrl(string2);
                            arrayList.add(lazyHostPlugin);
                            arrayList2.add(abstractHostPlugin);
                            Log.L.finer("@HostPlugin ok:" + string + " " + stringArray[i]);
                            continue;
                        }
                        catch (Throwable throwable) {
                            Log.L.severe("@HostPlugin failed:" + string + " " + stringArray[i]);
                            Log.exception(throwable);
                        }
                    }
                    continue;
                }
                catch (Throwable throwable) {
                    Log.L.severe("@HostPlugin failed:" + string);
                    Log.exception(throwable);
                    continue;
                }
            }
            Log.L.severe("@HostPlugin missing:" + string);
        }
        this.save(arrayList2);
        return arrayList;
    }

    private void save(List<AbstractHostPlugin> list) {
        JSonStorage.saveTo(Application.getResource(this.getCache()), list);
    }

    public List<LazyHostPlugin> list() {
        this.ensureLoaded();
        return this.list;
    }

    public void setList(List<LazyHostPlugin> list) {
        if (list == null) {
            return;
        }
        try {
            Collections.sort(list, new Comparator<LazyHostPlugin>(){

                @Override
                public int compare(LazyHostPlugin lazyHostPlugin, LazyHostPlugin lazyHostPlugin2) {
                    return lazyHostPlugin.getDisplayName().compareTo(lazyHostPlugin2.getDisplayName());
                }
            });
        }
        catch (Throwable throwable) {
            Log.exception(throwable);
        }
        this.list = list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureLoaded() {
        if (this.list != null) {
            return;
        }
        HostPluginController hostPluginController = this;
        synchronized (hostPluginController) {
            if (this.list != null) {
                return;
            }
            this.init(JDInitFlags.REFRESH_CACHE || JDInitFlags.SWITCH_RETURNED_FROM_UPDATE);
        }
    }

    public LazyHostPlugin get(String string) {
        this.ensureLoaded();
        List<LazyHostPlugin> list = this.list;
        for (LazyHostPlugin lazyHostPlugin : list) {
            if (!lazyHostPlugin.getDisplayName().equalsIgnoreCase(string)) continue;
            return lazyHostPlugin;
        }
        return null;
    }
}

