/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.utils;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.jcip.annotations.Immutable;

@Immutable
public class CloneUtils {
    public static Object clone(Object object) throws CloneNotSupportedException {
        if (object == null) {
            return null;
        }
        if (object instanceof Cloneable) {
            Method method;
            Class<?> clazz = object.getClass();
            try {
                method = clazz.getMethod("clone", null);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new NoSuchMethodError(noSuchMethodException.getMessage());
            }
            try {
                return method.invoke(object, (Object[])null);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getCause();
                if (throwable instanceof CloneNotSupportedException) {
                    throw (CloneNotSupportedException)throwable;
                }
                throw new Error("Unexpected exception", throwable);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IllegalAccessError(illegalAccessException.getMessage());
            }
        }
        throw new CloneNotSupportedException();
    }

    private CloneUtils() {
    }
}

